/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver;

import java.util.HashMap;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.chocosolver.memory.ICondition;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.search.strategy.Search;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.util.ESat;

public class Settings {
    private Predicate<Solver> modelChecker = s2 -> !ESat.FALSE.equals((Object)s2.isSatisfied());
    private boolean cloneVariableArrayInPropagator = true;
    private boolean enableViews = true;
    private int maxDomSizeForEnumerated = 65536;
    private int minCardForSumDecomposition = 50;
    private boolean enableTableSubstitution = true;
    private int maxTupleSizeForSubstitution = 10000;
    private boolean sortPropagatorActivationWRTPriority = true;
    private int maxPropagatorPriority = PropagatorPriority.VERY_SLOW.getValue();
    private Function<Model, AbstractStrategy<?>> defaultSearch = Search::defaultSearch;
    private boolean warnUser = false;
    private boolean enableDecompositionOfBooleanSum = false;
    private IntPredicate enableIncrementalityOnBoolSum = i -> i > 10;
    private boolean enableSAT = false;
    private boolean swapOnPassivate = false;
    private boolean checkDeclaredConstraints = true;
    private boolean checkDeclaredViews = true;
    private boolean checkDeclaredMonitors = true;
    private boolean printAllUndeclaredConstraints = false;
    private byte hybridEngine = 0;
    private int nbMaxLearnt = 100000;
    private int maxLearntCardinlity = 21474836;
    private float clauseReductionRatio = 0.5f;
    private int dominancePerimeter = 4;
    private boolean explainGlobalFailureInSum = true;
    private double ibexContractionRatio = 0.01;
    private boolean ibexRestoreRounding = false;
    private Function<Model, Solver> initSolver = Solver::new;
    private final HashMap<String, Object> additionalSettings = new HashMap();

    private Settings() {
    }

    public static Settings init() {
        return new Settings();
    }

    public static Settings prod() {
        return Settings.init().setModelChecker(s2 -> true).setWarnUser(false).setCheckDeclaredConstraints(false).setCheckDeclaredViews(false).setCheckDeclaredMonitors(false).setPrintAllUndeclaredConstraints(false);
    }

    public static Settings dev() {
        return Settings.init().setModelChecker(s2 -> !ESat.FALSE.equals((Object)s2.isSatisfied())).setWarnUser(true).setCheckDeclaredConstraints(true).setCheckDeclaredViews(true).setCheckDeclaredMonitors(true).setPrintAllUndeclaredConstraints(true);
    }

    public boolean checkModel(Solver solver) {
        return this.modelChecker.test(solver);
    }

    public Settings setModelChecker(Predicate<Solver> modelChecker) {
        this.modelChecker = modelChecker;
        return this;
    }

    public boolean cloneVariableArrayInPropagator() {
        return this.cloneVariableArrayInPropagator;
    }

    public Settings setCloneVariableArrayInPropagator(boolean cloneVariableArrayInPropagator) {
        this.cloneVariableArrayInPropagator = cloneVariableArrayInPropagator;
        return this;
    }

    public boolean enableViews() {
        return this.enableViews;
    }

    public Settings setEnableViews(boolean enableViews) {
        this.enableViews = enableViews;
        return this;
    }

    public int getMaxDomSizeForEnumerated() {
        return this.maxDomSizeForEnumerated;
    }

    public Settings setMaxDomSizeForEnumerated(int maxDomSizeForEnumerated) {
        this.maxDomSizeForEnumerated = maxDomSizeForEnumerated;
        return this;
    }

    public int getMinCardForSumDecomposition() {
        return this.minCardForSumDecomposition;
    }

    public Settings setMinCardinalityForSumDecomposition(int defaultMinCardinalityForSumDecomposition) {
        this.minCardForSumDecomposition = defaultMinCardinalityForSumDecomposition;
        return this;
    }

    public boolean enableTableSubstitution() {
        return this.enableTableSubstitution;
    }

    public Settings setEnableTableSubstitution(boolean enableTableSubstitution) {
        this.enableTableSubstitution = enableTableSubstitution;
        return this;
    }

    public int getMaxTupleSizeForSubstitution() {
        return this.maxTupleSizeForSubstitution;
    }

    public Settings setMaxTupleSizeForSubstitution(int maxTupleSizeForSubstitution) {
        this.maxTupleSizeForSubstitution = maxTupleSizeForSubstitution;
        return this;
    }

    public boolean sortPropagatorActivationWRTPriority() {
        return this.sortPropagatorActivationWRTPriority;
    }

    public Settings setSortPropagatorActivationWRTPriority(boolean sortPropagatorActivationWRTPriority) {
        this.sortPropagatorActivationWRTPriority = sortPropagatorActivationWRTPriority;
        return this;
    }

    public int getMaxPropagatorPriority() {
        return this.maxPropagatorPriority;
    }

    public Settings setMaxPropagatorPriority(int maxPropagatorPriority) {
        this.maxPropagatorPriority = maxPropagatorPriority;
        return this;
    }

    public AbstractStrategy<?> makeDefaultSearch(Model model) {
        return this.defaultSearch.apply(model);
    }

    public Settings setDefaultSearch(Function<Model, AbstractStrategy<?>> defaultSearch) {
        this.defaultSearch = defaultSearch;
        return this;
    }

    @Deprecated
    public ICondition getEnvironmentHistorySimulationCondition() {
        return null;
    }

    @Deprecated
    public Settings setEnvironmentHistorySimulationCondition(ICondition environmentHistorySimulationCondition) {
        return null;
    }

    public boolean warnUser() {
        return this.warnUser;
    }

    public Settings setWarnUser(boolean warnUser) {
        this.warnUser = warnUser;
        return this;
    }

    public boolean enableDecompositionOfBooleanSum() {
        return this.enableDecompositionOfBooleanSum;
    }

    public Settings setEnableDecompositionOfBooleanSum(boolean enableDecompositionOfBooleanSum) {
        this.enableDecompositionOfBooleanSum = enableDecompositionOfBooleanSum;
        return this;
    }

    public boolean enableIncrementalityOnBoolSum(int nbvars) {
        return this.enableIncrementalityOnBoolSum.test(nbvars);
    }

    public Settings setEnableIncrementalityOnBoolSum(IntPredicate enableIncrementalityOnBoolSum) {
        this.enableIncrementalityOnBoolSum = enableIncrementalityOnBoolSum;
        return this;
    }

    public boolean enableSAT() {
        return this.enableSAT;
    }

    public Settings setEnableSAT(boolean enableSAT) {
        this.enableSAT = enableSAT;
        return this;
    }

    public boolean swapOnPassivate() {
        return this.swapOnPassivate;
    }

    public Settings setSwapOnPassivate(boolean swapOnPassivate) {
        this.swapOnPassivate = swapOnPassivate;
        return this;
    }

    public boolean checkDeclaredConstraints() {
        return this.checkDeclaredConstraints;
    }

    public Settings setCheckDeclaredConstraints(boolean checkDeclaredConstraints) {
        this.checkDeclaredConstraints = checkDeclaredConstraints;
        return this;
    }

    public boolean printAllUndeclaredConstraints() {
        return this.printAllUndeclaredConstraints;
    }

    public Settings setPrintAllUndeclaredConstraints(boolean printAllUndeclaredConstraints) {
        this.printAllUndeclaredConstraints = printAllUndeclaredConstraints;
        return this;
    }

    public boolean checkDeclaredViews() {
        return this.checkDeclaredViews;
    }

    public Settings setCheckDeclaredViews(boolean checkDeclaredViews) {
        this.checkDeclaredViews = checkDeclaredViews;
        return this;
    }

    public Settings setCheckDeclaredMonitors(boolean check) {
        this.checkDeclaredMonitors = check;
        return this;
    }

    public boolean checkDeclaredMonitors() {
        return this.checkDeclaredMonitors;
    }

    public Solver initSolver(Model model) {
        return this.initSolver.apply(model);
    }

    public Settings setInitSolver(Function<Model, Solver> initSolver) {
        this.initSolver = initSolver;
        return this;
    }

    public byte enableHybridizationOfPropagationEngine() {
        return this.hybridEngine;
    }

    public Settings setHybridizationOfPropagationEngine(byte hybrid) {
        this.hybridEngine = hybrid;
        return this;
    }

    public int getNbMaxLearntClauses() {
        return this.nbMaxLearnt;
    }

    public Settings setNbMaxLearntClauses(int n) {
        this.nbMaxLearnt = n;
        return this;
    }

    public float getRatioForClauseStoreReduction() {
        return this.clauseReductionRatio;
    }

    public Settings setRatioForClauseStoreReduction(float f) {
        this.clauseReductionRatio = f;
        return this;
    }

    public int getMaxLearntClauseCardinality() {
        return this.maxLearntCardinlity;
    }

    public Settings setMaxLearntClauseCardinality(int n) {
        this.maxLearntCardinlity = n;
        return this;
    }

    public int getLearntClausesDominancePerimeter() {
        return this.dominancePerimeter;
    }

    public Settings setLearntClausesDominancePerimeter(int n) {
        this.dominancePerimeter = n;
        return this;
    }

    public boolean explainGlobalFailureInSum() {
        return this.explainGlobalFailureInSum;
    }

    public Settings explainGlobalFailureInSum(boolean b2) {
        this.explainGlobalFailureInSum = b2;
        return this;
    }

    public double getIbexContractionRatio() {
        return this.ibexContractionRatio;
    }

    public void setIbexContractionRatio(double ibexContractionRatio) {
        this.ibexContractionRatio = ibexContractionRatio;
    }

    public Settings setIbexRestoreRounding(boolean ibexRestoreRounding) {
        this.ibexRestoreRounding = ibexRestoreRounding;
        return this;
    }

    public boolean getIbexRestoreRounding() {
        return this.ibexRestoreRounding;
    }

    public Object get(String key) {
        return this.additionalSettings.get(key);
    }

    public Settings set(String key, Object value) {
        this.additionalSettings.put(key, value);
        return this;
    }
}

