/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sum;

import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.nary.clauses.ClauseBuilder;
import org.chocosolver.solver.constraints.nary.sum.PropSum;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public class PropScalar
extends PropSum {
    private final int[] c;

    public PropScalar(IntVar[] variables, int[] coeffs, int pos, Operator o, int b2) {
        super(variables, pos, o, b2);
        this.c = coeffs;
    }

    @Override
    protected void prepare() {
        int ub;
        int lb;
        int i;
        this.sumUB = 0;
        this.sumLB = 0;
        this.maxI = 0;
        for (i = 0; i < this.pos; ++i) {
            lb = ((IntVar[])this.vars)[i].getLB() * this.c[i];
            ub = ((IntVar[])this.vars)[i].getUB() * this.c[i];
            this.sumLB += lb;
            this.sumUB += ub;
            this.I[i] = ub - lb;
            if (this.maxI >= this.I[i]) continue;
            this.maxI = this.I[i];
        }
        while (i < this.l) {
            lb = ((IntVar[])this.vars)[i].getUB() * this.c[i];
            ub = ((IntVar[])this.vars)[i].getLB() * this.c[i];
            this.sumLB += lb;
            this.sumUB += ub;
            this.I[i] = ub - lb;
            if (this.maxI < this.I[i]) {
                this.maxI = this.I[i];
            }
            ++i;
        }
    }

    @Override
    protected void filterOnEq() throws ContradictionException {
        boolean anychange;
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        do {
            anychange = false;
            if (this.model.getSolver().isLearnOff() && F2 < 0 || E < 0) {
                this.fails();
            }
            if (this.maxI > F2 || this.maxI > E) {
                int nlb;
                int nub;
                int ub;
                int lb;
                int i;
                this.maxI = 0;
                for (i = 0; i < this.pos; ++i) {
                    if (this.I[i] - F2 > 0) {
                        lb = ((IntVar[])this.vars)[i].getLB() * this.c[i];
                        ub = lb + this.I[i];
                        if (((IntVar[])this.vars)[i].updateUpperBound(this.divFloor(F2 + lb, this.c[i]), this)) {
                            nub = ((IntVar[])this.vars)[i].getUB() * this.c[i];
                            E += nub - ub;
                            this.I[i] = nub - lb;
                            anychange = true;
                        }
                    }
                    if (this.I[i] - E > 0) {
                        ub = ((IntVar[])this.vars)[i].getUB() * this.c[i];
                        lb = ub - this.I[i];
                        if (((IntVar[])this.vars)[i].updateLowerBound(this.divCeil(ub - E, this.c[i]), this)) {
                            nlb = ((IntVar[])this.vars)[i].getLB() * this.c[i];
                            F2 -= nlb - lb;
                            this.I[i] = ub - nlb;
                            anychange = true;
                        }
                    }
                    if (this.maxI >= this.I[i]) continue;
                    this.maxI = this.I[i];
                }
                while (i < this.l) {
                    if (this.I[i] - F2 > 0) {
                        lb = ((IntVar[])this.vars)[i].getUB() * this.c[i];
                        ub = lb + this.I[i];
                        if (((IntVar[])this.vars)[i].updateLowerBound(this.divCeil(-F2 - lb, -this.c[i]), this)) {
                            nub = ((IntVar[])this.vars)[i].getLB() * this.c[i];
                            E += nub - ub;
                            this.I[i] = nub - lb;
                            anychange = true;
                        }
                    }
                    if (this.I[i] - E > 0) {
                        ub = ((IntVar[])this.vars)[i].getLB() * this.c[i];
                        lb = ub - this.I[i];
                        if (((IntVar[])this.vars)[i].updateUpperBound(this.divFloor(-ub + E, -this.c[i]), this)) {
                            nlb = ((IntVar[])this.vars)[i].getUB() * this.c[i];
                            F2 -= nlb - lb;
                            this.I[i] = ub - nlb;
                            anychange = true;
                        }
                    }
                    if (this.maxI < this.I[i]) {
                        this.maxI = this.I[i];
                    }
                    ++i;
                }
            }
            if (F2 > 0 || E > 0) continue;
            this.setPassive();
            return;
        } while (anychange);
    }

    @Override
    protected void filterOnLeq() throws ContradictionException {
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        if (this.model.getSolver().isLearnOff() && F2 < 0) {
            this.fails();
        }
        if (this.maxI > F2) {
            int nub;
            int ub;
            int lb;
            int i;
            this.maxI = 0;
            for (i = 0; i < this.pos; ++i) {
                this.maxI = 0;
                if (this.I[i] - F2 > 0) {
                    lb = ((IntVar[])this.vars)[i].getLB() * this.c[i];
                    ub = lb + this.I[i];
                    if (((IntVar[])this.vars)[i].updateUpperBound(this.divFloor(F2 + lb, this.c[i]), this)) {
                        nub = ((IntVar[])this.vars)[i].getUB() * this.c[i];
                        E += nub - ub;
                        this.I[i] = nub - lb;
                    }
                }
                if (this.maxI >= this.I[i]) continue;
                this.maxI = this.I[i];
            }
            while (i < this.l) {
                if (this.I[i] - F2 > 0) {
                    lb = ((IntVar[])this.vars)[i].getUB() * this.c[i];
                    ub = lb + this.I[i];
                    if (((IntVar[])this.vars)[i].updateLowerBound(this.divCeil(-F2 - lb, -this.c[i]), this)) {
                        nub = ((IntVar[])this.vars)[i].getLB() * this.c[i];
                        E += nub - ub;
                        this.I[i] = nub - lb;
                    }
                }
                if (this.maxI < this.I[i]) {
                    this.maxI = this.I[i];
                }
                ++i;
            }
        }
        if (E <= 0) {
            this.setPassive();
        }
    }

    @Override
    protected void filterOnGeq() throws ContradictionException {
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        if (this.model.getSolver().isLearnOff() && E < 0) {
            this.fails();
        }
        if (this.maxI > E) {
            int nlb;
            int lb;
            int ub;
            int i;
            this.maxI = 0;
            for (i = 0; i < this.pos; ++i) {
                if (this.I[i] - E > 0) {
                    ub = ((IntVar[])this.vars)[i].getUB() * this.c[i];
                    lb = ub - this.I[i];
                    if (((IntVar[])this.vars)[i].updateLowerBound(this.divCeil(ub - E, this.c[i]), this)) {
                        nlb = ((IntVar[])this.vars)[i].getLB() * this.c[i];
                        F2 -= nlb - lb;
                        this.I[i] = ub - nlb;
                    }
                }
                if (this.maxI >= this.I[i]) continue;
                this.maxI = this.I[i];
            }
            while (i < this.l) {
                if (this.I[i] - E > 0) {
                    ub = ((IntVar[])this.vars)[i].getLB() * this.c[i];
                    lb = ub - this.I[i];
                    if (((IntVar[])this.vars)[i].updateUpperBound(this.divFloor(-ub + E, -this.c[i]), this)) {
                        nlb = ((IntVar[])this.vars)[i].getUB() * this.c[i];
                        F2 -= nlb - lb;
                        this.I[i] = ub - nlb;
                    }
                }
                if (this.maxI < this.I[i]) {
                    this.maxI = this.I[i];
                }
                ++i;
            }
        }
        if (F2 <= 0) {
            this.setPassive();
        }
    }

    @Override
    protected void filterOnNeq() throws ContradictionException {
        int F2 = this.b - this.sumLB;
        int E = this.sumUB - this.b;
        if (F2 < 0 || E < 0) {
            this.setPassive();
            return;
        }
        int w = -1;
        int sum = 0;
        for (int i = 0; i < this.l; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated()) {
                sum += ((IntVar[])this.vars)[i].getValue() * this.c[i];
                continue;
            }
            if (w == -1) {
                w = i;
                continue;
            }
            return;
        }
        if (w == -1) {
            if (sum == this.b) {
                this.fails();
            }
        } else if (this.c[w] != 0 && (this.b - sum) % this.c[w] == 0) {
            ((IntVar[])this.vars)[w].removeValue((this.b - sum) / this.c[w], this);
        }
    }

    @Override
    public ESat isEntailed() {
        int i;
        int sumUB = 0;
        int sumLB = 0;
        for (i = 0; i < this.pos; ++i) {
            sumLB += ((IntVar[])this.vars)[i].getLB() * this.c[i];
            sumUB += ((IntVar[])this.vars)[i].getUB() * this.c[i];
        }
        while (i < this.l) {
            sumLB += ((IntVar[])this.vars)[i].getUB() * this.c[i];
            sumUB += ((IntVar[])this.vars)[i].getLB() * this.c[i];
            ++i;
        }
        return this.check(sumLB, sumUB);
    }

    @Override
    void doExplain(ExplanationForSignedClause explanation, int p) {
        int max;
        int min2;
        int ub;
        int lb;
        IntIterableRangeSet dom_before;
        int i;
        IntVar pivot = explanation.readVar(p);
        int sumLB = 0;
        int sumUB = 0;
        int la = 0;
        int ua = 0;
        int ca = 0;
        int a2 = 0;
        for (i = 0; i < this.pos; ++i) {
            dom_before = explanation.readDom(((IntVar[])this.vars)[i]);
            lb = dom_before.min() * this.c[i];
            ub = dom_before.max() * this.c[i];
            if (((IntVar[])this.vars)[i] == pivot) {
                la = dom_before.min();
                ua = dom_before.max();
                ca = this.c[i];
                a2 = i;
            }
            sumLB += lb;
            sumUB += ub;
        }
        while (i < this.l) {
            dom_before = explanation.readDom(((IntVar[])this.vars)[i]);
            lb = dom_before.max() * this.c[i];
            ub = dom_before.min() * this.c[i];
            if (((IntVar[])this.vars)[i] == pivot) {
                la = dom_before.min();
                ua = dom_before.max();
                ca = this.c[i];
                a2 = i;
            }
            sumLB += lb;
            sumUB += ub;
            ++i;
        }
        int F2 = this.b - sumLB;
        int E = sumUB - this.b;
        if (explanation.readDom(p).isEmpty()) {
            this.doExplainGlobalFailure(explanation, F2, E);
            return;
        }
        int la2 = -1073741823;
        int ua2 = 0x3FFFFFFF;
        if (ca > 0) {
            if (!this.o.equals((Object)Operator.GE)) {
                ua2 = this.divFloor(F2 + la * ca, ca);
            }
            if (!this.o.equals((Object)Operator.LE)) {
                la2 = this.divCeil(ca * ua - E, ca);
            }
        } else {
            if (!this.o.equals((Object)Operator.GE)) {
                la2 = this.divCeil(-F2 - ua * ca, -ca);
            }
            if (!this.o.equals((Object)Operator.LE)) {
                ua2 = this.divFloor(-la * ca + E, -ca);
            }
        }
        IntIterableRangeSet domain = explanation.empty();
        if (la2 <= ua2) {
            domain.addBetween(la2, ua2);
        }
        ((IntVar[])this.vars)[a2].intersectLit(domain, explanation);
        for (i = 0; i < this.pos; ++i) {
            min2 = -1073741823;
            max = 0x3FFFFFFF;
            if (((IntVar[])this.vars)[i] == pivot) continue;
            dom_before = explanation.readDom(((IntVar[])this.vars)[i]);
            if (!this.o.equals((Object)Operator.GE)) {
                max = this.divFloor(F2 + this.c[i] * dom_before.min() - ca * (ca > 0 ? ua2 + 1 - la : la2 - 1 - ua), this.c[i]);
            }
            if (!this.o.equals((Object)Operator.LE)) {
                min2 = this.divCeil(-E + this.c[i] * dom_before.max() - ca * (ca > 0 ? la2 - 1 - ua : ua2 + 1 - la), this.c[i]);
            }
            domain = explanation.complement(((IntVar[])this.vars)[i]);
            if (this.o.equals((Object)Operator.EQ)) {
                assert (max + 1 <= min2 - 1) : "empty range";
                domain.removeBetween(max + 1, min2 - 1);
            } else {
                domain.retainBetween(min2, max);
            }
            ((IntVar[])this.vars)[i].unionLit(domain, explanation);
        }
        while (i < this.l) {
            min2 = -1073741823;
            max = 0x3FFFFFFF;
            if (((IntVar[])this.vars)[i] != pivot) {
                dom_before = explanation.readDom(((IntVar[])this.vars)[i]);
                if (!this.o.equals((Object)Operator.GE)) {
                    min2 = this.divCeil(-(F2 + this.c[i] * dom_before.max() - ca * (ca > 0 ? ua2 + 1 - la : la2 - 1 - ua)), -this.c[i]);
                }
                if (!this.o.equals((Object)Operator.LE)) {
                    max = this.divFloor(-(-E + this.c[i] * dom_before.min() - ca * (ca > 0 ? la2 - 1 - ua : ua2 + 1 - la)), -this.c[i]);
                }
                domain = explanation.complement(((IntVar[])this.vars)[i]);
                if (this.o.equals((Object)Operator.EQ)) {
                    assert (max + 1 <= min2 - 1) : "empty range";
                    domain.removeBetween(max + 1, min2 - 1);
                } else {
                    domain.retainBetween(min2, max);
                }
                ((IntVar[])this.vars)[i].unionLit(domain, explanation);
            }
            ++i;
        }
    }

    @Override
    protected void explainGlobal(ExplanationForSignedClause explanation, int F2, int E) {
        assert (F2 < 0 ^ E < 0);
        ClauseBuilder ngb = this.model.getClauseBuilder();
        for (int i = 0; i < this.l; ++i) {
            int min2 = -1073741823;
            int max = 0x3FFFFFFF;
            IntIterableRangeSet dom_before = explanation.readDom(((IntVar[])this.vars)[i]);
            if (F2 < 0) {
                if (i < this.pos) {
                    max = this.divFloor(F2 + this.c[i] * dom_before.min(), this.c[i]);
                } else {
                    min2 = this.divCeil(-(F2 + this.c[i] * dom_before.max()), -this.c[i]);
                }
            } else if (i < this.pos) {
                min2 = this.divCeil(-E + this.c[i] * dom_before.max(), this.c[i]);
            } else {
                max = this.divFloor(-(-E + this.c[i] * dom_before.min()), -this.c[i]);
            }
            IntIterableRangeSet domain = explanation.root(((IntVar[])this.vars)[i]);
            domain.retainBetween(min2, max);
            ngb.put(((IntVar[])this.vars)[i], domain);
            for (int k = 0; k < this.l; ++k) {
                if (k == i) continue;
                min2 = -1073741823;
                max = 0x3FFFFFFF;
                dom_before = explanation.readDom(((IntVar[])this.vars)[k]);
                if (F2 < 0) {
                    if (k < this.pos) {
                        min2 = dom_before.min();
                    } else {
                        max = dom_before.max();
                    }
                } else if (k < this.pos) {
                    max = dom_before.max();
                } else {
                    min2 = dom_before.min();
                }
                domain = explanation.root(((IntVar[])this.vars)[k]);
                domain.removeBetween(min2, max);
                ngb.put(((IntVar[])this.vars)[k], domain);
            }
            ngb.buildNogood(this.model);
            if (E != -1 && F2 != -1) continue;
            return;
        }
    }

    @Override
    public String toString() {
        int i;
        StringBuilder linComb = new StringBuilder(20);
        linComb.append(this.c[0]).append('.').append(((IntVar[])this.vars)[0].getName());
        for (i = 1; i < this.pos; ++i) {
            linComb.append(" + ").append(this.c[i]).append('.').append(((IntVar[])this.vars)[i].getName());
        }
        while (i < this.l) {
            linComb.append(" - ").append(-this.c[i]).append('.').append(((IntVar[])this.vars)[i].getName());
            ++i;
        }
        linComb.append(" ").append((Object)this.o).append(" ");
        linComb.append(this.b);
        return linComb.toString();
    }

    private int divFloor(int a2, int b2) {
        if (a2 >= 0) {
            return a2 / b2;
        }
        return (a2 - b2 + 1) / b2;
    }

    private int divCeil(int a2, int b2) {
        if (a2 >= 0) {
            return (a2 + b2 - 1) / b2;
        }
        return a2 / b2;
    }

    @Override
    protected PropSum opposite() {
        return new PropScalar((IntVar[])this.vars, this.c, this.pos, PropScalar.nop(this.o), this.b + PropScalar.nb(this.o));
    }
}

