/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.decomposition.qr;

import org.ejml.data.DMatrixRMaj;

public class QrHelperFunctions_DDRM {
    public static double findMax(double[] u, int startU, int length) {
        double max = -1.0;
        int stopIndex = startU + length;
        for (int index = startU; index < stopIndex; ++index) {
            double val = u[index];
            double d2 = val = val < 0.0 ? -val : val;
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static void divideElements(int j, int numRows, double[] u, double u_0) {
        int i = j;
        while (i < numRows) {
            int n = i++;
            u[n] = u[n] / u_0;
        }
    }

    public static void divideElements(int j, int numRows, double[] u, int startU, double u_0) {
        for (int i = j; i < numRows; ++i) {
            int n = i + startU;
            u[n] = u[n] / u_0;
        }
    }

    public static void divideElements_Brow(int j, int numRows, double[] u, double[] b2, int startB, double u_0) {
        for (int i = j; i < numRows; ++i) {
            int n = i + startB;
            double d2 = b2[n] / u_0;
            b2[n] = d2;
            u[i] = d2;
        }
    }

    public static void divideElements_Bcol(int j, int numRows, int numCols, double[] u, double[] b2, int startB, double u_0) {
        int indexB = j * numCols + startB;
        int i = j;
        while (i < numRows) {
            int n = i++;
            double d2 = u[n] / u_0;
            u[n] = d2;
            b2[indexB] = d2;
            indexB += numCols;
        }
    }

    public static double computeTauAndDivide(int j, int numRows, double[] u, int startU, double max) {
        double tau = 0.0;
        for (int i = j; i < numRows; ++i) {
            int n = startU + i;
            double d2 = u[n] / max;
            u[n] = d2;
            double d3 = d2;
            tau += d3 * d3;
        }
        tau = Math.sqrt(tau);
        if (u[startU + j] < 0.0) {
            tau = -tau;
        }
        return tau;
    }

    public static double computeTauAndDivide(int j, int numRows, double[] u, double max) {
        double tau = 0.0;
        int i = j;
        while (i < numRows) {
            int n = i++;
            double d2 = u[n] / max;
            u[n] = d2;
            double d3 = d2;
            tau += d3 * d3;
        }
        tau = Math.sqrt(tau);
        if (u[j] < 0.0) {
            tau = -tau;
        }
        return tau;
    }

    public static void rank1UpdateMultR(DMatrixRMaj A2, double[] u, double gamma, int colA0, int w0, int w1, double[] _temp) {
        int i;
        for (i = colA0; i < A2.numCols; ++i) {
            _temp[i] = u[w0] * A2.data[w0 * A2.numCols + i];
        }
        for (int k = w0 + 1; k < w1; ++k) {
            int indexA = k * A2.numCols + colA0;
            double valU = u[k];
            int i2 = colA0;
            while (i2 < A2.numCols) {
                int n = i2++;
                _temp[n] = _temp[n] + valU * A2.data[indexA++];
            }
        }
        i = colA0;
        while (i < A2.numCols) {
            int n = i++;
            _temp[n] = _temp[n] * gamma;
        }
        for (i = w0; i < w1; ++i) {
            double valU = u[i];
            int indexA = i * A2.numCols + colA0;
            for (int j = colA0; j < A2.numCols; ++j) {
                int n = indexA++;
                A2.data[n] = A2.data[n] - valU * _temp[j];
            }
        }
    }

    public static void rank1UpdateMultR(DMatrixRMaj A2, double[] u, int offsetU, double gamma, int colA0, int w0, int w1, double[] _temp) {
        int i;
        for (i = colA0; i < A2.numCols; ++i) {
            _temp[i] = u[w0 + offsetU] * A2.data[w0 * A2.numCols + i];
        }
        for (int k = w0 + 1; k < w1; ++k) {
            int indexA = k * A2.numCols + colA0;
            double valU = u[k + offsetU];
            int i2 = colA0;
            while (i2 < A2.numCols) {
                int n = i2++;
                _temp[n] = _temp[n] + valU * A2.data[indexA++];
            }
        }
        i = colA0;
        while (i < A2.numCols) {
            int n = i++;
            _temp[n] = _temp[n] * gamma;
        }
        for (i = w0; i < w1; ++i) {
            double valU = u[i + offsetU];
            int indexA = i * A2.numCols + colA0;
            for (int j = colA0; j < A2.numCols; ++j) {
                int n = indexA++;
                A2.data[n] = A2.data[n] - valU * _temp[j];
            }
        }
    }

    public static void rank1UpdateMultL(DMatrixRMaj A2, double[] u, double gamma, int colA0, int w0, int w1) {
        for (int i = colA0; i < A2.numRows; ++i) {
            int j;
            int startIndex = i * A2.numCols + w0;
            double sum = 0.0;
            int rowIndex = startIndex;
            for (j = w0; j < w1; ++j) {
                sum += A2.data[rowIndex++] * u[j];
            }
            sum = -gamma * sum;
            rowIndex = startIndex;
            for (j = w0; j < w1; ++j) {
                int n = rowIndex++;
                A2.data[n] = A2.data[n] + sum * u[j];
            }
        }
    }
}

