/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.UtilEjml;
import org.ejml.data.FMatrix;

public class MatrixFeatures_F {
    public static boolean isEquals(FMatrix a2, FMatrix b2) {
        if (a2.getNumRows() != b2.getNumRows() || a2.getNumCols() != b2.getNumCols()) {
            return false;
        }
        int numRows = a2.getNumRows();
        int numCols = a2.getNumCols();
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numCols; ++col) {
                if (a2.unsafe_get(row, col) == b2.unsafe_get(row, col)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isIdentical(FMatrix a2, FMatrix b2, float tol) {
        if (a2.getNumRows() != b2.getNumRows() || a2.getNumCols() != b2.getNumCols()) {
            return false;
        }
        if (tol < 0.0f) {
            throw new IllegalArgumentException("Tolerance must be greater than or equal to zero.");
        }
        int numRows = a2.getNumRows();
        int numCols = a2.getNumCols();
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numCols; ++col) {
                if (UtilEjml.isIdentical(a2.unsafe_get(row, col), b2.unsafe_get(row, col), tol)) continue;
                return false;
            }
        }
        return true;
    }
}

