/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import net.opengis.ows11.ContactType;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.metadata.iso.citation.AddressImpl;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.metadata.iso.citation.TelephoneImpl;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.citation.Address;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.metadata.citation.Telephone;
import org.opengis.util.InternationalString;

public class ContactImpl
extends MetadataEntity
implements Contact {
    private static final long serialVersionUID = 3283637180253117382L;
    public static final Contact OGC;
    public static final Contact OPEN_GIS;
    public static final Contact EPSG;
    public static final Contact GEOTIFF;
    public static final Contact ESRI;
    public static final Contact ORACLE;
    public static final Contact POSTGIS;
    public static final Contact SUN_MICROSYSTEMS;
    public static final Contact GEOTOOLS;
    private InternationalString contactInstructions;
    private InternationalString hoursOfService;
    private OnLineResource onLineResource;
    private Address address;
    private Telephone phone;

    public ContactImpl() {
    }

    public ContactImpl(Contact source) {
        super(source);
    }

    public ContactImpl(OnLineResource resource) {
        this.setOnLineResource(resource);
    }

    public ContactImpl(ContactType contactInfo) {
        if (contactInfo != null) {
            if (contactInfo.getAddress() != null) {
                this.setAddress(new AddressImpl(contactInfo.getAddress()));
            }
            if (contactInfo.getContactInstructions() != null) {
                this.setContactInstructions(new SimpleInternationalString(contactInfo.getContactInstructions()));
            }
            if (contactInfo.getHoursOfService() != null) {
                this.setHoursOfService(new SimpleInternationalString(contactInfo.getHoursOfService()));
            }
            if (contactInfo.getOnlineResource() != null) {
                this.setOnLineResource(new OnLineResourceImpl(contactInfo.getOnlineResource()));
            }
            if (contactInfo.getPhone() != null) {
                this.setPhone(new TelephoneImpl(contactInfo.getPhone()));
            }
        }
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address newValue) {
        this.checkWritePermission();
        this.address = newValue;
    }

    @Override
    public InternationalString getContactInstructions() {
        return this.contactInstructions;
    }

    public void setContactInstructions(InternationalString newValue) {
        this.checkWritePermission();
        this.contactInstructions = newValue;
    }

    @Override
    public OnLineResource getOnLineResource() {
        return this.onLineResource;
    }

    public void setOnLineResource(OnLineResource newValue) {
        this.checkWritePermission();
        this.onLineResource = newValue;
    }

    @Override
    public Telephone getPhone() {
        return this.phone;
    }

    public void setPhone(Telephone newValue) {
        this.checkWritePermission();
        this.phone = newValue;
    }

    @Override
    public InternationalString getHoursOfService() {
        return this.hoursOfService;
    }

    public void setHoursOfService(InternationalString newValue) {
        this.checkWritePermission();
        this.hoursOfService = newValue;
    }

    static {
        ContactImpl c2 = new ContactImpl(OnLineResourceImpl.OGC);
        c2.freeze();
        OGC = c2;
        c2 = new ContactImpl(OnLineResourceImpl.OPEN_GIS);
        c2.freeze();
        OPEN_GIS = c2;
        c2 = new ContactImpl(OnLineResourceImpl.EPSG);
        c2.freeze();
        EPSG = c2;
        c2 = new ContactImpl(OnLineResourceImpl.GEOTIFF);
        c2.freeze();
        GEOTIFF = c2;
        c2 = new ContactImpl(OnLineResourceImpl.ESRI);
        c2.freeze();
        ESRI = c2;
        c2 = new ContactImpl(OnLineResourceImpl.ORACLE);
        c2.freeze();
        ORACLE = c2;
        c2 = new ContactImpl(OnLineResourceImpl.POSTGIS);
        c2.freeze();
        POSTGIS = c2;
        c2 = new ContactImpl(OnLineResourceImpl.SUN_MICROSYSTEMS);
        c2.freeze();
        SUN_MICROSYSTEMS = c2;
        c2 = new ContactImpl(OnLineResourceImpl.GEOTOOLS);
        c2.freeze();
        GEOTOOLS = c2;
    }
}

