/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.isomorphism;

import java.util.Comparator;
import org.jgrapht.Graph;
import org.jgrapht.alg.isomorphism.GraphOrdering;
import org.jgrapht.alg.isomorphism.IsomorphicGraphMapping;
import org.jgrapht.alg.isomorphism.VF2MappingIterator;
import org.jgrapht.alg.isomorphism.VF2State;
import org.jgrapht.alg.isomorphism.VF2SubgraphIsomorphismState;

class VF2SubgraphMappingIterator<V, E>
extends VF2MappingIterator<V, E> {
    public VF2SubgraphMappingIterator(GraphOrdering<V, E> ordering1, GraphOrdering<V, E> ordering2, Comparator<V> vertexComparator, Comparator<E> edgeComparator) {
        super(ordering1, ordering2, vertexComparator, edgeComparator);
    }

    @Override
    protected IsomorphicGraphMapping<V, E> match() {
        VF2SubgraphIsomorphismState s2;
        if (this.stateStack.isEmpty()) {
            Graph g1 = this.ordering1.getGraph();
            Graph g2 = this.ordering2.getGraph();
            if (g1.vertexSet().size() < g2.vertexSet().size() || g1.edgeSet().size() < g2.edgeSet().size()) {
                return null;
            }
            s2 = new VF2SubgraphIsomorphismState(this.ordering1, this.ordering2, this.vertexComparator, this.edgeComparator);
            if (g2.vertexSet().isEmpty()) {
                return this.hadOneMapping != null ? null : s2.getCurrentMapping();
            }
        } else {
            ((VF2State)this.stateStack.pop()).backtrack();
            s2 = (VF2SubgraphIsomorphismState)this.stateStack.pop();
        }
        while (true) {
            if (s2.nextPair()) {
                if (!((VF2State)s2).isFeasiblePair()) continue;
                this.stateStack.push(s2);
                s2 = new VF2SubgraphIsomorphismState(s2);
                s2.addPair();
                if (s2.isGoal()) {
                    this.stateStack.push(s2);
                    return s2.getCurrentMapping();
                }
                s2.resetAddVertexes();
                continue;
            }
            if (this.stateStack.isEmpty()) {
                return null;
            }
            s2.backtrack();
            s2 = (VF2State)this.stateStack.pop();
        }
    }
}

