/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import java.util.Arrays;
import java.util.LinkedList;
import moa.AbstractMOAObject;
import moa.core.Measurement;
import moa.evaluation.LearningPerformanceEvaluator;
import moa.learners.Learner;

public class LearningEvaluation
extends AbstractMOAObject {
    private static final long serialVersionUID = 1L;
    protected Measurement[] measurements;

    public LearningEvaluation(Measurement[] measurements) {
        this.measurements = (Measurement[])measurements.clone();
    }

    public LearningEvaluation(Measurement[] evaluationMeasurements, LearningPerformanceEvaluator cpe, Learner model) {
        LinkedList<Measurement> measurementList = new LinkedList<Measurement>();
        if (evaluationMeasurements != null) {
            measurementList.addAll(Arrays.asList(evaluationMeasurements));
        }
        measurementList.addAll(Arrays.asList(cpe.getPerformanceMeasurements()));
        measurementList.addAll(Arrays.asList(model.getModelMeasurements()));
        this.measurements = measurementList.toArray(new Measurement[measurementList.size()]);
    }

    public LearningEvaluation(LearningPerformanceEvaluator cpe, Learner model) {
        this(null, cpe, model);
    }

    public Measurement[] getMeasurements() {
        return (Measurement[])this.measurements.clone();
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        Measurement.getMeasurementsDescription(this.measurements, sb, indent);
    }
}

