/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.base;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.IPopulation;
import net.sourceforge.jclec.IRecombinator;
import net.sourceforge.jclec.ISystem;
import net.sourceforge.jclec.util.random.IRandGen;

public abstract class AbstractRecombinator
implements IRecombinator {
    protected IPopulation context;
    protected IRandGen randgen;
    protected transient int ppl;
    protected transient int spl;
    protected transient List<IIndividual> parentsBuffer;
    protected transient List<IIndividual> sonsBuffer;
    protected transient int parentsCounter;

    public AbstractRecombinator() {
        this.setPpl();
        this.setSpl();
    }

    @Override
    public final void contextualize(ISystem context) {
        if (!(context instanceof IPopulation)) {
            throw new IllegalArgumentException("This object uses a population as execution context");
        }
        this.context = (IPopulation)context;
        if (this.randgen == null) {
            this.randgen = context.createRandGen();
        }
    }

    @Override
    public final int getPpl() {
        return this.ppl;
    }

    @Override
    public final int getSpl() {
        return this.spl;
    }

    @Override
    public final List<IIndividual> recombine(List<IIndividual> parents) {
        this.parentsBuffer = parents;
        this.prepareRecombination();
        this.sonsBuffer = new ArrayList<IIndividual>();
        this.parentsCounter = 0;
        while (this.parentsCounter <= parents.size() - this.ppl) {
            this.recombineNext();
            this.parentsCounter += this.ppl;
        }
        return this.sonsBuffer;
    }

    protected abstract void setPpl();

    protected abstract void setSpl();

    protected abstract void prepareRecombination();

    protected abstract void recombineNext();
}

