/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.ClassifierFuzzyAdaBoost;

import java.io.FileNotFoundException;
import java.io.IOException;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.FB;
import keel.Algorithms.Shared.Parsing.ProcessConfig;
import keel.Algorithms.Shared.Parsing.ProcessDataset;
import org.core.Randomize;

public class ClassifierFuzzyAdaBoost {
    static Randomize rand;
    static final int MAXFUZZYRULES = 1000;

    private static void fuzzyBoosting(int opt, boolean tty, ProcessConfig pc) {
        try {
            int i;
            int j;
            boolean defaultNumberInputPartitions = false;
            boolean numberOfCrossovers = false;
            ProcessDataset pd = new ProcessDataset();
            String readALine = (String)ProcessConfig.parInputData.get(0);
            if (ProcessConfig.parNewFormat) {
                pd.processClassifierDataset(readALine, true);
            } else {
                pd.oldClusteringProcess(readALine);
            }
            int nData = pd.getNdata();
            int nVariables = pd.getNvariables();
            int nInputs = pd.getNinputs();
            int nClasses = pd.getNclasses();
            double[][] X = pd.getX();
            int[] C = pd.getC();
            int[] Ct = new int[C.length];
            pd.showDatasetStatistics();
            double[] inputMaximum = pd.getImaximum();
            double[] inputMinimum = pd.getIminimum();
            double outputMaximum = pd.getOmaximum();
            double outputMinimum = pd.getOminimum();
            int[] nInputPartitions = new int[nInputs];
            double[][] ytrain = new double[X.length][nClasses];
            for (int i2 = 0; i2 < ytrain.length; ++i2) {
                ytrain[i2][C[i2]] = 1.0;
            }
            int p = 0;
            double[] lintrain = new double[nData * nInputs];
            for (int i3 = 0; i3 < nData; ++i3) {
                for (j = 0; j < nInputs; ++j) {
                    lintrain[p++] = X[i3][j];
                }
            }
            p = 0;
            double[] linytrain = new double[nData * nClasses];
            for (j = 0; j < nClasses; ++j) {
                for (int i4 = 0; i4 < nData; ++i4) {
                    linytrain[p++] = ytrain[i4][j];
                }
            }
            FB fb = new FB();
            int nRules = ProcessConfig.parRuleNumber;
            int nlabels = ProcessConfig.parPartitionLabelNum;
            int ruleBaseSize = (nlabels + 1) * nInputs + nRules + nRules * (nInputs + nClasses);
            double[] ruleBase = new double[ruleBaseSize];
            double numFails = 0.0;
            FB.fuzzycreavacio(nInputs, nClasses, nlabels, lintrain, linytrain, ruleBase, rand);
            int limit = 0;
            limit = nClasses == 2 ? 1 : nClasses;
            double[] fit = new double[1];
            for (int r = 0; r < nRules; ++r) {
                numFails = 0.0;
                switch (opt) {
                    case 1: {
                        FB.fadaboostinc(nInputs, nClasses, lintrain, linytrain, ruleBase);
                        break;
                    }
                    case 2: {
                        FB.flogitboostinc(nInputs, nClasses, lintrain, linytrain, ruleBase, false);
                        break;
                    }
                    case 3: {
                        FB.fadaboostincmaxmin(nInputs, nClasses, lintrain, linytrain, ruleBase, fit);
                    }
                }
                for (int i5 = 0; i5 < X.length; ++i5) {
                    double[] segs = opt == 1 || opt == 2 ? FB.fuzzyclasifica(X[i5], nClasses, ruleBase) : FB.fuzzyclasificamaxmin(X[i5], nClasses, ruleBase);
                    int ac = FB.argmax(segs);
                    if (ac != C[i5]) {
                        numFails += 1.0;
                    }
                    Ct[i5] = ac;
                }
            }
            System.out.println("Train: =" + numFails / (double)X.length);
            pc.trainingResults(C, Ct);
            ProcessDataset pdt = new ProcessDataset();
            readALine = (String)ProcessConfig.parInputData.get(2);
            if (ProcessConfig.parNewFormat) {
                pdt.processClassifierDataset(readALine, false);
            } else {
                pdt.oldClusteringProcess(readALine);
            }
            int nTest = pdt.getNdata();
            int nTestVariables = pdt.getNvariables();
            int nTestInputs = pdt.getNinputs();
            pdt.showDatasetStatistics();
            if (nTestInputs != nInputs) {
                throw new IOException("Test file IOERR");
            }
            X = pdt.getX();
            C = pdt.getC();
            int[] Co = new int[C.length];
            nData = X.length;
            ytrain = new double[X.length][nClasses];
            for (i = 0; i < ytrain.length; ++i) {
                ytrain[i][C[i]] = 1.0;
            }
            p = 0;
            lintrain = new double[nData * nInputs];
            for (i = 0; i < nData; ++i) {
                for (int j2 = 0; j2 < nInputs; ++j2) {
                    lintrain[p++] = X[i][j2];
                }
            }
            p = 0;
            linytrain = new double[nData * nClasses];
            for (int j3 = 0; j3 < nClasses; ++j3) {
                for (int i6 = 0; i6 < nData; ++i6) {
                    linytrain[p++] = ytrain[i6][j3];
                }
            }
            numFails = 0.0;
            for (i = 0; i < X.length; ++i) {
                int ac;
                double[] segs = opt == 1 || opt == 2 ? FB.fuzzyclasifica(X[i], nClasses, ruleBase) : FB.fuzzyclasificamaxmin(X[i], nClasses, ruleBase);
                Co[i] = ac = FB.argmax(segs);
                if (ac == C[i]) continue;
                numFails += 1.0;
            }
            System.out.println("Test: =" + numFails / (double)X.length);
            pc.results(C, Co);
        }
        catch (FileNotFoundException e) {
            System.err.println(e + " Input file not found");
        }
        catch (IOException e) {
            System.err.println(e + " Read Error");
        }
    }

    public static void main(String[] args) {
        boolean tty = false;
        ProcessConfig pc = new ProcessConfig();
        System.out.println("Reading configuration file: " + args[0]);
        if (pc.fileProcess(args[0]) < 0) {
            return;
        }
        int algo = ProcessConfig.parAlgorithmType;
        rand = new Randomize();
        Randomize.setSeed(ProcessConfig.parSeed);
        ClassifierFuzzyAdaBoost pi = new ClassifierFuzzyAdaBoost();
        ClassifierFuzzyAdaBoost.fuzzyBoosting(1, tty, pc);
    }
}

