/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.core;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import moa.AbstractMOAObject;
import moa.classifiers.core.conditionaltests.InstanceConditionalTest;
import moa.classifiers.core.conditionaltests.NumericAttributeBinaryTest;
import moa.classifiers.rules.AbstractAMRules;
import moa.classifiers.rules.core.RuleActiveLearningNode;
import moa.classifiers.rules.core.RuleActiveRegressionNode;
import moa.classifiers.rules.core.conditionaltests.NumericAttributeBinaryRulePredicate;
import moa.classifiers.rules.nodes.RuleSplitNode;
import moa.core.DoubleVector;
import moa.core.StringUtils;
import moa.options.FlagOption;
import moa.options.FloatOption;
import weka.core.Instance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule
extends AbstractMOAObject {
    private static final long serialVersionUID = 1L;
    protected List<RuleSplitNode> nodeList = new LinkedList<RuleSplitNode>();
    protected RuleActiveLearningNode learningNode;
    protected int ruleNumberID;
    private double[] statisticsOtherBranchSplit;
    private Builder builder;
    protected AbstractAMRules amRules;

    public int getRuleNumberID() {
        return this.ruleNumberID;
    }

    public void setRuleNumberID(int ruleNumberID) {
        this.ruleNumberID = ruleNumberID;
    }

    public RuleActiveLearningNode getLearningNode() {
        return this.learningNode;
    }

    public void setLearningNode(RuleActiveLearningNode learningNode) {
        this.learningNode = learningNode;
    }

    public List<RuleSplitNode> getNodeList() {
        return this.nodeList;
    }

    public long getInstancesSeen() {
        return this.learningNode.getInstancesSeen();
    }

    public void setNodeList(List<RuleSplitNode> nodeList) {
        this.nodeList = nodeList;
    }

    public Rule(Builder builder) {
        builder.setOwner(this);
        this.setBuilder(builder);
        this.amRules = builder.getAMRules();
        this.learningNode = this.newRuleActiveLearningNode(builder);
        this.ruleNumberID = builder.id;
    }

    private RuleActiveLearningNode newRuleActiveLearningNode(Builder builder) {
        return this.amRules.newRuleActiveLearningNode(builder);
    }

    public boolean isCovering(Instance inst) {
        boolean isCovering = true;
        for (RuleSplitNode node : this.nodeList) {
            if (node.evaluate(inst)) continue;
            isCovering = false;
            break;
        }
        return isCovering;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    public void updateStatistics(Instance instance) {
        this.learningNode.updateStatistics(instance);
    }

    public boolean tryToExpand(double splitConfidence, double tieThreshold) {
        boolean shouldSplit = this.learningNode.tryToExpand(splitConfidence, tieThreshold);
        return shouldSplit;
    }

    public void split() {
        int splitIndex = this.learningNode.getSplitIndex();
        InstanceConditionalTest st = this.learningNode.getBestSuggestion().splitTest;
        if (st instanceof NumericAttributeBinaryTest) {
            NumericAttributeBinaryTest splitTest = (NumericAttributeBinaryTest)st;
            NumericAttributeBinaryRulePredicate predicate = new NumericAttributeBinaryRulePredicate(splitTest.getAttsTestDependsOn()[0], splitTest.getSplitValue(), splitIndex + 1);
            RuleSplitNode ruleSplitNode = new RuleSplitNode(predicate, this.learningNode.getStatisticsBranchSplit());
            if (this.nodeListAdd(ruleSplitNode)) {
                RuleActiveLearningNode newLearningNode = this.newRuleActiveLearningNode(this.getBuilder().statistics(this.learningNode.getStatisticsNewRuleActiveLearningNode()));
                newLearningNode.initialize(this.learningNode);
                this.learningNode = newLearningNode;
            }
        } else {
            throw new UnsupportedOperationException("AMRules (currently) only supports numerical attributes.");
        }
    }

    private boolean nodeListAdd(RuleSplitNode ruleSplitNode) {
        boolean isIncludedInNodeList = false;
        boolean isUpdated = false;
        for (RuleSplitNode node : this.nodeList) {
            NumericAttributeBinaryRulePredicate ruleSplitNodeTest;
            NumericAttributeBinaryRulePredicate nodeTest = (NumericAttributeBinaryRulePredicate)node.getSplitTest();
            if (!nodeTest.isUsingSameAttribute(ruleSplitNodeTest = (NumericAttributeBinaryRulePredicate)ruleSplitNode.getSplitTest())) continue;
            isIncludedInNodeList = true;
            if (!nodeTest.isIncludedInRuleNode(ruleSplitNodeTest)) continue;
            nodeTest.setAttributeValue(ruleSplitNodeTest);
            isUpdated = true;
        }
        if (!isIncludedInNodeList) {
            this.nodeList.add(ruleSplitNode);
        }
        return !isIncludedInNodeList || isUpdated;
    }

    public double[] statisticsOtherBranchSplit() {
        return this.statisticsOtherBranchSplit;
    }

    public String printRule() {
        StringBuilder out = new StringBuilder();
        int indent = 1;
        StringUtils.appendIndented(out, indent, "Rule Nr." + this.ruleNumberID + " Instances seen:" + this.learningNode.getInstancesSeen() + "\n");
        for (RuleSplitNode node : this.nodeList) {
            StringUtils.appendIndented(out, indent, node.getSplitTest().toString());
            StringUtils.appendIndented(out, indent, " ");
            StringUtils.appendIndented(out, indent, node.toString());
        }
        DoubleVector pred = new DoubleVector(this.learningNode.getSimplePrediction());
        StringUtils.appendIndented(out, 0, " --> y: " + pred.toString());
        StringUtils.appendNewline(out);
        if (this.learningNode instanceof RuleActiveRegressionNode && ((RuleActiveRegressionNode)this.learningNode).perceptron != null) {
            ((RuleActiveRegressionNode)this.learningNode).perceptron.getModelDescription(out, 0);
            StringUtils.appendNewline(out);
        }
        return out.toString();
    }

    protected void debug(String string, int level) {
        if (this.amRules.VerbosityOption.getValue() >= level) {
            System.out.println(string);
        }
    }

    public boolean isAnomaly(Instance instance, double uniVariateAnomalyProbabilityThreshold, double multiVariateAnomalyProbabilityThreshold, int numberOfInstanceesForAnomaly) {
        return this.learningNode.isAnomaly(instance, uniVariateAnomalyProbabilityThreshold, multiVariateAnomalyProbabilityThreshold, numberOfInstanceesForAnomaly);
    }

    public double computeError(Instance instance) {
        return this.learningNode.computeError(instance);
    }

    public boolean updatePageHinckleyTest(double error) {
        return this.learningNode.updatePageHinckleyTest(error);
    }

    public double[] getPrediction(Instance instance, int mode) {
        return this.learningNode.getPrediction(instance, mode);
    }

    public double[] getPrediction(Instance instance) {
        return this.learningNode.getPrediction(instance);
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public void setBuilder(Builder builder) {
        this.builder = builder;
    }

    public double getCurrentError() {
        return this.learningNode.getCurrentError();
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = 1712887264918475622L;
        protected boolean changeDetection;
        protected boolean usePerceptron;
        protected double threshold;
        protected double alpha;
        protected int predictionFunction;
        protected double[] statistics;
        protected double lastTargetMean;
        private Rule owner;
        public FlagOption constantLearningRatioDecayOption;
        public FloatOption learningRatioOption;
        public int id;
        public AbstractAMRules amRules;

        public AbstractAMRules getAMRules() {
            return this.amRules;
        }

        public Builder changeDetection(boolean changeDetection) {
            this.changeDetection = changeDetection;
            return this;
        }

        public Builder threshold(double threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder alpha(double alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder predictionFunction(int predictionFunction) {
            this.predictionFunction = predictionFunction;
            return this;
        }

        public Builder statistics(double[] statistics) {
            this.statistics = statistics;
            return this;
        }

        public Builder owner(Rule owner) {
            this.setOwner(owner);
            return this;
        }

        public Builder amRules(AbstractAMRules amRules) {
            this.amRules = amRules;
            return this;
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Rule build() {
            return new Rule(this);
        }

        public Rule getOwner() {
            return this.owner;
        }

        public void setOwner(Rule owner) {
            this.owner = owner;
        }
    }
}

