/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class ReplaceWithMissingValue
extends SimpleBatchFilter
implements UnsupervisedFilter,
Randomizable,
WeightedAttributesHandler,
WeightedInstancesHandler {
    private static final long serialVersionUID = -2356630932899796239L;
    protected Range m_Cols = new Range("first-last");
    protected String m_DefaultCols = "first-last";
    protected int m_Seed = 1;
    protected double m_Probability = 0.1;
    protected boolean m_IgnoreClass = false;

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>(4);
        result.addElement(new Option("\tSpecifies list of columns to modify. First and last are valid indexes.\n\t(default: first-last)", "R", 1, "-R <col1,col2-col4,...>"));
        result.addElement(new Option("\tInvert matching sense of column indexes.", "V", 0, "-V"));
        result.addElement(new Option("\tSpecify the random number seed (default 1)", "S", 1, "-S <num>"));
        result.addElement(new Option("\tSpecify the probability  (default 0.1)", "P", 1, "-P <double>"));
        result.addElement(new Option("\tUnsets the class index temporarily before the filter is\n\tapplied to the data.\n\t(default: no)", "unset-class-temporarily", 1, "-unset-class-temporarily"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String seedString;
        this.setInvertSelection(Utils.getFlag('V', options));
        String tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndices(tmpStr);
        } else {
            this.setAttributeIndices(this.m_DefaultCols);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        if ((seedString = Utils.getOption('S', options)).length() != 0) {
            this.setSeed(Integer.parseInt(seedString));
        } else {
            this.setSeed(1);
        }
        String probString = Utils.getOption('P', options);
        if (probString.length() != 0) {
            this.setProbability(Double.parseDouble(probString));
        } else {
            this.setProbability(0.1);
        }
        this.setIgnoreClass(Utils.getFlag("unset-class-temporarily", options));
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (!this.getAttributeIndices().equals("")) {
            result.add("-R");
            result.add(this.getAttributeIndices());
        }
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        result.add("-S");
        result.add("" + this.getSeed());
        result.add("-P");
        result.add("" + this.getProbability());
        if (this.getIgnoreClass()) {
            result.add("-unset-class-temporarily");
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public String ignoreClassTipText() {
        return "The class index will be unset temporarily before the filter is applied.";
    }

    public void setIgnoreClass(boolean newIgnoreClass) {
        this.m_IgnoreClass = newIgnoreClass;
    }

    public boolean getIgnoreClass() {
        return this.m_IgnoreClass;
    }

    public String probabilityTipText() {
        return "Probability to use for replacement.";
    }

    public double getProbability() {
        return this.m_Probability;
    }

    public void setProbability(double newProbability) {
        this.m_Probability = newProbability;
    }

    public String seedTipText() {
        return "Seed for the random number generator.";
    }

    @Override
    public int getSeed() {
        return this.m_Seed;
    }

    @Override
    public void setSeed(int newSeed) {
        this.m_Seed = newSeed;
    }

    public String invertSelectionTipText() {
        return "Set attribute selection mode. If false, only selected attributes will be modified'; if true, only non-selected attributes will be modified.";
    }

    public boolean getInvertSelection() {
        return this.m_Cols.getInvert();
    }

    public void setInvertSelection(boolean value) {
        this.m_Cols.setInvert(value);
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getAttributeIndices() {
        return this.m_Cols.getRanges();
    }

    public void setAttributeIndices(String value) {
        this.m_Cols.setRanges(value);
    }

    public void setAttributeIndicesArray(int[] value) {
        this.setAttributeIndices(Range.indicesToRangeList(value));
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    protected boolean hasImmediateOutputFormat() {
        return true;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return inputFormat;
    }

    @Override
    public String globalInfo() {
        return "A filter that can be used to introduce missing values in a dataset. The specified probability is used to flip a biased coin to decide whether to replace a particular attribute value in an instance with a missing value (i.e., a probability of 0.9 means 90% of values will be replaced with missing values). This filter only modifies the first batch of data that is processed. The class attribute is skipped by default.";
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        if (this.isFirstBatchDone()) {
            return instances;
        }
        Instances newData = new Instances(instances, instances.numInstances());
        Random random = new Random(this.getSeed());
        this.m_Cols.setUpper(newData.numAttributes() - 1);
        for (Instance inst : instances) {
            double[] values = inst.toDoubleArray();
            for (int i = 0; i < values.length; ++i) {
                if (!this.m_Cols.isInRange(i) || i == instances.classIndex() && !this.getIgnoreClass() || !(random.nextDouble() < this.getProbability())) continue;
                values[i] = Utils.missingValue();
            }
            if (inst instanceof SparseInstance) {
                newData.add(new SparseInstance(inst.weight(), values));
                continue;
            }
            newData.add(new DenseInstance(inst.weight(), values));
        }
        return newData;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10215 $");
    }

    public static void main(String[] argv) {
        ReplaceWithMissingValue.runFilter(new ReplaceWithMissingValue(), argv);
    }
}

