/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.List;
import java.util.Objects;
import org.openscience.cdk.Element;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.RingPartitioner;
import org.openscience.cdk.ringsearch.SSSRFinder;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

@Deprecated
public class DeAromatizationTool {
    public static boolean deAromatize(IRing ring) {
        int i;
        boolean allaromatic = true;
        for (i = 0; i < ring.getBondCount(); ++i) {
            if (ring.getBond(i).getFlag(32)) continue;
            allaromatic = false;
        }
        if (!allaromatic) {
            return false;
        }
        for (i = 0; i < ring.getBondCount(); ++i) {
            if (!ring.getBond(i).getFlag(32)) continue;
            ring.getBond(i).setOrder(IBond.Order.SINGLE);
        }
        boolean result = false;
        IMolecularFormula formula = MolecularFormulaManipulator.getMolecularFormula((IAtomContainer)ring);
        if (ring.getRingSize() == 6) {
            if (MolecularFormulaManipulator.getElementCount((IMolecularFormula)formula, (IElement)new Element("C")) == 6) {
                result = DeAromatizationTool.deAromatizeBenzene(ring);
            } else if (MolecularFormulaManipulator.getElementCount((IMolecularFormula)formula, (IElement)new Element("C")) == 5 && MolecularFormulaManipulator.getElementCount((IMolecularFormula)formula, (IElement)new Element("N")) == 1) {
                result = DeAromatizationTool.deAromatizePyridine(ring);
            }
        }
        if (ring.getRingSize() == 5 && MolecularFormulaManipulator.getElementCount((IMolecularFormula)formula, (IElement)new Element("C")) == 4 && MolecularFormulaManipulator.getElementCount((IMolecularFormula)formula, (IElement)new Element("N")) == 1) {
            result = DeAromatizationTool.deAromatizePyrolle(ring);
        }
        return result;
    }

    private static boolean deAromatizePyridine(IRing ring) {
        return DeAromatizationTool.deAromatizeBenzene(ring);
    }

    private static boolean deAromatizePyrolle(IRing ring) {
        if (ring.getBondCount() != 5) {
            return false;
        }
        for (int i = 0; i < ring.getAtomCount(); ++i) {
            IAtom atom = ring.getAtom(i);
            if (atom.getAtomicNumber() != 7) continue;
            int done = 0;
            IBond bond = null;
            int count = 0;
            while (done != 2) {
                bond = DeAromatizationTool.getNextBond(atom, bond, ring);
                Objects.requireNonNull(bond, "Bond not connected to atom!");
                atom = bond.getBegin().equals((Object)atom) ? bond.getEnd() : bond.getBegin();
                if (++count % 2 != 0) continue;
                bond.setOrder(IBond.Order.DOUBLE);
                ++done;
            }
            break;
        }
        return true;
    }

    private static IBond getNextBond(IAtom atom, IBond bond, IRing ring) {
        List bonds = ring.getConnectedBondsList(atom);
        for (IBond iBond : bonds) {
            if (iBond.equals((Object)bond)) continue;
            return iBond;
        }
        return null;
    }

    private static boolean deAromatizeBenzene(IRing ring) {
        if (ring.getBondCount() != 6) {
            return false;
        }
        int counter = 0;
        for (IBond bond : ring.bonds()) {
            if (counter % 2 == 0) {
                bond.setOrder(IBond.Order.SINGLE);
            } else {
                bond.setOrder(IBond.Order.DOUBLE);
            }
            ++counter;
        }
        return true;
    }

    public static void Dearomatize(IAtomContainer molecule) {
        SSSRFinder finder = new SSSRFinder(molecule);
        IRingSet sssr = finder.findEssentialRings();
        List rings = RingPartitioner.partitionRings((IRingSet)sssr);
        for (IRingSet ring : rings) {
            if (!DeAromatizationTool.Dearomatize666Rings(ring) && !DeAromatizationTool.Dearomatize566Rings(ring) && !DeAromatizationTool.Dearomatize66Rings(ring) && !DeAromatizationTool.Dearomatize56Rings(ring) && !DeAromatizationTool.Dearomatize6Ring(ring) && !DeAromatizationTool.Dearomatize5Ring(ring)) continue;
        }
    }

    public static boolean Dearomatize666Rings(IRingSet rings) {
        IAtomContainer temp;
        IAtomContainer ringC;
        IAtomContainer ringB;
        if (rings.getAtomContainerCount() != 3) {
            return false;
        }
        IAtomContainer ringA = rings.getAtomContainer(0);
        if (DeAromatizationTool.isMiddleRing(ringA, ringB = rings.getAtomContainer(1), ringC = rings.getAtomContainer(2))) {
            temp = ringB;
            ringB = ringA;
            ringA = temp;
        }
        if (DeAromatizationTool.isMiddleRing(ringC, ringA, ringB)) {
            temp = ringB;
            ringB = ringC;
            ringC = temp;
        }
        int maxAtomsRingA = ringA.getAtomCount();
        int maxAtomsRingB = ringB.getAtomCount();
        int maxAtomsRingC = ringC.getAtomCount();
        if (maxAtomsRingA != 6 || maxAtomsRingB != 6 || maxAtomsRingC != 6) {
            return false;
        }
        if (!(DeAromatizationTool.isAllAtomsAromatic(ringA) && DeAromatizationTool.isAllAtomsAromatic(ringB) && DeAromatizationTool.isAllAtomsAromatic(ringC))) {
            return false;
        }
        DeAromatizationTool.InvalidateBonds(ringA);
        DeAromatizationTool.InvalidateBonds(ringB);
        DeAromatizationTool.InvalidateBonds(ringC);
        DeAromatizationTool.DearomatizeRing(ringA, null, null);
        DeAromatizationTool.DearomatizeRing(ringB, null, null);
        DeAromatizationTool.DearomatizeRing(ringC, null, null);
        return true;
    }

    public static boolean Dearomatize566Rings(IRingSet rings) {
        if (rings.getAtomContainerCount() != 3) {
            return false;
        }
        IAtomContainer ringA = rings.getAtomContainer(0);
        IAtomContainer ringB = rings.getAtomContainer(1);
        IAtomContainer ringC = rings.getAtomContainer(2);
        if (ringA.getAtomCount() > ringB.getAtomCount()) {
            ringA = rings.getAtomContainer(1);
            ringB = rings.getAtomContainer(0);
        } else if (ringA.getAtomCount() > ringC.getAtomCount()) {
            ringA = rings.getAtomContainer(2);
            ringC = rings.getAtomContainer(0);
        }
        if (DeAromatizationTool.isMiddleRing(ringC, ringA, ringB)) {
            IAtomContainer temp = ringB;
            ringB = ringC;
            ringC = temp;
        }
        int maxAtomsRingA = ringA.getAtomCount();
        int maxAtomsRingB = ringB.getAtomCount();
        int maxAtomsRingC = ringC.getAtomCount();
        if (maxAtomsRingA != 5 || maxAtomsRingB != 6 || maxAtomsRingC != 6) {
            return false;
        }
        if (!(DeAromatizationTool.isAllAtomsAromatic(ringA) && DeAromatizationTool.isAllAtomsAromatic(ringB) && DeAromatizationTool.isAllAtomsAromatic(ringC))) {
            return false;
        }
        DeAromatizationTool.InvalidateBonds(ringA);
        DeAromatizationTool.InvalidateBonds(ringB);
        DeAromatizationTool.InvalidateBonds(ringC);
        IAtom startAtom = ringA.getAtom(0);
        for (int a = 0; a < maxAtomsRingA; ++a) {
            IAtom atom = ringA.getAtom(a);
            if ((atom.getAtomicNumber() != 7 || atom.getImplicitHydrogenCount() < 1) && atom.getAtomicNumber() != 8 && atom.getAtomicNumber() != 16) continue;
            startAtom = atom;
            break;
        }
        IBond startBond = (IBond)ringA.getConnectedBondsList(startAtom).get(0);
        DeAromatizationTool.DearomatizeRing(ringA, startAtom, startBond);
        DeAromatizationTool.DearomatizeRing(ringB, null, null);
        DeAromatizationTool.DearomatizeRing(ringC, null, null);
        return true;
    }

    public static boolean Dearomatize66Rings(IRingSet rings) {
        if (rings.getAtomContainerCount() != 2) {
            return false;
        }
        IAtomContainer ringA = rings.getAtomContainer(0);
        IAtomContainer ringB = rings.getAtomContainer(1);
        int maxAtomsRingA = ringA.getAtomCount();
        int maxAtomsRingB = ringB.getAtomCount();
        if (maxAtomsRingA != 6 || maxAtomsRingB != 6) {
            return false;
        }
        if (!DeAromatizationTool.isAllAtomsAromatic(ringA) || !DeAromatizationTool.isAllAtomsAromatic(ringB)) {
            return false;
        }
        DeAromatizationTool.InvalidateBonds(ringA);
        DeAromatizationTool.InvalidateBonds(ringB);
        DeAromatizationTool.DearomatizeRing(ringA, null, null);
        DeAromatizationTool.DearomatizeRing(ringB, null, null);
        return true;
    }

    public static boolean Dearomatize56Rings(IRingSet rings) {
        if (rings.getAtomContainerCount() != 2) {
            return false;
        }
        IAtomContainer ringA = rings.getAtomContainer(0);
        IAtomContainer ringB = rings.getAtomContainer(1);
        if (ringA.getAtomCount() > ringB.getAtomCount()) {
            ringA = rings.getAtomContainer(1);
            ringB = rings.getAtomContainer(0);
        }
        int maxAtomsRingA = ringA.getAtomCount();
        int maxAtomsRingB = ringB.getAtomCount();
        if (maxAtomsRingA != 5 || maxAtomsRingB != 6) {
            return false;
        }
        if (!DeAromatizationTool.isAllAtomsAromatic(ringA) || !DeAromatizationTool.isAllAtomsAromatic(ringB)) {
            return false;
        }
        DeAromatizationTool.InvalidateBonds(ringA);
        DeAromatizationTool.InvalidateBonds(ringB);
        IAtom startAtom = ringA.getAtom(0);
        for (int a = 0; a < maxAtomsRingA; ++a) {
            IAtom atom = ringA.getAtom(a);
            if ((atom.getAtomicNumber() != 7 || atom.getImplicitHydrogenCount() < 1) && atom.getAtomicNumber() != 8 && atom.getAtomicNumber() != 16) continue;
            startAtom = atom;
            break;
        }
        IBond startBond = (IBond)ringA.getConnectedBondsList(startAtom).get(0);
        DeAromatizationTool.DearomatizeRing(ringA, startAtom, startBond);
        DeAromatizationTool.DearomatizeRing(ringB, null, null);
        return true;
    }

    public static boolean Dearomatize6Ring(IRingSet rings) {
        if (rings.getAtomContainerCount() != 1) {
            return false;
        }
        IAtomContainer ringA = rings.getAtomContainer(0);
        int maxAtomsRingA = ringA.getAtomCount();
        if (maxAtomsRingA != 6) {
            return false;
        }
        if (!DeAromatizationTool.isAllAtomsAromatic(ringA)) {
            return false;
        }
        DeAromatizationTool.InvalidateBonds(ringA);
        IAtom startAtom = ringA.getAtom(0);
        IBond startBond = (IBond)ringA.getConnectedBondsList(startAtom).get(0);
        DeAromatizationTool.DearomatizeRing(ringA, startAtom, startBond);
        return true;
    }

    public static boolean Dearomatize5Ring(IRingSet rings) {
        if (rings.getAtomContainerCount() != 1) {
            return false;
        }
        IAtomContainer ringA = rings.getAtomContainer(0);
        int maxAtomsRingA = ringA.getAtomCount();
        if (maxAtomsRingA != 5) {
            return false;
        }
        if (!DeAromatizationTool.isAllAtomsAromatic(ringA)) {
            return false;
        }
        DeAromatizationTool.InvalidateBonds(ringA);
        IAtom startAtom = ringA.getAtom(0);
        for (int a = 0; a < maxAtomsRingA; ++a) {
            IAtom atom = ringA.getAtom(a);
            if ((atom.getAtomicNumber() != 7 || atom.getImplicitHydrogenCount() < 1) && atom.getAtomicNumber() != 8 && atom.getAtomicNumber() != 16) continue;
            startAtom = atom;
            break;
        }
        IBond startBond = (IBond)ringA.getConnectedBondsList(startAtom).get(0);
        DeAromatizationTool.DearomatizeRing(ringA, startAtom, startBond);
        return true;
    }

    private static boolean isAllAtomsAromatic(IAtomContainer ring) {
        for (IAtom atom : ring.atoms()) {
            if (atom.getFlag(32)) continue;
            return false;
        }
        return true;
    }

    private static boolean isMiddleRing(IAtomContainer ring, IAtomContainer ringA, IAtomContainer ringB) {
        boolean hasAtomInRingA = false;
        boolean hasAtomInRingB = false;
        for (IAtom atom : ring.atoms()) {
            if (!hasAtomInRingA && ringA.contains(atom)) {
                hasAtomInRingA = true;
                continue;
            }
            if (hasAtomInRingB || !ringB.contains(atom)) continue;
            hasAtomInRingB = true;
        }
        return hasAtomInRingA && hasAtomInRingB;
    }

    private static void RemoveAromaticFlag(IAtomContainer ring) {
        for (IAtom atom : ring.atoms()) {
            atom.setFlag(32, false);
        }
        for (IBond bond : ring.bonds()) {
            bond.setFlag(32, false);
        }
    }

    private static void InvalidateBonds(IAtomContainer ring) {
        for (IBond bond : ring.bonds()) {
            bond.setOrder(IBond.Order.QUADRUPLE);
        }
    }

    private static void DearomatizeRing(IAtomContainer ring, IAtom startAtom, IBond startBond) {
        int i;
        IAtom curAtom = startAtom;
        IBond curBond = startBond;
        int maxBonds = ring.getBondCount();
        if (curAtom == null) {
            curAtom = ring.getAtom(0);
        }
        if (curBond == null) {
            curBond = (IBond)ring.getConnectedBondsList(curAtom).get(0);
        }
        boolean nextIsSingle = true;
        boolean nextNextIsSingle = false;
        for (i = 0; i < maxBonds; ++i) {
            IBond bond = ring.getBond(i);
            if (bond.getOrder() == IBond.Order.QUADRUPLE) continue;
            curBond = bond;
            curAtom = bond.getBegin();
            if (bond.getOrder() == IBond.Order.SINGLE) {
                nextIsSingle = true;
                nextNextIsSingle = true;
                continue;
            }
            nextIsSingle = false;
            nextNextIsSingle = true;
        }
        block1: for (i = 0; i < maxBonds; ++i) {
            if (nextIsSingle || i == 1 && nextNextIsSingle) {
                curBond.setOrder(IBond.Order.SINGLE);
                nextIsSingle = false;
            } else {
                curBond.setOrder(IBond.Order.DOUBLE);
                nextIsSingle = true;
            }
            curAtom = curBond.getOther(curAtom);
            List bonds = ring.getConnectedBondsList(curAtom);
            for (IBond bond : bonds) {
                if (bond.equals((Object)curBond)) continue;
                curBond = bond;
                continue block1;
            }
        }
        DeAromatizationTool.RemoveAromaticFlag(ring);
    }
}

