/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.poifs.filesystem.BlockStore;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.NPOIFSStream;
import org.apache.poi.poifs.property.RootProperty;
import org.apache.poi.poifs.storage.BATBlock;
import org.apache.poi.poifs.storage.BlockAllocationTableWriter;
import org.apache.poi.poifs.storage.HeaderBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NPOIFSMiniStore
extends BlockStore {
    private NPOIFSFileSystem _filesystem;
    private NPOIFSStream _mini_stream;
    private List<BATBlock> _sbat_blocks;
    private HeaderBlock _header;
    private RootProperty _root;

    protected NPOIFSMiniStore(NPOIFSFileSystem filesystem, RootProperty root, List<BATBlock> sbats, HeaderBlock header) {
        this._filesystem = filesystem;
        this._sbat_blocks = sbats;
        this._header = header;
        this._root = root;
        this._mini_stream = new NPOIFSStream(filesystem, root.getStartBlock());
    }

    @Override
    protected ByteBuffer getBlockAt(int offset) throws IOException {
        int byteOffset = offset * 64;
        int bigBlockNumber = byteOffset / this._filesystem.getBigBlockSize();
        int bigBlockOffset = byteOffset % this._filesystem.getBigBlockSize();
        Iterator<ByteBuffer> it = this._mini_stream.getBlockIterator();
        for (int i = 0; i < bigBlockNumber; ++i) {
            it.next();
        }
        ByteBuffer dataBlock = it.next();
        if (dataBlock == null) {
            throw new IndexOutOfBoundsException("Big block " + bigBlockNumber + " outside stream");
        }
        dataBlock.position(dataBlock.position() + bigBlockOffset);
        ByteBuffer miniBuffer = dataBlock.slice();
        miniBuffer.limit(64);
        return miniBuffer;
    }

    @Override
    protected ByteBuffer createBlockIfNeeded(int offset) throws IOException {
        try {
            return this.getBlockAt(offset);
        }
        catch (IndexOutOfBoundsException e) {
            int newBigBlock = this._filesystem.getFreeBlock();
            this._filesystem.createBlockIfNeeded(newBigBlock);
            BlockStore.ChainLoopDetector loopDetector = this._filesystem.getChainLoopDetector();
            int block = this._mini_stream.getStartBlock();
            while (true) {
                loopDetector.claim(block);
                int next = this._filesystem.getNextBlock(block);
                if (next == -2) break;
                block = next;
            }
            this._filesystem.setNextBlock(block, newBigBlock);
            this._filesystem.setNextBlock(newBigBlock, -2);
            return this.createBlockIfNeeded(offset);
        }
    }

    @Override
    protected BATBlock.BATBlockAndIndex getBATBlockAndIndex(int offset) {
        return BATBlock.getSBATBlockAndIndex(offset, this._header, this._sbat_blocks);
    }

    @Override
    protected int getNextBlock(int offset) {
        BATBlock.BATBlockAndIndex bai = this.getBATBlockAndIndex(offset);
        return bai.getBlock().getValueAt(bai.getIndex());
    }

    @Override
    protected void setNextBlock(int offset, int nextBlock) {
        BATBlock.BATBlockAndIndex bai = this.getBATBlockAndIndex(offset);
        bai.getBlock().setValueAt(bai.getIndex(), nextBlock);
    }

    @Override
    protected int getFreeBlock() throws IOException {
        int sectorsPerSBAT = this._filesystem.getBigBlockSizeDetails().getBATEntriesPerBlock();
        int offset = 0;
        for (int i = 0; i < this._sbat_blocks.size(); ++i) {
            BATBlock sbat = this._sbat_blocks.get(i);
            if (sbat.hasFreeSectors()) {
                for (int j = 0; j < sectorsPerSBAT; ++j) {
                    int sbatValue = sbat.getValueAt(j);
                    if (sbatValue != -1) continue;
                    return offset + j;
                }
            }
            offset += sectorsPerSBAT;
        }
        BATBlock newSBAT = BATBlock.createEmptyBATBlock(this._filesystem.getBigBlockSizeDetails(), false);
        int batForSBAT = this._filesystem.getFreeBlock();
        newSBAT.setOurBlockIndex(batForSBAT);
        if (this._header.getSBATCount() == 0) {
            this._header.setSBATStart(batForSBAT);
            this._header.setSBATBlockCount(1);
        } else {
            BlockStore.ChainLoopDetector loopDetector = this._filesystem.getChainLoopDetector();
            int batOffset = this._header.getSBATStart();
            while (true) {
                loopDetector.claim(batOffset);
                int nextBat = this._filesystem.getNextBlock(batOffset);
                if (nextBat == -2) break;
                batOffset = nextBat;
            }
            this._filesystem.setNextBlock(batOffset, batForSBAT);
            this._header.setSBATBlockCount(this._header.getSBATCount() + 1);
        }
        this._filesystem.setNextBlock(batForSBAT, -2);
        this._sbat_blocks.add(newSBAT);
        return offset;
    }

    @Override
    protected BlockStore.ChainLoopDetector getChainLoopDetector() throws IOException {
        return new BlockStore.ChainLoopDetector(this._root.getSize());
    }

    @Override
    protected int getBlockStoreBlockSize() {
        return 64;
    }

    protected void syncWithDataSource() throws IOException {
        for (BATBlock sbat : this._sbat_blocks) {
            ByteBuffer block = this._filesystem.getBlockAt(sbat.getOurBlockIndex());
            BlockAllocationTableWriter.writeBlock(sbat, block);
        }
    }
}

