/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;

public class PiecewiseExponentialPopulation
extends DemographicFunction.Abstract {
    double[] intervals;
    double[] thetas;
    double[] lambdas;

    public PiecewiseExponentialPopulation(double[] dArray, double d, double[] dArray2, Units.Type type) {
        super(type);
        if (dArray2 == null || dArray == null) {
            throw new IllegalArgumentException();
        }
        if (dArray2.length != dArray.length + 1) {
            throw new IllegalArgumentException();
        }
        this.thetas = new double[]{d};
        this.intervals = dArray;
        this.lambdas = dArray2;
    }

    public PiecewiseExponentialPopulation(double[] dArray, double[] dArray2, double d, Units.Type type) {
        super(type);
        if (dArray2 == null || dArray == null) {
            throw new IllegalArgumentException();
        }
        if (dArray2.length != dArray.length + 1) {
            throw new IllegalArgumentException();
        }
        this.thetas = dArray2;
        this.intervals = dArray;
        this.lambdas = new double[]{d};
    }

    @Override
    public double getDemographic(double d) {
        double d2;
        double d3;
        if (this.thetas.length == 1) {
            double d4;
            int n = 0;
            double d5 = this.thetas[0];
            double d6 = this.getEpochDuration(n);
            for (d4 = d; d4 > d6; d4 -= d6) {
                d5 *= Math.exp(-this.lambdas[n] * d6);
                d6 = this.getEpochDuration(++n);
            }
            return d5 * Math.exp(-this.lambdas[n] * d4);
        }
        int n = 0;
        double d7 = this.thetas[0];
        double d8 = this.getEpochDuration(n);
        for (d3 = d; d3 > d8; d3 -= d8) {
            d7 = this.thetas[++n];
            d8 = this.getEpochDuration(n);
        }
        double d9 = n + 1 >= this.thetas.length ? this.lambdas[0] : (d7 < (d2 = this.thetas[n + 1]) ? -(Math.log(d2) - Math.log(d7)) / d8 : (d7 > d2 ? (Math.log(d7) - Math.log(d2)) / d8 : 0.0));
        return d7 * Math.exp(-d9 * d3);
    }

    @Override
    public double getIntensity(double d) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double getIntegral(double d, double d2) {
        double d3 = this.getNumericalIntegral(d, d2);
        return d3;
    }

    @Override
    public double getUpperBound(int n) {
        return 1.0E9;
    }

    @Override
    public double getLowerBound(int n) {
        return Double.MIN_VALUE;
    }

    @Override
    public int getNumArguments() {
        return this.lambdas.length + 1;
    }

    @Override
    public String getArgumentName(int n) {
        if (n < this.thetas.length) {
            return "theta" + n;
        }
        return "lambda" + (n - this.thetas.length);
    }

    @Override
    public double getArgument(int n) {
        if (n < this.thetas.length) {
            return this.thetas[n];
        }
        return this.lambdas[n - this.thetas.length];
    }

    @Override
    public void setArgument(int n, double d) {
        if (n < this.thetas.length) {
            this.thetas[n] = d;
        } else {
            this.lambdas[n - this.thetas.length] = d;
        }
    }

    public DemographicFunction getCopy() {
        PiecewiseExponentialPopulation piecewiseExponentialPopulation = this.thetas.length == 1 ? new PiecewiseExponentialPopulation(new double[this.intervals.length], this.thetas[0], new double[this.lambdas.length], this.getUnits()) : new PiecewiseExponentialPopulation(new double[this.intervals.length], new double[this.thetas.length], this.lambdas[0], this.getUnits());
        System.arraycopy(this.intervals, 0, piecewiseExponentialPopulation.intervals, 0, this.intervals.length);
        System.arraycopy(this.thetas, 0, piecewiseExponentialPopulation.thetas, 0, this.thetas.length);
        System.arraycopy(this.lambdas, 0, piecewiseExponentialPopulation.lambdas, 0, this.lambdas.length);
        return piecewiseExponentialPopulation;
    }

    protected double getDemographic(int n, double d) {
        return this.getEpochDemographic(n);
    }

    protected double getIntensity(int n) {
        return this.getEpochDuration(n) / this.getEpochDemographic(n);
    }

    protected double getIntensity(int n, double d) {
        assert (0.0 <= d && d <= this.getEpochDuration(n));
        return d / this.getEpochDemographic(n);
    }

    public int getEpochCount() {
        return this.intervals.length + 1;
    }

    public double getEpochDuration(int n) {
        if (n == this.intervals.length) {
            return Double.POSITIVE_INFINITY;
        }
        return this.intervals[n];
    }

    public void setEpochDuration(int n, double d) {
        if (n < 0 || n >= this.intervals.length) {
            throw new IllegalArgumentException("epoch must be between 0 and " + (this.intervals.length - 1));
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("duration must be positive.");
        }
        this.intervals[n] = d;
    }

    public final double getEpochDemographic(int n) {
        if (n < 0 || n > this.intervals.length) {
            throw new IllegalArgumentException();
        }
        if (this.thetas.length == 1) {
            int n2 = 0;
            double d = this.thetas[0];
            double d2 = this.getEpochDuration(n2);
            while (n > n2) {
                d *= Math.exp(-this.lambdas[n2] * d2);
                d2 = this.getEpochDuration(++n2);
            }
            return d;
        }
        return this.thetas[n];
    }

    public final double getEpochGrowthRate(int n) {
        if (n < 0 || n > this.intervals.length) {
            throw new IllegalArgumentException();
        }
        if (this.thetas.length == 1) {
            return this.lambdas[n];
        }
        if (n >= this.thetas.length - 1) {
            return this.lambdas[0];
        }
        double d = this.thetas[n];
        double d2 = this.thetas[n + 1];
        double d3 = this.getEpochDuration(n);
        if (d < d2) {
            return -Math.log(d2 - d) / d3;
        }
        if (d > d2) {
            return Math.log(d - d2) / d3;
        }
        return 0.0;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.thetas.length; ++n) {
            stringBuffer.append("\t").append(this.thetas[n]);
        }
        for (n = 0; n < this.lambdas.length; ++n) {
            stringBuffer.append("\t").append(this.lambdas[n]);
        }
        return stringBuffer.toString();
    }
}

