/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evomodel.continuous.IntegratedMultivariateTraitLikelihood;
import dr.evomodel.operators.ExchangeOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class TipTraitSwapOperator
extends SimpleMCMCOperator {
    public static final String TIP_TRAIT_SWAP_OPERATOR = "tipTraitSwapOperator";
    private int index1;
    private int index2;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("trait"), AttributeRule.newDoubleRule("weight"), new ElementRule(IntegratedMultivariateTraitLikelihood.class)};

        @Override
        public String getParserName() {
            return TipTraitSwapOperator.TIP_TRAIT_SWAP_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            IntegratedMultivariateTraitLikelihood integratedMultivariateTraitLikelihood = (IntegratedMultivariateTraitLikelihood)xMLObject.getChild(IntegratedMultivariateTraitLikelihood.class);
            String string = xMLObject.getStringAttribute("trait");
            double d = xMLObject.getDoubleAttribute("weight");
            return new TipTraitSwapOperator(string, integratedMultivariateTraitLikelihood, d);
        }

        @Override
        public String getParserDescription() {
            return "This element represents an operator to swap tip traits between two random tips.";
        }

        @Override
        public Class getReturnType() {
            return ExchangeOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private final IntegratedMultivariateTraitLikelihood traitLikelihood;
    private final String traitName;

    public TipTraitSwapOperator(String string, IntegratedMultivariateTraitLikelihood integratedMultivariateTraitLikelihood, double d) {
        this.traitLikelihood = integratedMultivariateTraitLikelihood;
        this.traitName = string;
        this.setWeight(d);
    }

    @Override
    public double doOperation() {
        int n = this.traitLikelihood.getTreeModel().getExternalNodeCount();
        this.index2 = this.index1 = MathUtils.nextInt(n);
        while (this.index2 == this.index1) {
            this.index2 = MathUtils.nextInt(n);
        }
        this.swap(this.index1, this.index2);
        this.traitLikelihood.makeDirty();
        return 0.0;
    }

    private void swap(int n, int n2) {
        double[] dArray = this.traitLikelihood.getTipDataValues(n);
        double[] dArray2 = this.traitLikelihood.getTipDataValues(n2);
        this.traitLikelihood.setTipDataValuesForNode(n2, dArray);
        this.traitLikelihood.setTipDataValuesForNode(n, dArray2);
    }

    @Override
    public void reject() {
        super.reject();
        this.swap(this.index1, this.index2);
    }

    @Override
    public String getOperatorName() {
        return TIP_TRAIT_SWAP_OPERATOR;
    }
}

