/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.BranchRates;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.SimpleNode;
import dr.evolution.tree.SimpleTree;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeAttributeProvider;
import dr.evolution.tree.TreeTraitProvider;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evomodel.tree.HiddenLinkageModel;
import dr.evomodel.tree.TreeLogger;
import dr.inference.loggers.LogFormatter;
import java.text.NumberFormat;
import java.util.Set;

public class HiddenLinkageTreeLogger
extends TreeLogger {
    HiddenLinkageModel hlm;
    Tree originalTree;
    private TreeLogger.LogUpon condition = null;

    public HiddenLinkageTreeLogger(HiddenLinkageModel hiddenLinkageModel, Tree tree, BranchRates branchRates, TreeAttributeProvider[] treeAttributeProviderArray, TreeTraitProvider[] treeTraitProviderArray, LogFormatter logFormatter, int n, boolean bl, boolean bl2, boolean bl3, NumberFormat numberFormat, TreeLogger.LogUpon logUpon) {
        super(HiddenLinkageTreeLogger.processTree(tree, hiddenLinkageModel), branchRates, treeAttributeProviderArray, treeTraitProviderArray, logFormatter, n, bl, bl2, bl3, numberFormat, logUpon);
        this.originalTree = tree;
        this.condition = logUpon;
        this.hlm = hiddenLinkageModel;
    }

    @Override
    public void log(long l) {
        boolean bl;
        boolean bl2 = this.condition != null ? this.condition.logNow(l) : (bl = this.logEvery < 0L || l % this.logEvery == 0L);
        if (!bl) {
            return;
        }
        this.setTree(HiddenLinkageTreeLogger.processTree(this.originalTree, this.hlm));
        super.log(l);
    }

    protected static SimpleTree processTree(Tree tree, HiddenLinkageModel hiddenLinkageModel) {
        NodeRef nodeRef;
        int n;
        int n2;
        TaxonList taxonList = hiddenLinkageModel.getData().getReadsTaxa();
        TaxonList taxonList2 = hiddenLinkageModel.getData().getReferenceTaxa();
        int n3 = tree.getTaxonCount() + taxonList.getTaxonCount();
        n3 = 2 * n3 - 1;
        SimpleNode[] simpleNodeArray = new SimpleNode[n3];
        for (int i = 0; i < simpleNodeArray.length; ++i) {
            simpleNodeArray[i] = new SimpleNode();
            simpleNodeArray[i].setNumber(i);
        }
        SimpleNode simpleNode = null;
        for (n2 = 0; n2 < tree.getNodeCount(); ++n2) {
            NodeRef nodeRef2 = tree.getNode(n2);
            for (n = 0; n < tree.getChildCount(nodeRef2); ++n) {
                nodeRef = tree.getChild(nodeRef2, n);
                simpleNodeArray[nodeRef2.getNumber()].addChild(simpleNodeArray[nodeRef.getNumber()]);
            }
            simpleNodeArray[nodeRef2.getNumber()].setHeight(tree.getNodeHeight(nodeRef2));
            simpleNodeArray[nodeRef2.getNumber()].setRate(tree.getNodeRate(nodeRef2));
            simpleNodeArray[nodeRef2.getNumber()].setTaxon(tree.getNodeTaxon(nodeRef2));
        }
        simpleNode = simpleNodeArray[tree.getRoot().getNumber()];
        n2 = tree.getNodeCount();
        int n4 = 0;
        for (n = taxonList2.getTaxonCount(); n < taxonList2.getTaxonCount() + taxonList.getTaxonCount(); ++n) {
            nodeRef = simpleNodeArray[n2];
            simpleNodeArray[n2] = simpleNodeArray[n];
            simpleNodeArray[n2].setNumber(n2);
            simpleNodeArray[n] = nodeRef;
            simpleNodeArray[n].setNumber(n);
            simpleNodeArray[n].setTaxon(taxonList.getTaxon(n4));
            ++n4;
            ++n2;
        }
        for (n = 0; n < simpleNodeArray.length; ++n) {
            int n5;
            int n6;
            SimpleNode simpleNode2;
            Taxon[] taxonArray;
            Set<Taxon> set;
            nodeRef = simpleNodeArray[n];
            if (((SimpleNode)nodeRef).getTaxon() == null || taxonList.getTaxonIndex(((SimpleNode)nodeRef).getTaxon()) >= 0 || taxonList2.getTaxonIndex(((SimpleNode)nodeRef).getTaxon()) >= 0) continue;
            int n7 = hiddenLinkageModel.getTaxonIndex(((SimpleNode)nodeRef).getTaxon()) - taxonList2.getTaxonCount();
            if (n7 < 0) {
                System.err.println("big trouble, little china");
            }
            if ((set = hiddenLinkageModel.getGroup(n7)).size() == 0) {
                taxonArray = ((SimpleNode)nodeRef).getParent();
                taxonArray.removeChild((SimpleNode)nodeRef);
                if (taxonArray.getChildCount() != 1) continue;
                simpleNode2 = taxonArray.getParent();
                SimpleNode simpleNode3 = taxonArray.getChild(0);
                taxonArray.removeChild(simpleNode3);
                if (simpleNode2 == null) {
                    simpleNode = simpleNode3;
                    continue;
                }
                simpleNode2.removeChild((SimpleNode)taxonArray);
                simpleNode2.addChild(simpleNode3);
                continue;
            }
            if (set.size() == 1) {
                taxonArray = new Taxon[set.size()];
                taxonArray = set.toArray(taxonArray);
                int n8 = HiddenLinkageTreeLogger.getTaxonNode(taxonArray[0], simpleNodeArray);
                SimpleNode simpleNode4 = ((SimpleNode)nodeRef).getParent();
                simpleNode4.removeChild((SimpleNode)nodeRef);
                simpleNode4.addChild(simpleNodeArray[n8]);
                continue;
            }
            taxonArray = new Taxon[set.size()];
            taxonArray = set.toArray(taxonArray);
            simpleNode2 = ((SimpleNode)nodeRef).getParent();
            simpleNode2.removeChild((SimpleNode)nodeRef);
            simpleNode2.addChild(simpleNodeArray[n2]);
            for (n6 = 0; n6 < taxonArray.length - 2; ++n6) {
                n5 = HiddenLinkageTreeLogger.getTaxonNode(taxonArray[n6], simpleNodeArray);
                simpleNodeArray[n2].addChild(simpleNodeArray[n5]);
                simpleNodeArray[n2].addChild(simpleNodeArray[n2 + 1]);
                ++n2;
            }
            n5 = HiddenLinkageTreeLogger.getTaxonNode(taxonArray[n6], simpleNodeArray);
            simpleNodeArray[n2].addChild(simpleNodeArray[n5]);
            int n9 = HiddenLinkageTreeLogger.getTaxonNode(taxonArray[n6 + 1], simpleNodeArray);
            simpleNodeArray[n2].addChild(simpleNodeArray[n9]);
            ++n2;
        }
        SimpleTree simpleTree = new SimpleTree(simpleNode);
        return simpleTree;
    }

    private static int getTaxonNode(Taxon taxon, SimpleNode[] simpleNodeArray) {
        int n;
        for (n = 0; n < simpleNodeArray.length && simpleNodeArray[n].getTaxon() != taxon; ++n) {
        }
        return n;
    }
}

