/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.UnivariateFunction;
import dr.math.distributions.BetaDistribution;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BetaDistributionModel
extends AbstractModel
implements ParametricDistributionModel {
    public static final String BETA_DISTRIBUTION_MODEL = "betaDistributionModel";
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            double d2 = (d - BetaDistributionModel.this.offset) / BetaDistributionModel.this.length;
            return BetaDistributionModel.this.pdf(d2);
        }

        @Override
        public final double getLowerBound() {
            return BetaDistributionModel.this.offset;
        }

        @Override
        public final double getUpperBound() {
            return BetaDistributionModel.this.offset + BetaDistributionModel.this.length;
        }
    };
    private Variable<Double> alpha = null;
    private Variable<Double> beta = null;
    private double offset = 0.0;
    private double length = 0.0;
    private BetaDistribution betaDistribution = null;
    private BetaDistribution storedBetaDistribution = null;

    public BetaDistributionModel(Variable<Double> variable, Variable<Double> variable2) {
        this(variable, variable2, 0.0, 1.0);
    }

    public BetaDistributionModel(Variable<Double> variable, Variable<Double> variable2, double d, double d2) {
        super(BETA_DISTRIBUTION_MODEL);
        this.alpha = variable;
        this.beta = variable2;
        this.length = d2;
        this.offset = d;
        this.addVariable(variable);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.addVariable(variable2);
        variable2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.recomputeBetaDistribution();
    }

    @Override
    public double pdf(double d) {
        double d2 = this.getXScaled(d);
        if (d2 < 0.0 || d2 > 1.0) {
            return 0.0;
        }
        return this.betaDistribution.pdf(d2);
    }

    @Override
    public double logPdf(double d) {
        double d2 = this.getXScaled(d);
        if (d2 < 0.0 || d2 > 1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.betaDistribution.logPdf(d2);
    }

    @Override
    public double cdf(double d) {
        if (d < this.offset) {
            return 0.0;
        }
        return this.betaDistribution.cdf(this.getXScaled(d));
    }

    @Override
    public double quantile(double d) {
        return this.betaDistribution.quantile(this.getXScaled(d)) * this.length + this.offset;
    }

    @Override
    public double mean() {
        return this.betaDistribution.mean() * this.length + this.offset;
    }

    @Override
    public double variance() {
        return this.betaDistribution.variance() * this.length * this.length;
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.logPdf(dArray[0]);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.recomputeBetaDistribution();
    }

    @Override
    protected void storeState() {
        this.storedBetaDistribution = this.betaDistribution;
    }

    @Override
    protected void restoreState() {
        this.betaDistribution = this.storedBetaDistribution;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }

    private void recomputeBetaDistribution() {
        this.betaDistribution = new BetaDistribution(this.alpha.getValue(0), this.beta.getValue(0));
    }

    private double getXScaled(double d) {
        return (d - this.offset) / this.length;
    }
}

