/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.Codons;
import dr.evolution.datatype.Nucleotides;
import dr.inference.model.Parameter;
import dr.oldevomodel.substmodel.AbstractCodonModel;
import dr.oldevomodel.substmodel.EmpiricalCodonRateMatrix;
import dr.oldevomodel.substmodel.FrequencyModel;
import java.util.logging.Logger;

public class EmpiricalCodonModel
extends AbstractCodonModel {
    protected byte[] rateMap;
    private Parameter omegaParameter;
    private Parameter kappaParameter;
    private Parameter multintParameter;
    private EmpiricalCodonRateMatrix rateMat;
    private int modelType;
    private final int ECM_OMEGA_2K = 2;
    private final int ECM_OMEGA_9K = 3;
    private final int ECM_OMEGA_NU = 4;
    private final int ECM_OMEGA = 1;
    static String format1 = "%2.1e";
    static String format2 = "%2.4e";

    public EmpiricalCodonModel(Codons codons, Parameter parameter, Parameter parameter2, Parameter parameter3, EmpiricalCodonRateMatrix empiricalCodonRateMatrix, FrequencyModel frequencyModel) {
        super("empiricalCodonModel", codons, frequencyModel);
        this.omegaParameter = parameter;
        this.addVariable(this.omegaParameter);
        this.omegaParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, this.omegaParameter.getDimension()));
        if (parameter2 != null) {
            this.kappaParameter = parameter2;
            this.addVariable(this.kappaParameter);
            this.kappaParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, this.kappaParameter.getDimension()));
        }
        if (parameter3 != null) {
            this.multintParameter = parameter3;
            this.addVariable(this.multintParameter);
            this.multintParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, this.multintParameter.getDimension()));
        }
        this.rateMat = empiricalCodonRateMatrix;
        this.constructRateMap();
        this.checkForModelType();
    }

    private void checkForModelType() {
        this.modelType = 0;
        if (this.kappaParameter != null) {
            if (this.kappaParameter.getDimension() == 2) {
                this.modelType = 2;
                Logger.getLogger("dr.evomodel").info("Using model ECM+omega+2k");
            } else {
                this.modelType = 3;
                Logger.getLogger("dr.evomodel").info("Using model ECM+omega+9k");
            }
        }
        if (this.multintParameter != null) {
            this.modelType = 4;
            Logger.getLogger("dr.evomodel").info("Using model ECM+omega+nu");
        }
        if (this.kappaParameter == null && this.multintParameter == null) {
            this.modelType = 1;
            Logger.getLogger("dr.evomodel").info("Using model ECM+omega");
        }
    }

    @Override
    public void setupRelativeRates() {
        switch (this.modelType) {
            case 1: {
                this.setupRelativeRatesECMOmega();
                break;
            }
            case 2: {
                this.setupRelativeRatesECMOmega2k();
                break;
            }
            case 3: {
                this.setupRelativeRatesECMOmega9k();
                break;
            }
            case 4: {
                this.setupRelativeRatesECMOmegaNu();
            }
        }
    }

    private void setupRelativeRatesECMOmega() {
        double[] dArray = this.rateMat.getRates();
        double d = this.getOmega();
        block4: for (int i = 0; i < this.rateCount; ++i) {
            switch (this.rateMap[i]) {
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 17: {
                    this.relativeRates[i] = dArray[i];
                    continue block4;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: {
                    this.relativeRates[i] = dArray[i] * d;
                }
            }
        }
    }

    private void setupRelativeRatesECMOmega2k() {
        double[] dArray = this.rateMat.getRates();
        double d = this.getOmega();
        double d2 = this.getKappaTs();
        double d3 = this.getKappaTv();
        block20: for (int i = 0; i < this.rateCount; ++i) {
            switch (this.rateMap[i]) {
                case 1: {
                    this.relativeRates[i] = dArray[i] * d2;
                    continue block20;
                }
                case 2: {
                    this.relativeRates[i] = dArray[i] * d2 * d;
                    continue block20;
                }
                case 3: {
                    this.relativeRates[i] = dArray[i] * d3;
                    continue block20;
                }
                case 4: {
                    this.relativeRates[i] = dArray[i] * d3 * d;
                    continue block20;
                }
                case 5: {
                    this.relativeRates[i] = dArray[i] * d2 * d2;
                    continue block20;
                }
                case 6: {
                    this.relativeRates[i] = dArray[i] * d2 * d2 * d;
                    continue block20;
                }
                case 7: {
                    this.relativeRates[i] = dArray[i] * d2 * d3;
                    continue block20;
                }
                case 8: {
                    this.relativeRates[i] = dArray[i] * d2 * d3 * d;
                    continue block20;
                }
                case 9: {
                    this.relativeRates[i] = dArray[i] * d3 * d3;
                    continue block20;
                }
                case 10: {
                    this.relativeRates[i] = dArray[i] * d3 * d3 * d;
                    continue block20;
                }
                case 11: {
                    this.relativeRates[i] = dArray[i] * d2 * d2 * d2;
                    continue block20;
                }
                case 12: {
                    this.relativeRates[i] = dArray[i] * d2 * d2 * d2 * d;
                    continue block20;
                }
                case 13: {
                    this.relativeRates[i] = dArray[i] * d2 * d2 * d3;
                    continue block20;
                }
                case 14: {
                    this.relativeRates[i] = dArray[i] * d2 * d2 * d3 * d;
                    continue block20;
                }
                case 15: {
                    this.relativeRates[i] = dArray[i] * d2 * d3 * d3;
                    continue block20;
                }
                case 16: {
                    this.relativeRates[i] = dArray[i] * d2 * d3 * d3 * d;
                    continue block20;
                }
                case 17: {
                    this.relativeRates[i] = dArray[i] * d3 * d3 * d3;
                    continue block20;
                }
                case 18: {
                    this.relativeRates[i] = dArray[i] * d3 * d3 * d3 * d;
                }
            }
        }
    }

    private void setupRelativeRatesECMOmega9k() {
        double[] dArray = this.rateMat.getRates();
        double d = this.getOmega();
        double[] dArray2 = this.getKappa();
        block20: for (int i = 0; i < this.rateCount; ++i) {
            switch (this.rateMap[i]) {
                case 1: {
                    this.relativeRates[i] = dArray[i] * dArray2[0];
                    continue block20;
                }
                case 2: {
                    this.relativeRates[i] = dArray[i] * dArray2[0] * d;
                    continue block20;
                }
                case 3: {
                    this.relativeRates[i] = dArray[i] * dArray2[1];
                    continue block20;
                }
                case 4: {
                    this.relativeRates[i] = dArray[i] * dArray2[1] * d;
                    continue block20;
                }
                case 5: {
                    this.relativeRates[i] = dArray[i] * dArray2[2];
                    continue block20;
                }
                case 6: {
                    this.relativeRates[i] = dArray[i] * dArray2[2] * d;
                    continue block20;
                }
                case 7: {
                    this.relativeRates[i] = dArray[i] * dArray2[3];
                    continue block20;
                }
                case 8: {
                    this.relativeRates[i] = dArray[i] * dArray2[3] * d;
                    continue block20;
                }
                case 9: {
                    this.relativeRates[i] = dArray[i] * dArray2[4];
                    continue block20;
                }
                case 10: {
                    this.relativeRates[i] = dArray[i] * dArray2[4] * d;
                    continue block20;
                }
                case 11: {
                    this.relativeRates[i] = dArray[i] * dArray2[5];
                    continue block20;
                }
                case 12: {
                    this.relativeRates[i] = dArray[i] * dArray2[5] * d;
                    continue block20;
                }
                case 13: {
                    this.relativeRates[i] = dArray[i] * dArray2[6];
                    continue block20;
                }
                case 14: {
                    this.relativeRates[i] = dArray[i] * dArray2[6] * d;
                    continue block20;
                }
                case 15: {
                    this.relativeRates[i] = dArray[i] * dArray2[7];
                    continue block20;
                }
                case 16: {
                    this.relativeRates[i] = dArray[i] * dArray2[7] * d;
                    continue block20;
                }
                case 17: {
                    this.relativeRates[i] = dArray[i] * dArray2[8];
                    continue block20;
                }
                case 18: {
                    this.relativeRates[i] = dArray[i] * dArray2[8] * d;
                }
            }
        }
    }

    private void setupRelativeRatesECMOmegaNu() {
        double[] dArray = this.rateMat.getRates();
        double d = this.getOmega();
        double d2 = this.getMultiNt();
        block6: for (int i = 0; i < this.rateCount; ++i) {
            switch (this.rateMap[i]) {
                case 1: 
                case 3: {
                    this.relativeRates[i] = dArray[i];
                    continue block6;
                }
                case 2: 
                case 4: {
                    this.relativeRates[i] = dArray[i] * d;
                    continue block6;
                }
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 17: {
                    this.relativeRates[i] = dArray[i] * d2;
                    continue block6;
                }
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: {
                    this.relativeRates[i] = dArray[i] * d2 * d;
                }
            }
        }
    }

    @Override
    protected void ratesChanged() {
    }

    @Override
    protected void frequenciesChanged() {
    }

    public void setOmega(double d) {
        this.omegaParameter.setParameterValue(0, d);
        this.updateMatrix = true;
    }

    public double getOmega() {
        return this.omegaParameter.getParameterValue(0);
    }

    public void setKappa(double d, double d2) {
        if (this.kappaParameter != null) {
            this.kappaParameter.setParameterValue(0, d);
            this.kappaParameter.setParameterValue(1, d2);
            this.updateMatrix = true;
        }
    }

    public double getKappaTs() {
        if (this.kappaParameter != null) {
            return this.kappaParameter.getParameterValue(0);
        }
        return 0.0;
    }

    public double getKappaTv() {
        if (this.kappaParameter != null) {
            return this.kappaParameter.getParameterValue(1);
        }
        return 0.0;
    }

    public double[] getKappa() {
        if (this.kappaParameter != null) {
            return this.kappaParameter.getParameterValues();
        }
        return new double[9];
    }

    public void setMultiNt(double d) {
        if (this.multintParameter != null) {
            this.multintParameter.setParameterValue(0, d);
            this.updateMatrix = true;
        }
    }

    public double getMultiNt() {
        if (this.multintParameter != null) {
            return this.multintParameter.getParameterValue(0);
        }
        return 0.0;
    }

    protected void constructRateMap() {
        int n = 0;
        this.rateMap = new byte[this.rateCount];
        for (int i = 0; i < this.stateCount; ++i) {
            int[] nArray = this.codonDataType.getTripletStates(i);
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = nArray[2];
            int n5 = this.codonDataType.getState(n2, n3, n4);
            int n6 = this.geneticCode.getAminoAcidState(this.codonDataType.getCanonicalState(n5));
            for (int j = i + 1; j < this.stateCount; ++j) {
                int n7 = 0;
                int n8 = 0;
                boolean bl = false;
                int n9 = -1;
                nArray = this.codonDataType.getTripletStates(j);
                int n10 = nArray[0];
                int n11 = nArray[1];
                int n12 = nArray[2];
                int n13 = this.codonDataType.getState(n10, n11, n12);
                int n14 = this.geneticCode.getAminoAcidState(this.codonDataType.getCanonicalState(n13));
                if (n2 != n10) {
                    if (n2 == 0 && n10 == 2 || n2 == 2 && n10 == 0 || n2 == 1 && n10 == 3 || n2 == 3 && n10 == 1) {
                        ++n7;
                    } else {
                        ++n8;
                    }
                }
                if (n3 != n11) {
                    if (n3 == 0 && n11 == 2 || n3 == 2 && n11 == 0 || n3 == 1 && n11 == 3 || n3 == 3 && n11 == 1) {
                        ++n7;
                    } else {
                        ++n8;
                    }
                }
                if (n4 != n12) {
                    if (n4 == 0 && n12 == 2 || n4 == 2 && n12 == 0 || n4 == 1 && n12 == 3 || n4 == 3 && n12 == 1) {
                        ++n7;
                    } else {
                        ++n8;
                    }
                }
                if (n6 != n14) {
                    bl = true;
                }
                block0 : switch (n7) {
                    case 0: {
                        switch (n8) {
                            case 1: {
                                n9 = 3;
                                break block0;
                            }
                            case 2: {
                                n9 = 9;
                                break block0;
                            }
                            case 3: {
                                n9 = 17;
                                break block0;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (n8) {
                            case 0: {
                                n9 = 1;
                                break block0;
                            }
                            case 1: {
                                n9 = 7;
                                break block0;
                            }
                            case 2: {
                                n9 = 15;
                                break block0;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (n8) {
                            case 0: {
                                n9 = 5;
                                break block0;
                            }
                            case 1: {
                                n9 = 13;
                                break block0;
                            }
                        }
                        break;
                    }
                    case 3: {
                        n9 = 11;
                        break;
                    }
                }
                if (bl) {
                    n9 = (byte)(n9 + 1);
                }
                this.rateMap[n] = n9;
                ++n;
            }
        }
    }

    public void printRateMap() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray;
        int n6;
        System.out.print("\t");
        for (n6 = 0; n6 < this.stateCount; ++n6) {
            nArray = this.codonDataType.getTripletStates(n6);
            n5 = nArray[0];
            n4 = nArray[1];
            n3 = nArray[2];
            System.out.print("\t" + Nucleotides.INSTANCE.getChar(n5));
            System.out.print(Nucleotides.INSTANCE.getChar(n4));
            System.out.print(Nucleotides.INSTANCE.getChar(n3));
        }
        System.out.println();
        System.out.print("\t");
        for (n6 = 0; n6 < this.stateCount; ++n6) {
            nArray = this.codonDataType.getTripletStates(n6);
            n5 = nArray[0];
            n4 = nArray[1];
            n3 = nArray[2];
            n2 = this.codonDataType.getState(n5, n4, n3);
            n = this.geneticCode.getAminoAcidState(this.codonDataType.getCanonicalState(n2));
            System.out.print("\t" + AminoAcids.INSTANCE.getChar(n));
        }
        System.out.println();
        for (int i = 0; i < this.stateCount; ++i) {
            nArray = this.codonDataType.getTripletStates(i);
            int n7 = nArray[0];
            int n8 = nArray[1];
            int n9 = nArray[2];
            System.out.print(Nucleotides.INSTANCE.getChar(n7));
            System.out.print(Nucleotides.INSTANCE.getChar(n8));
            System.out.print(Nucleotides.INSTANCE.getChar(n9));
            int n10 = this.codonDataType.getState(n7, n8, n9);
            int n11 = this.geneticCode.getAminoAcidState(this.codonDataType.getCanonicalState(n10));
            System.out.print("\t" + AminoAcids.INSTANCE.getChar(n11));
            for (n6 = 0; n6 < this.stateCount; ++n6) {
                int n12 = 0;
                int n13 = 0;
                boolean bl = false;
                int n14 = -1;
                nArray = this.codonDataType.getTripletStates(n6);
                n5 = nArray[0];
                n4 = nArray[1];
                n3 = nArray[2];
                n2 = this.codonDataType.getState(n5, n4, n3);
                n = this.geneticCode.getAminoAcidState(this.codonDataType.getCanonicalState(n2));
                if (n7 != n5) {
                    if (n7 == 0 && n5 == 2 || n7 == 2 && n5 == 0 || n7 == 1 && n5 == 3 || n7 == 3 && n5 == 1) {
                        ++n12;
                    } else {
                        ++n13;
                    }
                }
                if (n8 != n4) {
                    if (n8 == 0 && n4 == 2 || n8 == 2 && n4 == 0 || n8 == 1 && n4 == 3 || n8 == 3 && n4 == 1) {
                        ++n12;
                    } else {
                        ++n13;
                    }
                }
                if (n9 != n3) {
                    if (n9 == 0 && n3 == 2 || n9 == 2 && n3 == 0 || n9 == 1 && n3 == 3 || n9 == 3 && n3 == 1) {
                        ++n12;
                    } else {
                        ++n13;
                    }
                }
                if (n11 != n) {
                    bl = true;
                }
                block0 : switch (n12) {
                    case 0: {
                        switch (n13) {
                            case 1: {
                                n14 = 3;
                                break block0;
                            }
                            case 2: {
                                n14 = 9;
                                break block0;
                            }
                            case 3: {
                                n14 = 17;
                                break block0;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (n13) {
                            case 0: {
                                n14 = 1;
                                break block0;
                            }
                            case 1: {
                                n14 = 7;
                                break block0;
                            }
                            case 2: {
                                n14 = 15;
                                break block0;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (n13) {
                            case 0: {
                                n14 = 5;
                                break block0;
                            }
                            case 1: {
                                n14 = 13;
                                break block0;
                            }
                        }
                        break;
                    }
                    case 3: {
                        n14 = 11;
                        break;
                    }
                }
                if (bl) {
                    n14 = (byte)(n14 + 1);
                }
                System.out.print("\t" + n14);
            }
            System.out.println();
        }
    }

    public String toXHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<em>Empirical Codon Model</em> omega = ");
        stringBuffer.append(this.getOmega());
        stringBuffer.append(", kappa_ts = ");
        stringBuffer.append(this.getKappaTs());
        stringBuffer.append(", kappa_tv = ");
        stringBuffer.append(this.getKappaTv());
        stringBuffer.append(", multi_nt = ");
        stringBuffer.append(this.getMultiNt());
        stringBuffer.append(", initial matrix = " + this.rateMat.getDirName() + "/" + this.rateMat.getMatName());
        stringBuffer.append(", initial freqs = " + this.rateMat.getDirName() + "/" + this.rateMat.getFreqName());
        return stringBuffer.toString();
    }

    public String printQ() {
        double[][] dArray = this.getQ();
        if (dArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[0].length; ++j) {
                    stringBuffer.append(String.format(format1, dArray[i][j]));
                    stringBuffer.append("\t");
                }
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
        return "No Q ready.";
    }

    public String printRelRates() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.relativeRates.length; ++i) {
            stringBuffer.append(String.format(format2, this.relativeRates[i]));
            stringBuffer.append("\t");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

