/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.prefs;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.neptuneinc.cadstat.prefs.DataPointColor;
import org.neptuneinc.cadstat.prefs.PlotCharacter;
import org.neptuneinc.cadstat.prefs.PreferencesManager;

public class PreferencesDialog
extends JDialog
implements ActionListener,
ChangeListener {
    public static final Float MAGNIFICATION_FACTOR = Float.valueOf(4.0f);
    private PreferencesManager prefsManager;
    private boolean settingsChanged;
    private JButton applyButton;
    private JPanel buttonPane;
    private JButton cancelButton;
    private JComboBox dataPointColor;
    private JPanel generalPane;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JSlider magAxis;
    private JSlider magAxisLabel;
    private JSlider magDataPoint;
    private JPanel magPane;
    private JSlider magPlotTitle;
    private JComboBox plotChar;
    private JPanel plotPane;
    private JButton saveButton;
    private JTabbedPane tabbedPane;

    public PreferencesDialog() {
        this.initComponents();
        this.initCustom();
    }

    protected void initCustom() {
        this.dataPointColor.setModel(new DefaultComboBoxModel<DataPointColor>(DataPointColor.values()));
        this.plotChar.setModel(new DefaultComboBoxModel<PlotCharacter>(PlotCharacter.values()));
        this.prefsManager = new PreferencesManager();
        this.importPreferences();
        this.dataPointColor.addActionListener(this);
        this.plotChar.addActionListener(this);
        this.magPlotTitle.addChangeListener(this);
        this.magAxis.addChangeListener(this);
        this.magAxisLabel.addChangeListener(this);
        this.magDataPoint.addChangeListener(this);
        this.setSettingsChanged(false);
        this.updateValidity();
        this.getRootPane().setDefaultButton(this.saveButton);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.plotPane = new JPanel();
        this.generalPane = new JPanel();
        this.jLabel1 = new JLabel();
        this.dataPointColor = new JComboBox();
        this.jLabel2 = new JLabel();
        this.plotChar = new JComboBox();
        this.magPane = new JPanel();
        this.jLabel4 = new JLabel();
        this.magPlotTitle = new JSlider();
        this.jLabel5 = new JLabel();
        this.magAxis = new JSlider();
        this.jLabel6 = new JLabel();
        this.magAxisLabel = new JSlider();
        this.jLabel7 = new JLabel();
        this.magDataPoint = new JSlider();
        this.buttonPane = new JPanel();
        this.cancelButton = new JButton();
        this.saveButton = new JButton();
        this.applyButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Preferences");
        this.generalPane.setBorder(BorderFactory.createTitledBorder("General"));
        this.jLabel1.setLabelFor(this.dataPointColor);
        this.jLabel1.setText("Data Point Color:");
        this.jLabel2.setLabelFor(this.plotChar);
        this.jLabel2.setText("Plotting Character:");
        GroupLayout generalPaneLayout = new GroupLayout(this.generalPane);
        this.generalPane.setLayout(generalPaneLayout);
        generalPaneLayout.setHorizontalGroup(generalPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPaneLayout.createSequentialGroup().addContainerGap().addGroup(generalPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(generalPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.plotChar, 0, 169, Short.MAX_VALUE).addComponent(this.dataPointColor, 0, 169, Short.MAX_VALUE)).addContainerGap()));
        generalPaneLayout.setVerticalGroup(generalPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPaneLayout.createSequentialGroup().addGroup(generalPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.dataPointColor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(generalPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.plotChar, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.magPane.setBorder(BorderFactory.createTitledBorder("Magnification"));
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setLabelFor(this.magPlotTitle);
        this.jLabel4.setText("Plot Title:");
        this.magPlotTitle.setMajorTickSpacing(2);
        this.magPlotTitle.setMaximum(12);
        this.magPlotTitle.setMinimum(2);
        this.magPlotTitle.setMinorTickSpacing(1);
        this.magPlotTitle.setPaintTrack(false);
        this.magPlotTitle.setSnapToTicks(true);
        this.magPlotTitle.setValue(4);
        this.jLabel5.setHorizontalAlignment(2);
        this.jLabel5.setLabelFor(this.magAxis);
        this.jLabel5.setText("Axis:");
        this.magAxis.setMajorTickSpacing(2);
        this.magAxis.setMaximum(12);
        this.magAxis.setMinimum(2);
        this.magAxis.setMinorTickSpacing(1);
        this.magAxis.setValue(4);
        this.jLabel6.setHorizontalAlignment(2);
        this.jLabel6.setLabelFor(this.magAxisLabel);
        this.jLabel6.setText("Axis Label:");
        this.magAxisLabel.setMajorTickSpacing(2);
        this.magAxisLabel.setMaximum(12);
        this.magAxisLabel.setMinimum(2);
        this.magAxisLabel.setMinorTickSpacing(1);
        this.magAxisLabel.setValue(4);
        this.jLabel7.setHorizontalAlignment(2);
        this.jLabel7.setLabelFor(this.magDataPoint);
        this.jLabel7.setText("Data Point:");
        this.magDataPoint.setMajorTickSpacing(2);
        this.magDataPoint.setMaximum(12);
        this.magDataPoint.setMinimum(2);
        this.magDataPoint.setMinorTickSpacing(1);
        this.magDataPoint.setValue(4);
        GroupLayout magPaneLayout = new GroupLayout(this.magPane);
        this.magPane.setLayout(magPaneLayout);
        magPaneLayout.setHorizontalGroup(magPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(magPaneLayout.createSequentialGroup().addContainerGap().addGroup(magPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6).addComponent(this.jLabel7).addComponent(this.jLabel5).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(magPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.magAxis, -1, 238, Short.MAX_VALUE).addComponent(this.magPlotTitle, -1, 238, Short.MAX_VALUE).addComponent(this.magAxisLabel, -1, 238, Short.MAX_VALUE).addComponent(this.magDataPoint, -1, 238, Short.MAX_VALUE)).addContainerGap()));
        magPaneLayout.setVerticalGroup(magPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(magPaneLayout.createSequentialGroup().addContainerGap().addGroup(magPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.magPlotTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(magPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.magAxis, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(magPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6).addComponent(this.magAxisLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(magPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel7).addComponent(this.magDataPoint, -2, -1, -2)).addGap(211, 211, 211)));
        GroupLayout plotPaneLayout = new GroupLayout(this.plotPane);
        this.plotPane.setLayout(plotPaneLayout);
        plotPaneLayout.setHorizontalGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPaneLayout.createSequentialGroup().addContainerGap().addGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.magPane, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.generalPane, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        plotPaneLayout.setVerticalGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.generalPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.magPane, -2, 259, -2).addContainerGap(13, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Plot", this.plotPane);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMargin(new Insets(0, 10, 0, 10));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.saveButton.setText("Save");
        this.saveButton.setMargin(new Insets(0, 10, 0, 10));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.saveButtonActionPerformed(evt);
            }
        });
        this.applyButton.setText("Apply");
        this.applyButton.setMargin(new Insets(0, 10, 0, 10));
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.applyButtonActionPerformed(evt);
            }
        });
        GroupLayout buttonPaneLayout = new GroupLayout(this.buttonPane);
        this.buttonPane.setLayout(buttonPaneLayout);
        buttonPaneLayout.setHorizontalGroup(buttonPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonPaneLayout.createSequentialGroup().addGap(71, 71, 71).addComponent(this.cancelButton, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.saveButton, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.applyButton, -1, -1, Short.MAX_VALUE).addGap(73, 73, 73)));
        buttonPaneLayout.setVerticalGroup(buttonPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveButton).addComponent(this.applyButton).addComponent(this.cancelButton)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonPane, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.tabbedPane, GroupLayout.Alignment.TRAILING, -1, 416, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonPane, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void importPreferences() {
        try {
            this.prefsManager.importPreferences();
        }
        catch (Exception ex) {
            Logger.getLogger(PreferencesDialog.class.getName()).log(Level.INFO, null, ex);
        }
        this.dataPointColor.setSelectedItem((Object)this.prefsManager.getCadstatPreferences().getDataPointColor());
        this.plotChar.setSelectedItem((Object)this.prefsManager.getCadstatPreferences().getPlotCharacter());
        this.magPlotTitle.setValue(Math.round(this.prefsManager.getCadstatPreferences().getPlotTitleMagnification().floatValue() * MAGNIFICATION_FACTOR.floatValue()));
        this.magAxis.setValue(Math.round(this.prefsManager.getCadstatPreferences().getAxisMagnification().floatValue() * MAGNIFICATION_FACTOR.floatValue()));
        this.magAxisLabel.setValue(Math.round(this.prefsManager.getCadstatPreferences().getAxisLabelMagnification().floatValue() * MAGNIFICATION_FACTOR.floatValue()));
        this.magDataPoint.setValue(Math.round(this.prefsManager.getCadstatPreferences().getDataPointMagnification().floatValue() * MAGNIFICATION_FACTOR.floatValue()));
    }

    private void exportPreferences() {
        this.prefsManager.getCadstatPreferences().setDataPointColor((DataPointColor)((Object)this.dataPointColor.getSelectedItem()));
        this.prefsManager.getCadstatPreferences().setPlotCharacter((PlotCharacter)((Object)this.plotChar.getSelectedItem()));
        this.prefsManager.getCadstatPreferences().setPlotTitleMagnification(Float.valueOf((float)this.magPlotTitle.getValue() / MAGNIFICATION_FACTOR.floatValue()));
        this.prefsManager.getCadstatPreferences().setAxisMagnification(Float.valueOf((float)this.magAxis.getValue() / MAGNIFICATION_FACTOR.floatValue()));
        this.prefsManager.getCadstatPreferences().setAxisLabelMagnification(Float.valueOf((float)this.magAxisLabel.getValue() / MAGNIFICATION_FACTOR.floatValue()));
        this.prefsManager.getCadstatPreferences().setDataPointMagnification(Float.valueOf((float)this.magDataPoint.getValue() / MAGNIFICATION_FACTOR.floatValue()));
        try {
            this.prefsManager.exportPreferences();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(PreferencesDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(PreferencesDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(PreferencesDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void processSettingChange() {
        this.setSettingsChanged(true);
        this.updateValidity();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.processSettingChange();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.processSettingChange();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.exportPreferences();
        this.dispose();
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.exportPreferences();
        this.setSettingsChanged(false);
        this.updateValidity();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void updateValidity() {
        this.applyButton.setEnabled(this.isSettingsChanged());
    }

    protected boolean isSettingsChanged() {
        return this.settingsChanged;
    }

    protected void setSettingsChanged(boolean settingsChanged) {
        this.settingsChanged = settingsChanged;
    }
}

