/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.alg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;

public abstract class IntArrayGraphAlgorithm<V, E> {
    protected final List<V> _vertices;
    protected final int[][] _neighbors;
    protected final Map<V, Integer> _vertexToPos;

    public IntArrayGraphAlgorithm(Graph<V, E> graph) {
        int n = graph.vertexSet().size();
        this._vertices = new ArrayList<V>(n);
        this._neighbors = new int[n][];
        this._vertexToPos = new HashMap<V, Integer>(n);
        for (V v : graph.vertexSet()) {
            this._neighbors[this._vertices.size()] = new int[graph.edgesOf(v).size()];
            this._vertexToPos.put((Integer)v, this._vertices.size());
            this._vertices.add(v);
        }
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            V v = this._vertices.get(i);
            for (E e : graph.edgesOf(v)) {
                this._neighbors[i][n2++] = this._vertexToPos.get(Graphs.getOppositeVertex(graph, e, v));
            }
        }
    }
}

