/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntIntIntFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseCCIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.colt.matrix.tint.impl.WrapperIntMatrix2D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.math.tint.IntMult;
import cern.jet.math.tint.IntPlusMultFirst;
import cern.jet.math.tint.IntPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseRCIntMatrix2D
extends WrapperIntMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] rowPointers;
    protected int[] columnIndexes;
    protected int[] values;
    protected boolean columnIndexesSorted;

    private static int searchFromTo(int[] nArray, int n, int n2, int n3) {
        while (n2 <= n3) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -(n2 + 1);
    }

    public SparseRCIntMatrix2D(int[][] nArray) {
        this(nArray.length, nArray.length == 0 ? 0 : nArray[0].length);
        this.assign(nArray);
    }

    public SparseRCIntMatrix2D(int n, int n2) {
        this(n, n2, (int)Math.min(10L * (long)n, Integer.MAX_VALUE));
    }

    public SparseRCIntMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.columnIndexes = new int[n3];
        this.values = new int[n3];
        this.rowPointers = new int[n + 1];
    }

    public SparseRCIntMatrix2D(int n, int n2, int[] nArray, int[] nArray2, int n3, boolean bl, boolean bl2) {
        int n4;
        block8: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block8;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (n3 == 0) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int n5 = Math.max(nArray.length, 1);
        this.columnIndexes = new int[n5];
        this.values = new int[n5];
        this.rowPointers = new int[n + 1];
        int[] nArray3 = new int[n];
        for (n4 = 0; n4 < n5; ++n4) {
            int n6 = nArray[n4];
            nArray3[n6] = nArray3[n6] + 1;
        }
        this.cumsum(this.rowPointers, nArray3, n);
        for (n4 = 0; n4 < n5; ++n4) {
            int n7 = nArray[n4];
            nArray3[n7] = nArray3[n7] + 1;
            this.columnIndexes[var10_12] = nArray2[n4];
            this.values[var10_12] = n3;
        }
        if (bl) {
            this.removeDuplicates();
        }
        if (bl2) {
            this.sortColumnIndexes();
        }
    }

    public SparseRCIntMatrix2D(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        block9: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block9;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (nArray.length != nArray3.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int n4 = Math.max(nArray.length, 1);
        this.columnIndexes = new int[n4];
        this.values = new int[n4];
        this.rowPointers = new int[n + 1];
        int[] nArray4 = new int[n];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            nArray4[n5] = nArray4[n5] + 1;
        }
        this.cumsum(this.rowPointers, nArray4, n);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            nArray4[n6] = nArray4[n6] + 1;
            this.columnIndexes[var11_13] = nArray2[n3];
            this.values[var11_13] = nArray3[n3];
        }
        if (bl2) {
            this.removeZeroes();
        }
        if (bl) {
            this.removeDuplicates();
        }
        if (bl3) {
            this.sortColumnIndexes();
        }
    }

    public SparseRCIntMatrix2D(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) {
        block3: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != n + 1) {
            throw new IllegalArgumentException("rowPointers.length != rows + 1");
        }
        this.rowPointers = nArray;
        this.columnIndexes = nArray2;
        this.values = nArray3;
    }

    public IntMatrix2D assign(final IntFunction intFunction) {
        if (intFunction instanceof IntMult) {
            int n = ((IntMult)intFunction).multiplicator;
            if (n == 1) {
                return this;
            }
            if (n == 0) {
                return this.assign(0);
            }
            if (n != n) {
                return this.assign(n);
            }
            int n2 = this.cardinality();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3++;
                this.values[n4] = this.values[n4] * n;
            }
        } else {
            this.forEachNonZero(new IntIntIntFunction(){

                public int apply(int n, int n2, int n3) {
                    return intFunction.apply(n3);
                }
            });
        }
        return this;
    }

    public IntMatrix2D assign(int n) {
        if (n == 0) {
            Arrays.fill(this.rowPointers, 0);
            Arrays.fill(this.columnIndexes, 0);
            Arrays.fill(this.values, 0);
        } else {
            int n2 = this.cardinality();
            for (int i = 0; i < n2; ++i) {
                this.values[i] = n;
            }
        }
        return this;
    }

    public IntMatrix2D assign(IntMatrix2D intMatrix2D) {
        if (intMatrix2D == this) {
            return this;
        }
        this.checkShape(intMatrix2D);
        if (intMatrix2D instanceof SparseRCIntMatrix2D) {
            SparseRCIntMatrix2D sparseRCIntMatrix2D = (SparseRCIntMatrix2D)intMatrix2D;
            System.arraycopy(sparseRCIntMatrix2D.rowPointers, 0, this.rowPointers, 0, this.rows + 1);
            int n = sparseRCIntMatrix2D.columnIndexes.length;
            if (this.columnIndexes.length < n) {
                this.columnIndexes = new int[n];
                this.values = new int[n];
            }
            System.arraycopy(sparseRCIntMatrix2D.columnIndexes, 0, this.columnIndexes, 0, n);
            System.arraycopy(sparseRCIntMatrix2D.values, 0, this.values, 0, n);
            this.columnIndexesSorted = sparseRCIntMatrix2D.columnIndexesSorted;
        } else if (intMatrix2D instanceof SparseCCIntMatrix2D) {
            SparseCCIntMatrix2D sparseCCIntMatrix2D = ((SparseCCIntMatrix2D)intMatrix2D).getTranspose();
            this.rowPointers = sparseCCIntMatrix2D.getColumnPointers();
            this.columnIndexes = sparseCCIntMatrix2D.getRowIndexes();
            this.values = sparseCCIntMatrix2D.getValues();
            this.columnIndexesSorted = true;
        } else {
            this.assign(0);
            intMatrix2D.forEachNonZero(new IntIntIntFunction(){

                public int apply(int n, int n2, int n3) {
                    SparseRCIntMatrix2D.this.setQuick(n, n2, n3);
                    return n3;
                }
            });
        }
        return this;
    }

    public IntMatrix2D assign(IntMatrix2D intMatrix2D, IntIntFunction intIntFunction) {
        this.checkShape(intMatrix2D);
        if (intMatrix2D instanceof SparseRCIntMatrix2D && intIntFunction == IntFunctions.plus) {
            SparseRCIntMatrix2D sparseRCIntMatrix2D = (SparseRCIntMatrix2D)intMatrix2D;
            int[] nArray = sparseRCIntMatrix2D.rowPointers;
            int[] nArray2 = sparseRCIntMatrix2D.columnIndexes;
            int[] nArray3 = sparseRCIntMatrix2D.values;
            int[] nArray4 = new int[this.rows + 1];
            int n = Math.max(this.columnIndexes.length, Math.min(Integer.MAX_VALUE, this.rowPointers[this.rows] + nArray[this.rows]));
            int[] nArray5 = new int[n];
            int[] nArray6 = new int[n];
            int n2 = this.rows;
            int n3 = this.columns;
            int n4 = nArray6.length;
            if (intIntFunction == IntFunctions.plus) {
                int n5;
                nArray4[0] = n5 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n6 = this.rowPointers[i];
                    int n7 = nArray[i];
                    int n8 = this.rowPointers[i + 1] - 1;
                    int n9 = nArray[i + 1] - 1;
                    while (n6 <= n8 || n7 <= n9) {
                        int n10;
                        int n11 = n6 <= n8 ? this.columnIndexes[n6] : n3 + 1;
                        if (n11 == (n10 = n7 <= n9 ? nArray2[n7] : n3 + 1)) {
                            nArray6[n5] = this.values[n6] + nArray3[n7];
                            nArray5[n5] = n11;
                            ++n6;
                            ++n7;
                            ++n5;
                        } else if (n11 < n10) {
                            nArray5[n5] = n11;
                            nArray6[n5] = this.values[n6];
                            ++n6;
                            ++n5;
                        } else if (n11 > n10) {
                            nArray5[n5] = n10;
                            nArray6[n5] = nArray3[n7];
                            ++n7;
                            ++n5;
                        }
                        if (n5 < n4) continue;
                        throw new IllegalArgumentException("The number of elements in C exceeds nzmax");
                    }
                    nArray4[i + 1] = n5;
                }
                this.rowPointers = nArray4;
                this.columnIndexes = nArray5;
                this.values = nArray6;
                return this;
            }
        }
        if (intIntFunction instanceof IntPlusMultSecond) {
            final int n = ((IntPlusMultSecond)intIntFunction).multiplicator;
            if (n == 0) {
                return this;
            }
            intMatrix2D.forEachNonZero(new IntIntIntFunction(){

                public int apply(int n4, int n2, int n3) {
                    SparseRCIntMatrix2D.this.setQuick(n4, n2, SparseRCIntMatrix2D.this.getQuick(n4, n2) + n * n3);
                    return n3;
                }
            });
            return this;
        }
        if (intIntFunction instanceof IntPlusMultFirst) {
            final int n = ((IntPlusMultFirst)intIntFunction).multiplicator;
            if (n == 0) {
                return this.assign(intMatrix2D);
            }
            intMatrix2D.forEachNonZero(new IntIntIntFunction(){

                public int apply(int n4, int n2, int n3) {
                    SparseRCIntMatrix2D.this.setQuick(n4, n2, n * SparseRCIntMatrix2D.this.getQuick(n4, n2) + n3);
                    return n3;
                }
            });
            return this;
        }
        if (intIntFunction == IntFunctions.mult) {
            int n = this.rows;
            while (--n >= 0) {
                int n12 = this.rowPointers[n];
                int n13 = this.rowPointers[n + 1];
                while (--n13 >= n12) {
                    int n14 = this.columnIndexes[n13];
                    int n15 = n13;
                    this.values[n15] = this.values[n15] * intMatrix2D.getQuick(n, n14);
                    if (this.values[n13] != 0) continue;
                    this.remove(n, n14);
                }
            }
            return this;
        }
        if (intIntFunction == IntFunctions.div) {
            int n = this.rows;
            while (--n >= 0) {
                int n16 = this.rowPointers[n];
                int n17 = this.rowPointers[n + 1];
                while (--n17 >= n16) {
                    int n18 = this.columnIndexes[n17];
                    int n19 = n17;
                    this.values[n19] = this.values[n19] / intMatrix2D.getQuick(n, n18);
                    if (this.values[n17] != 0) continue;
                    this.remove(n, n18);
                }
            }
            return this;
        }
        return super.assign(intMatrix2D, intIntFunction);
    }

    public int cardinality() {
        return this.rowPointers[this.rows];
    }

    public IntMatrix2D forEachNonZero(IntIntIntFunction intIntIntFunction) {
        int n = this.rows;
        while (--n >= 0) {
            int n2 = this.rowPointers[n];
            int n3 = this.rowPointers[n + 1];
            while (--n3 >= n2) {
                int n4 = this.columnIndexes[n3];
                int n5 = this.values[n3];
                int n6 = intIntIntFunction.apply(n, n4, n5);
                if (n6 == n5) continue;
                this.values[n3] = n6;
            }
        }
        return this;
    }

    public SparseCCIntMatrix2D getColumnCompressed() {
        SparseRCIntMatrix2D sparseRCIntMatrix2D = this.getTranspose();
        SparseCCIntMatrix2D sparseCCIntMatrix2D = new SparseCCIntMatrix2D(this.rows, this.columns);
        sparseCCIntMatrix2D.rowIndexes = sparseRCIntMatrix2D.columnIndexes;
        sparseCCIntMatrix2D.columnPointers = sparseRCIntMatrix2D.rowPointers;
        sparseCCIntMatrix2D.values = sparseRCIntMatrix2D.values;
        sparseCCIntMatrix2D.rowIndexesSorted = true;
        return sparseCCIntMatrix2D;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public DenseIntMatrix2D getDense() {
        final DenseIntMatrix2D denseIntMatrix2D = new DenseIntMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntIntFunction(){

            public int apply(int n, int n2, int n3) {
                denseIntMatrix2D.setQuick(n, n2, SparseRCIntMatrix2D.this.getQuick(n, n2));
                return n3;
            }
        });
        return denseIntMatrix2D;
    }

    public synchronized int getQuick(int n, int n2) {
        int n3 = SparseRCIntMatrix2D.searchFromTo(this.columnIndexes, n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        int n4 = 0;
        if (n3 >= 0) {
            n4 = this.values[n3];
        }
        return n4;
    }

    public int[] getRowPointers() {
        return this.rowPointers;
    }

    public SparseRCIntMatrix2D getTranspose() {
        int n = this.rowPointers[this.rows];
        int[] nArray = new int[this.columns];
        int[] nArray2 = new int[this.columns + 1];
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = this.columnIndexes[i];
            nArray[n2] = nArray[n2] + 1;
        }
        this.cumsum(nArray2, nArray, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            int n3 = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < n3; ++j) {
                int n4 = this.columnIndexes[j];
                nArray[n4] = nArray[n4] + 1;
                nArray3[i] = i;
                nArray4[i] = this.values[j];
            }
        }
        SparseRCIntMatrix2D sparseRCIntMatrix2D = new SparseRCIntMatrix2D(this.columns, this.rows);
        sparseRCIntMatrix2D.rowPointers = nArray2;
        sparseRCIntMatrix2D.columnIndexes = nArray3;
        sparseRCIntMatrix2D.values = nArray4;
        return sparseRCIntMatrix2D;
    }

    public int[] getValues() {
        return this.values;
    }

    public boolean hasColumnIndexesSorted() {
        return this.columnIndexesSorted;
    }

    public IntMatrix2D like(int n, int n2) {
        return new SparseRCIntMatrix2D(n, n2);
    }

    public IntMatrix1D like1D(int n) {
        return new SparseIntMatrix1D(n);
    }

    public void removeDuplicates() {
        int n;
        int n2 = 0;
        int[] nArray = new int[this.columns];
        for (n = 0; n < this.columns; ++n) {
            nArray[n] = -1;
        }
        for (int i = 0; i < this.rows; ++i) {
            int n3 = n2;
            for (int j = this.rowPointers[i]; j < this.rowPointers[i + 1]; ++j) {
                n = this.columnIndexes[j];
                if (nArray[n] >= n3) {
                    int n4 = nArray[n];
                    this.values[n4] = this.values[n4] + this.values[j];
                    continue;
                }
                nArray[n] = n2;
                this.columnIndexes[n2] = n;
                this.values[n2++] = this.values[j];
            }
            this.rowPointers[i] = n3;
        }
        this.rowPointers[this.rows] = n2;
    }

    public void removeZeroes() {
        int n = 0;
        for (int i = 0; i < this.rows; ++i) {
            this.rowPointers[i] = n;
            for (int j = this.rowPointers[i]; j < this.rowPointers[i + 1]; ++j) {
                if (this.values[j] == 0) continue;
                this.values[n] = this.values[j];
                this.columnIndexes[n++] = this.columnIndexes[j];
            }
        }
        this.rowPointers[this.rows] = n;
    }

    public synchronized void setQuick(int n, int n2, int n3) {
        int n4 = SparseRCIntMatrix2D.searchFromTo(this.columnIndexes, n2, this.rowPointers[n], this.rowPointers[n + 1] - 1);
        if (n4 >= 0) {
            if (n3 == 0) {
                this.remove(n, n4);
            } else {
                this.values[n4] = n3;
            }
            return;
        }
        if (n3 != 0) {
            n4 = -n4 - 1;
            this.insert(n, n2, n4, n3);
        }
    }

    public void sortColumnIndexes() {
        SparseRCIntMatrix2D sparseRCIntMatrix2D = this.getTranspose();
        this.rows = sparseRCIntMatrix2D.rows;
        this.columns = sparseRCIntMatrix2D.columns;
        this.columnIndexes = sparseRCIntMatrix2D.columnIndexes;
        this.rowPointers = sparseRCIntMatrix2D.rowPointers;
        this.values = sparseRCIntMatrix2D.values;
        sparseRCIntMatrix2D = this.getTranspose();
        this.rows = sparseRCIntMatrix2D.rows;
        this.columns = sparseRCIntMatrix2D.columns;
        this.columnIndexes = sparseRCIntMatrix2D.columnIndexes;
        this.rowPointers = sparseRCIntMatrix2D.rowPointers;
        this.values = sparseRCIntMatrix2D.values;
        this.columnIndexesSorted = true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.rows; ++i) {
            int n = this.rowPointers[i + 1];
            for (int j = this.rowPointers[i]; j < n; ++j) {
                stringBuilder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[j]).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public void trimToSize() {
        this.realloc(0);
    }

    public IntMatrix1D zMult(IntMatrix1D intMatrix1D, IntMatrix1D intMatrix1D2, final int n, final int n2, boolean bl) {
        boolean bl2;
        int n3 = bl ? this.columns : this.rows;
        int n4 = bl ? this.rows : this.columns;
        boolean bl3 = bl2 = intMatrix1D2 == null || !bl;
        if (intMatrix1D2 == null) {
            intMatrix1D2 = new DenseIntMatrix1D(n3);
        }
        if (!(intMatrix1D instanceof DenseIntMatrix1D) || !(intMatrix1D2 instanceof DenseIntMatrix1D)) {
            return super.zMult(intMatrix1D, intMatrix1D2, n, n2, bl);
        }
        if ((long)n4 != intMatrix1D.size() || (long)n3 > intMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + intMatrix1D.toStringShort() + ", " + intMatrix1D2.toStringShort());
        }
        DenseIntMatrix1D denseIntMatrix1D = (DenseIntMatrix1D)intMatrix1D2;
        final int[] nArray = denseIntMatrix1D.elements;
        final int n5 = denseIntMatrix1D.stride();
        final int n6 = (int)intMatrix1D2.index(0);
        DenseIntMatrix1D denseIntMatrix1D2 = (DenseIntMatrix1D)intMatrix1D;
        final int[] nArray2 = denseIntMatrix1D2.elements;
        final int n7 = denseIntMatrix1D2.stride();
        final int n8 = (int)intMatrix1D.index(0);
        int n9 = ConcurrencyUtils.getNumberOfThreads();
        if (bl) {
            if (!bl2 && (double)n2 != 1.0) {
                intMatrix1D2.assign(IntFunctions.mult(n2));
            }
            if (n9 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n10;
                int n11;
                n9 = 2;
                Future[] futureArray = new Future[n9];
                final int[] nArray3 = new int[n3];
                int n12 = this.rows / n9;
                for (n11 = 0; n11 < n9; ++n11) {
                    n10 = n11 * n12;
                    final int n13 = n11 == n9 - 1 ? this.rows : n10 + n12;
                    final int n14 = n11;
                    futureArray[n11] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            if (n14 == 0) {
                                for (int i = n10; i < n13; ++i) {
                                    int n9 = SparseRCIntMatrix2D.this.rowPointers[i + 1];
                                    int n2 = n * nArray2[n8 + n7 * i];
                                    for (int j = SparseRCIntMatrix2D.this.rowPointers[i]; j < n9; ++j) {
                                        int n3 = SparseRCIntMatrix2D.this.columnIndexes[j];
                                        int n4 = n6 + n5 * n3;
                                        nArray[n4] = nArray[n4] + SparseRCIntMatrix2D.this.values[j] * n2;
                                    }
                                }
                            } else {
                                for (int i = n10; i < n13; ++i) {
                                    int n11 = SparseRCIntMatrix2D.this.rowPointers[i + 1];
                                    int n52 = n * nArray2[n8 + n7 * i];
                                    for (int j = SparseRCIntMatrix2D.this.rowPointers[i]; j < n11; ++j) {
                                        int n62;
                                        int n72 = n62 = SparseRCIntMatrix2D.this.columnIndexes[j];
                                        nArray3[n72] = nArray3[n72] + SparseRCIntMatrix2D.this.values[j] * n52;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n10 = n11 = n3 % 10; n10 < n3; n10 += 10) {
                    int n15 = n6 + n10 * n5;
                    nArray[n15] = nArray[n15] + nArray3[n10];
                    int n16 = n6 + (n10 + 1) * n5;
                    nArray[n16] = nArray[n16] + nArray3[n10 + 1];
                    int n17 = n6 + (n10 + 2) * n5;
                    nArray[n17] = nArray[n17] + nArray3[n10 + 2];
                    int n18 = n6 + (n10 + 3) * n5;
                    nArray[n18] = nArray[n18] + nArray3[n10 + 3];
                    int n19 = n6 + (n10 + 4) * n5;
                    nArray[n19] = nArray[n19] + nArray3[n10 + 4];
                    int n20 = n6 + (n10 + 5) * n5;
                    nArray[n20] = nArray[n20] + nArray3[n10 + 5];
                    int n21 = n6 + (n10 + 6) * n5;
                    nArray[n21] = nArray[n21] + nArray3[n10 + 6];
                    int n22 = n6 + (n10 + 7) * n5;
                    nArray[n22] = nArray[n22] + nArray3[n10 + 7];
                    int n23 = n6 + (n10 + 8) * n5;
                    nArray[n23] = nArray[n23] + nArray3[n10 + 8];
                    int n24 = n6 + (n10 + 9) * n5;
                    nArray[n24] = nArray[n24] + nArray3[n10 + 9];
                }
                for (n10 = 0; n10 < n11; ++n10) {
                    int n25 = n6 + n10 * n5;
                    nArray[n25] = nArray[n25] + nArray3[n10];
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    int n26 = this.rowPointers[i + 1];
                    int n27 = n * nArray2[n8 + n7 * i];
                    for (int j = this.rowPointers[i]; j < n26; ++j) {
                        int n28 = this.columnIndexes[j];
                        int n29 = n6 + n5 * n28;
                        nArray[n29] = nArray[n29] + this.values[j] * n27;
                    }
                }
            }
            return intMatrix1D2;
        }
        if (n9 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n9 = Math.min(n9, this.rows);
            Future[] futureArray = new Future[n9];
            int n30 = this.rows / n9;
            for (int i = 0; i < n9; ++i) {
                final int n31 = i * n30;
                final int n32 = i == n9 - 1 ? this.rows : n31 + n30;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n9 = n6 + n31 * n5;
                        int n22 = SparseRCIntMatrix2D.this.rowPointers[n31];
                        if ((double)n2 == 0.0) {
                            for (int i = n31; i < n32; ++i) {
                                int n3 = 0;
                                int n4 = SparseRCIntMatrix2D.this.rowPointers[i + 1];
                                while (n22 + 10 < n4) {
                                    int n52 = n22 + 9;
                                    n3 += SparseRCIntMatrix2D.this.values[n52] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n52--]] + SparseRCIntMatrix2D.this.values[n52] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n52--]] + SparseRCIntMatrix2D.this.values[n52] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n52--]] + SparseRCIntMatrix2D.this.values[n52] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n52--]] + SparseRCIntMatrix2D.this.values[n52] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n52--]] + SparseRCIntMatrix2D.this.values[n52] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n52--]] + SparseRCIntMatrix2D.this.values[n52] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n52--]] + SparseRCIntMatrix2D.this.values[n52] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n52--]] + SparseRCIntMatrix2D.this.values[n52] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n52--]] + SparseRCIntMatrix2D.this.values[n52] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n52--]];
                                    n22 += 10;
                                }
                                while (n22 < n4) {
                                    n3 += SparseRCIntMatrix2D.this.values[n22] * nArray2[SparseRCIntMatrix2D.this.columnIndexes[n22]];
                                    ++n22;
                                }
                                nArray[n9] = n * n3;
                                n9 += n5;
                            }
                        } else {
                            for (int i = n31; i < n32; ++i) {
                                int n62 = 0;
                                int n72 = SparseRCIntMatrix2D.this.rowPointers[i + 1];
                                while (n22 + 10 < n72) {
                                    int n82 = n22 + 9;
                                    n62 += SparseRCIntMatrix2D.this.values[n82] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n82--]] + SparseRCIntMatrix2D.this.values[n82] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n82--]] + SparseRCIntMatrix2D.this.values[n82] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n82--]] + SparseRCIntMatrix2D.this.values[n82] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n82--]] + SparseRCIntMatrix2D.this.values[n82] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n82--]] + SparseRCIntMatrix2D.this.values[n82] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n82--]] + SparseRCIntMatrix2D.this.values[n82] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n82--]] + SparseRCIntMatrix2D.this.values[n82] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n82--]] + SparseRCIntMatrix2D.this.values[n82] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n82--]] + SparseRCIntMatrix2D.this.values[n82] * nArray2[n8 + n7 * SparseRCIntMatrix2D.this.columnIndexes[n82--]];
                                    n22 += 10;
                                }
                                while (n22 < n72) {
                                    n62 += SparseRCIntMatrix2D.this.values[n22] * nArray2[SparseRCIntMatrix2D.this.columnIndexes[n22]];
                                    ++n22;
                                }
                                nArray[n9] = n * n62 + n2 * nArray[n9];
                                n9 += n5;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n33 = n6;
            int n34 = this.rowPointers[0];
            if ((double)n2 == 0.0) {
                for (int i = 0; i < this.rows; ++i) {
                    int n35 = 0;
                    int n36 = this.rowPointers[i + 1];
                    while (n34 + 10 < n36) {
                        int n37 = n34 + 9;
                        n35 += this.values[n37] * nArray2[n8 + n7 * this.columnIndexes[n37--]] + this.values[n37] * nArray2[n8 + n7 * this.columnIndexes[n37--]] + this.values[n37] * nArray2[n8 + n7 * this.columnIndexes[n37--]] + this.values[n37] * nArray2[n8 + n7 * this.columnIndexes[n37--]] + this.values[n37] * nArray2[n8 + n7 * this.columnIndexes[n37--]] + this.values[n37] * nArray2[n8 + n7 * this.columnIndexes[n37--]] + this.values[n37] * nArray2[n8 + n7 * this.columnIndexes[n37--]] + this.values[n37] * nArray2[n8 + n7 * this.columnIndexes[n37--]] + this.values[n37] * nArray2[n8 + n7 * this.columnIndexes[n37--]] + this.values[n37] * nArray2[n8 + n7 * this.columnIndexes[n37--]];
                        n34 += 10;
                    }
                    while (n34 < n36) {
                        n35 += this.values[n34] * nArray2[this.columnIndexes[n34]];
                        ++n34;
                    }
                    nArray[n33] = n * n35;
                    n33 += n5;
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    int n38 = 0;
                    int n39 = this.rowPointers[i + 1];
                    while (n34 + 10 < n39) {
                        int n40 = n34 + 9;
                        n38 += this.values[n40] * nArray2[n8 + n7 * this.columnIndexes[n40--]] + this.values[n40] * nArray2[n8 + n7 * this.columnIndexes[n40--]] + this.values[n40] * nArray2[n8 + n7 * this.columnIndexes[n40--]] + this.values[n40] * nArray2[n8 + n7 * this.columnIndexes[n40--]] + this.values[n40] * nArray2[n8 + n7 * this.columnIndexes[n40--]] + this.values[n40] * nArray2[n8 + n7 * this.columnIndexes[n40--]] + this.values[n40] * nArray2[n8 + n7 * this.columnIndexes[n40--]] + this.values[n40] * nArray2[n8 + n7 * this.columnIndexes[n40--]] + this.values[n40] * nArray2[n8 + n7 * this.columnIndexes[n40--]] + this.values[n40] * nArray2[n8 + n7 * this.columnIndexes[n40--]];
                        n34 += 10;
                    }
                    while (n34 < n39) {
                        n38 += this.values[n34] * nArray2[this.columnIndexes[n34]];
                        ++n34;
                    }
                    nArray[n33] = n * n38 + n2 * nArray[n33];
                    n33 += n5;
                }
            }
        }
        return intMatrix1D2;
    }

    public IntMatrix2D zMult(IntMatrix2D intMatrix2D, IntMatrix2D intMatrix2D2, int n, int n2, boolean bl, boolean bl2) {
        boolean bl3;
        int n3 = this.rows;
        int n4 = this.columns;
        if (bl) {
            n3 = this.columns;
            n4 = this.rows;
        }
        int n5 = intMatrix2D.rows();
        int n6 = intMatrix2D.columns();
        if (bl2) {
            n5 = intMatrix2D.columns();
            n6 = intMatrix2D.rows();
        }
        int n7 = n6;
        boolean bl4 = bl3 = intMatrix2D2 == null;
        if (intMatrix2D2 == null) {
            intMatrix2D2 = intMatrix2D instanceof SparseRCIntMatrix2D ? new SparseRCIntMatrix2D(n3, n7, n3 * n7) : new DenseIntMatrix2D(n3, n7);
        }
        if (n5 != n4) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? intMatrix2D.viewDice() : intMatrix2D).toStringShort());
        }
        if (intMatrix2D2.rows() != n3 || intMatrix2D2.columns() != n7) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (bl2 ? intMatrix2D.viewDice() : intMatrix2D).toStringShort() + ", " + intMatrix2D2.toStringShort());
        }
        if (this == intMatrix2D2 || intMatrix2D == intMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3 && (double)n2 != 1.0) {
            intMatrix2D2.assign(IntFunctions.mult(n2));
        }
        if (intMatrix2D instanceof DenseIntMatrix2D && intMatrix2D2 instanceof DenseIntMatrix2D) {
            SparseRCIntMatrix2D sparseRCIntMatrix2D = bl ? this.getTranspose() : this;
            DenseIntMatrix2D denseIntMatrix2D = bl2 ? (DenseIntMatrix2D)intMatrix2D.viewDice() : (DenseIntMatrix2D)intMatrix2D;
            DenseIntMatrix2D denseIntMatrix2D2 = (DenseIntMatrix2D)intMatrix2D2;
            int[] nArray = sparseRCIntMatrix2D.rowPointers;
            int[] nArray2 = sparseRCIntMatrix2D.columnIndexes;
            int[] nArray3 = sparseRCIntMatrix2D.values;
            for (int i = 0; i < n3; ++i) {
                int n8 = nArray[i + 1];
                for (int j = nArray[i]; j < n8; ++j) {
                    int n9 = nArray3[j] * n;
                    int n10 = nArray2[j];
                    denseIntMatrix2D2.viewRow(i).assign(denseIntMatrix2D.viewRow(n10), IntFunctions.plusMultSecond(n9));
                }
            }
        } else if (intMatrix2D instanceof SparseRCIntMatrix2D && intMatrix2D2 instanceof SparseRCIntMatrix2D) {
            int n11;
            SparseRCIntMatrix2D sparseRCIntMatrix2D = (SparseRCIntMatrix2D)intMatrix2D2;
            SparseRCIntMatrix2D sparseRCIntMatrix2D2 = bl ? this.getTranspose() : this;
            SparseRCIntMatrix2D sparseRCIntMatrix2D3 = bl2 ? ((SparseRCIntMatrix2D)intMatrix2D).getTranspose() : (SparseRCIntMatrix2D)intMatrix2D;
            int[] nArray = sparseRCIntMatrix2D2.rowPointers;
            int[] nArray4 = sparseRCIntMatrix2D2.columnIndexes;
            int[] nArray5 = sparseRCIntMatrix2D2.values;
            int[] nArray6 = sparseRCIntMatrix2D3.rowPointers;
            int[] nArray7 = sparseRCIntMatrix2D3.columnIndexes;
            int[] nArray8 = sparseRCIntMatrix2D3.values;
            int[] nArray9 = sparseRCIntMatrix2D.rowPointers;
            int[] nArray10 = sparseRCIntMatrix2D.columnIndexes;
            int[] nArray11 = sparseRCIntMatrix2D.values;
            int n12 = nArray11.length;
            int[] nArray12 = new int[n6 + 1];
            for (n11 = 0; n11 < nArray12.length; ++n11) {
                nArray12[n11] = -1;
            }
            n11 = -1;
            for (int i = 0; i < n3; ++i) {
                int n13;
                int n14 = nArray[i + 1];
                for (n13 = nArray[i]; n13 < n14; ++n13) {
                    int n15 = nArray5[n13] * n;
                    int n16 = nArray4[n13];
                    int n17 = nArray6[n16 + 1];
                    for (int j = nArray6[n16]; j < n17; ++j) {
                        int n18 = nArray7[j];
                        int n19 = nArray12[n18];
                        if (n19 == -1) {
                            if (++n11 >= n12) {
                                throw new IllegalArgumentException("The max number of nonzero elements in C is too small.");
                            }
                            nArray10[n11] = n18;
                            nArray12[n18] = n11;
                            nArray11[n11] = n15 * nArray8[j];
                            continue;
                        }
                        int n20 = n19;
                        nArray11[n20] = nArray11[n20] + n15 * nArray8[j];
                    }
                }
                for (n13 = nArray9[i]; n13 < n11 + 1; ++n13) {
                    nArray12[nArray10[n13]] = -1;
                }
                nArray9[i + 1] = n11 + 1;
            }
        } else {
            if (bl2) {
                intMatrix2D = intMatrix2D.viewDice();
            }
            IntMatrix1D[] intMatrix1DArray = new IntMatrix1D[n4];
            int n21 = n4;
            while (--n21 >= 0) {
                intMatrix1DArray[n21] = intMatrix2D.viewRow(n21);
            }
            IntMatrix1D[] intMatrix1DArray2 = new IntMatrix1D[n3];
            int n22 = n3;
            while (--n22 >= 0) {
                intMatrix1DArray2[n22] = intMatrix2D2.viewRow(n22);
            }
            IntPlusMultSecond intPlusMultSecond = IntPlusMultSecond.plusMult(0);
            int[] nArray = this.columnIndexes;
            int[] nArray13 = this.values;
            int n23 = this.rows;
            while (--n23 >= 0) {
                int n24 = this.rowPointers[n23];
                int n25 = this.rowPointers[n23 + 1];
                while (--n25 >= n24) {
                    int n26 = nArray[n25];
                    intPlusMultSecond.multiplicator = nArray13[n25] * n;
                    if (!bl) {
                        intMatrix1DArray2[n23].assign(intMatrix1DArray[n26], intPlusMultSecond);
                        continue;
                    }
                    intMatrix1DArray2[n26].assign(intMatrix1DArray[n23], intPlusMultSecond);
                }
            }
        }
        return intMatrix2D2;
    }

    private int cumsum(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
            n2 += nArray2[i];
            n3 += nArray2[i];
            nArray2[i] = nArray[i];
        }
        nArray[n] = n2;
        return n3;
    }

    private void realloc(int n) {
        if (n <= 0) {
            n = this.rowPointers[this.rows];
        }
        int[] nArray = new int[n];
        int n2 = Math.min(n, this.columnIndexes.length);
        System.arraycopy(this.columnIndexes, 0, nArray, 0, n2);
        this.columnIndexes = nArray;
        int[] nArray2 = new int[n];
        n2 = Math.min(n, this.values.length);
        System.arraycopy(this.values, 0, nArray2, 0, n2);
        this.values = nArray2;
    }

    protected IntMatrix2D getContent() {
        return this;
    }

    protected void insert(int n, int n2, int n3, int n4) {
        IntArrayList intArrayList = new IntArrayList(this.columnIndexes);
        intArrayList.setSizeRaw(this.rowPointers[this.rows]);
        IntArrayList intArrayList2 = new IntArrayList(this.values);
        intArrayList2.setSizeRaw(this.rowPointers[this.rows]);
        intArrayList.beforeInsert(n3, n2);
        intArrayList2.beforeInsert(n3, n4);
        int n5 = this.rowPointers.length;
        while (--n5 > n) {
            int n6 = n5;
            this.rowPointers[n6] = this.rowPointers[n6] + 1;
        }
        this.columnIndexes = intArrayList.elements();
        this.values = intArrayList2.elements();
    }

    protected void remove(int n, int n2) {
        IntArrayList intArrayList = new IntArrayList(this.columnIndexes);
        intArrayList.setSizeRaw(this.rowPointers[this.rows]);
        IntArrayList intArrayList2 = new IntArrayList(this.values);
        intArrayList2.setSizeRaw(this.rowPointers[this.rows]);
        intArrayList.remove(n2);
        intArrayList2.remove(n2);
        int n3 = this.rowPointers.length;
        while (--n3 > n) {
            int n4 = n3;
            this.rowPointers[n4] = this.rowPointers[n4] - 1;
        }
        this.columnIndexes = intArrayList.elements();
        this.values = intArrayList2.elements();
    }
}

