/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.util.Num;

public abstract class PointSet {
    protected static final int MAXBITS = 31;
    protected int dim = 0;
    protected int numPoints = 0;
    protected int dimShift = 0;
    protected int capacityShift = 0;
    protected RandomStream shiftStream;
    protected List randomizations = new ArrayList();

    public int getDimension() {
        return this.dim;
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public abstract double getCoordinate(int var1, int var2);

    public PointSetIterator iterator() {
        return new DefaultPointSetIterator();
    }

    public void addRandomShift(int n, int n2, RandomStream randomStream) {
        System.out.println("******* WARNING:  addRandomShift in PointSet does nothing");
    }

    public void addRandomShift(RandomStream randomStream) {
        this.addRandomShift(0, this.dimShift, randomStream);
    }

    public void addRandomShift(int n, int n2) {
        this.addRandomShift(n, n2, this.shiftStream);
    }

    public void addRandomShift() {
        this.addRandomShift(0, this.dimShift, this.shiftStream);
    }

    public void clearRandomShift() {
        this.capacityShift = 0;
        this.dimShift = 0;
    }

    public void randomize(int n, int n2, RandomStream randomStream) {
        this.addRandomShift(n, n2, randomStream);
    }

    public void randomize(RandomStream randomStream) {
        this.addRandomShift(randomStream);
    }

    public void randomize(int n, int n2) {
        this.addRandomShift(n, n2);
    }

    public void randomize() {
        this.addRandomShift();
    }

    public void unrandomize() {
        this.clearRandomShift();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Number of points: ");
        int n = this.getNumPoints();
        if (n == Integer.MAX_VALUE) {
            stringBuffer.append("infinite");
        } else {
            stringBuffer.append(n);
        }
        stringBuffer.append("\nPoint set dimension: ");
        n = this.getDimension();
        if (n == Integer.MAX_VALUE) {
            stringBuffer.append("infinite");
        } else {
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }

    public String formatPoints() {
        int n = this.getNumPoints();
        if (n == Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Number of points is infinite");
        }
        int n2 = this.getDimension();
        if (n2 == Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Dimension is infinite");
        }
        return this.formatPoints(n, n2);
    }

    public String formatPoints(int n, int n2) {
        if (this.getNumPoints() < n) {
            throw new UnsupportedOperationException("n > number of points");
        }
        if (this.getDimension() < n2) {
            throw new UnsupportedOperationException("d > dimension");
        }
        StringBuffer stringBuffer = new StringBuffer(this.toString());
        PointSetIterator pointSetIterator = this.iterator();
        stringBuffer.append("\n\nPoints of the point set:");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\nPoint " + pointSetIterator.getCurPointIndex() + "=(");
            boolean bl = true;
            for (int j = 0; j < n2; ++j) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(pointSetIterator.nextCoordinate());
            }
            stringBuffer.append(")");
            pointSetIterator.resetToNextPoint();
        }
        return stringBuffer.toString();
    }

    protected class DefaultPointSetIterator
    implements PointSetIterator {
        protected int curPointIndex = 0;
        protected int curCoordIndex = 0;
        protected double EpsilonHalf = 1.0 / Num.TWOEXP[54];

        protected DefaultPointSetIterator() {
        }

        protected void outOfBounds() {
            if (this.getCurPointIndex() >= PointSet.this.numPoints) {
                throw new NoSuchElementException("Not enough points available");
            }
            throw new NoSuchElementException("Not enough coordinates available");
        }

        public void setCurCoordIndex(int n) {
            this.curCoordIndex = n;
        }

        public void resetCurCoordIndex() {
            this.setCurCoordIndex(0);
        }

        public int getCurCoordIndex() {
            return this.curCoordIndex;
        }

        public boolean hasNextCoordinate() {
            return this.getCurCoordIndex() < PointSet.this.getDimension();
        }

        public double nextCoordinate() {
            if (this.getCurPointIndex() >= PointSet.this.numPoints || this.getCurCoordIndex() >= PointSet.this.dim) {
                this.outOfBounds();
            }
            return PointSet.this.getCoordinate(this.curPointIndex, this.curCoordIndex++);
        }

        public void nextCoordinates(double[] dArray, int n) {
            if (this.getCurCoordIndex() + n > PointSet.this.getDimension()) {
                this.outOfBounds();
            }
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.nextCoordinate();
            }
        }

        public void setCurPointIndex(int n) {
            this.curPointIndex = n;
            this.resetCurCoordIndex();
        }

        public void resetCurPointIndex() {
            this.setCurPointIndex(0);
        }

        public int resetToNextPoint() {
            this.setCurPointIndex(this.curPointIndex + 1);
            return this.curPointIndex;
        }

        public int getCurPointIndex() {
            return this.curPointIndex;
        }

        public boolean hasNextPoint() {
            return this.getCurPointIndex() < PointSet.this.getNumPoints();
        }

        public int nextPoint(double[] dArray, int n) {
            this.resetCurCoordIndex();
            this.nextCoordinates(dArray, n);
            return this.resetToNextPoint();
        }

        public void resetStartStream() {
            this.resetCurPointIndex();
        }

        public void resetStartSubstream() {
            this.resetCurCoordIndex();
        }

        public void resetNextSubstream() {
            this.resetToNextPoint();
        }

        public void setAntithetic(boolean bl) {
            throw new UnsupportedOperationException();
        }

        public double nextDouble() {
            return this.nextCoordinate();
        }

        public void nextArrayOfDouble(double[] dArray, int n, int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("n must be positive.");
            }
            for (int i = n; i < n + n2; ++i) {
                dArray[i] = this.nextDouble();
            }
        }

        public int nextInt(int n, int n2) {
            return n + (int)(this.nextDouble() * ((double)(n2 - n) + 1.0));
        }

        public void nextArrayOfInt(int n, int n2, int[] nArray, int n3, int n4) {
            if (n4 < 0) {
                throw new IllegalArgumentException("n must be positive.");
            }
            for (int i = n3; i < n3 + n4; ++i) {
                nArray[i] = this.nextInt(n, n2);
            }
        }

        public String formatState() {
            return "Current point index: " + this.getCurPointIndex() + "\nCurrent coordinate index: " + this.getCurCoordIndex();
        }
    }
}

