/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.h2.constant.SysProperties;
import org.h2.engine.Constants;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcClob;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.store.LobStorageFrontend;
import org.h2.tools.SimpleResultSet;
import org.h2.util.New;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public class DataType {
    public static final int TYPE_RESULT_SET = -10;
    public static final Class<?> GEOMETRY_CLASS;
    private static final String GEOMETRY_CLASS_NAME = "com.vividsolutions.jts.geom.Geometry";
    private static final ArrayList<DataType> TYPES;
    private static final HashMap<String, DataType> TYPES_BY_NAME;
    private static final ArrayList<DataType> TYPES_BY_VALUE_TYPE;
    public int type;
    public String name;
    public int sqlType;
    public String jdbc;
    public int sqlTypePos;
    public long maxPrecision;
    public int minScale;
    public int maxScale;
    public boolean decimal;
    public String prefix;
    public String suffix;
    public String params;
    public boolean autoIncrement;
    public boolean caseSensitive;
    public boolean supportsPrecision;
    public boolean supportsScale;
    public long defaultPrecision;
    public int defaultScale;
    public int defaultDisplaySize;
    public boolean hidden;
    public int memory;

    private static void add(int n, int n2, String string, DataType dataType, String[] stringArray, int n3) {
        for (int i = 0; i < stringArray.length; ++i) {
            DataType dataType2 = new DataType();
            dataType2.type = n;
            dataType2.sqlType = n2;
            dataType2.jdbc = string;
            dataType2.name = stringArray[i];
            dataType2.autoIncrement = dataType.autoIncrement;
            dataType2.decimal = dataType.decimal;
            dataType2.maxPrecision = dataType.maxPrecision;
            dataType2.maxScale = dataType.maxScale;
            dataType2.minScale = dataType.minScale;
            dataType2.params = dataType.params;
            dataType2.prefix = dataType.prefix;
            dataType2.suffix = dataType.suffix;
            dataType2.supportsPrecision = dataType.supportsPrecision;
            dataType2.supportsScale = dataType.supportsScale;
            dataType2.defaultPrecision = dataType.defaultPrecision;
            dataType2.defaultScale = dataType.defaultScale;
            dataType2.defaultDisplaySize = dataType.defaultDisplaySize;
            dataType2.caseSensitive = dataType.caseSensitive;
            dataType2.hidden = i > 0;
            dataType2.memory = n3;
            for (DataType dataType3 : TYPES) {
                if (dataType3.sqlType != dataType2.sqlType) continue;
                ++dataType2.sqlTypePos;
            }
            TYPES_BY_NAME.put(dataType2.name, dataType2);
            if (TYPES_BY_VALUE_TYPE.get(n) == null) {
                TYPES_BY_VALUE_TYPE.set(n, dataType2);
            }
            TYPES.add(dataType2);
        }
    }

    private static DataType createDecimal(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        DataType dataType = new DataType();
        dataType.maxPrecision = n;
        dataType.defaultPrecision = n2;
        dataType.defaultScale = n3;
        dataType.defaultDisplaySize = n4;
        if (bl) {
            dataType.params = "PRECISION,SCALE";
            dataType.supportsPrecision = true;
            dataType.supportsScale = true;
        }
        dataType.decimal = true;
        dataType.autoIncrement = bl2;
        return dataType;
    }

    private static DataType createDate(int n, String string, int n2, int n3) {
        DataType dataType = new DataType();
        dataType.prefix = string + " '";
        dataType.suffix = "'";
        dataType.maxPrecision = n;
        dataType.supportsScale = n2 != 0;
        dataType.maxScale = n2;
        dataType.defaultPrecision = n;
        dataType.defaultScale = n2;
        dataType.defaultDisplaySize = n3;
        return dataType;
    }

    private static DataType createString(boolean bl) {
        DataType dataType = new DataType();
        dataType.prefix = "'";
        dataType.suffix = "'";
        dataType.params = "LENGTH";
        dataType.caseSensitive = bl;
        dataType.supportsPrecision = true;
        dataType.maxPrecision = Integer.MAX_VALUE;
        dataType.defaultPrecision = Integer.MAX_VALUE;
        dataType.defaultDisplaySize = Integer.MAX_VALUE;
        return dataType;
    }

    private static DataType createLob() {
        DataType dataType = DataType.createString(true);
        dataType.maxPrecision = Long.MAX_VALUE;
        dataType.defaultPrecision = Long.MAX_VALUE;
        return dataType;
    }

    public static ArrayList<DataType> getTypes() {
        return TYPES;
    }

    public static Value readValue(SessionInterface sessionInterface, ResultSet resultSet, int n, int n2) {
        try {
            Value value;
            switch (n2) {
                case 0: {
                    return ValueNull.INSTANCE;
                }
                case 12: {
                    byte[] byArray = resultSet.getBytes(n);
                    value = byArray == null ? ValueNull.INSTANCE : ValueBytes.getNoCopy(byArray);
                    break;
                }
                case 20: {
                    byte[] byArray = resultSet.getBytes(n);
                    value = byArray == null ? ValueNull.INSTANCE : ValueUuid.get(byArray);
                    break;
                }
                case 1: {
                    boolean bl = resultSet.getBoolean(n);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueBoolean.get(bl);
                    break;
                }
                case 2: {
                    byte by = resultSet.getByte(n);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueByte.get(by);
                    break;
                }
                case 10: {
                    Date date = resultSet.getDate(n);
                    value = date == null ? ValueNull.INSTANCE : ValueDate.get(date);
                    break;
                }
                case 9: {
                    Time time = resultSet.getTime(n);
                    value = time == null ? ValueNull.INSTANCE : ValueTime.get(time);
                    break;
                }
                case 11: {
                    Timestamp timestamp = resultSet.getTimestamp(n);
                    value = timestamp == null ? ValueNull.INSTANCE : ValueTimestamp.get(timestamp);
                    break;
                }
                case 6: {
                    BigDecimal bigDecimal = resultSet.getBigDecimal(n);
                    value = bigDecimal == null ? ValueNull.INSTANCE : ValueDecimal.get(bigDecimal);
                    break;
                }
                case 7: {
                    double d = resultSet.getDouble(n);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueDouble.get(d);
                    break;
                }
                case 8: {
                    float f = resultSet.getFloat(n);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueFloat.get(f);
                    break;
                }
                case 4: {
                    int n3 = resultSet.getInt(n);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueInt.get(n3);
                    break;
                }
                case 5: {
                    long l = resultSet.getLong(n);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueLong.get(l);
                    break;
                }
                case 3: {
                    short s = resultSet.getShort(n);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueShort.get(s);
                    break;
                }
                case 14: {
                    String string = resultSet.getString(n);
                    value = string == null ? ValueNull.INSTANCE : ValueStringIgnoreCase.get(string);
                    break;
                }
                case 21: {
                    String string = resultSet.getString(n);
                    value = string == null ? ValueNull.INSTANCE : ValueStringFixed.get(string);
                    break;
                }
                case 13: {
                    String string = resultSet.getString(n);
                    value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
                    break;
                }
                case 16: {
                    if (sessionInterface == null) {
                        value = LobStorageFrontend.createSmallLob(16, resultSet.getString(n).getBytes(Constants.UTF8));
                        break;
                    }
                    Reader reader = resultSet.getCharacterStream(n);
                    if (reader == null) {
                        value = ValueNull.INSTANCE;
                        break;
                    }
                    value = sessionInterface.getDataHandler().getLobStorage().createClob(new BufferedReader(reader), -1L);
                    break;
                }
                case 15: {
                    if (sessionInterface == null) {
                        value = LobStorageFrontend.createSmallLob(15, resultSet.getBytes(n));
                        break;
                    }
                    InputStream inputStream = resultSet.getBinaryStream(n);
                    value = inputStream == null ? ValueNull.INSTANCE : sessionInterface.getDataHandler().getLobStorage().createBlob(inputStream, -1L);
                    break;
                }
                case 19: {
                    if (SysProperties.serializeJavaObject) {
                        byte[] byArray = resultSet.getBytes(n);
                        value = byArray == null ? ValueNull.INSTANCE : ValueJavaObject.getNoCopy(null, byArray, sessionInterface.getDataHandler());
                        break;
                    }
                    Object object = resultSet.getObject(n);
                    value = object == null ? ValueNull.INSTANCE : ValueJavaObject.getNoCopy(object, null, sessionInterface.getDataHandler());
                    break;
                }
                case 17: {
                    Array array = resultSet.getArray(n);
                    if (array == null) {
                        return ValueNull.INSTANCE;
                    }
                    Object[] objectArray = (Object[])array.getArray();
                    if (objectArray == null) {
                        return ValueNull.INSTANCE;
                    }
                    int n4 = objectArray.length;
                    Value[] valueArray = new Value[n4];
                    for (int i = 0; i < n4; ++i) {
                        valueArray[i] = DataType.convertToValue(sessionInterface, objectArray[i], 0);
                    }
                    value = ValueArray.get(valueArray);
                    break;
                }
                case 18: {
                    ResultSet resultSet2 = (ResultSet)resultSet.getObject(n);
                    if (resultSet2 == null) {
                        return ValueNull.INSTANCE;
                    }
                    return ValueResultSet.get(resultSet);
                }
                case 22: {
                    Object object = resultSet.getObject(n);
                    if (object == null) {
                        return ValueNull.INSTANCE;
                    }
                    return ValueGeometry.getFromGeometry(object);
                }
                default: {
                    throw DbException.throwInternalError("type=" + n2);
                }
            }
            return value;
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    public static String getTypeClassName(int n) {
        switch (n) {
            case 1: {
                return Boolean.class.getName();
            }
            case 2: {
                return Byte.class.getName();
            }
            case 3: {
                return Short.class.getName();
            }
            case 4: {
                return Integer.class.getName();
            }
            case 5: {
                return Long.class.getName();
            }
            case 6: {
                return BigDecimal.class.getName();
            }
            case 9: {
                return Time.class.getName();
            }
            case 10: {
                return Date.class.getName();
            }
            case 11: {
                return Timestamp.class.getName();
            }
            case 12: 
            case 20: {
                return byte[].class.getName();
            }
            case 13: 
            case 14: 
            case 21: {
                return String.class.getName();
            }
            case 15: {
                return Blob.class.getName();
            }
            case 16: {
                return Clob.class.getName();
            }
            case 7: {
                return Double.class.getName();
            }
            case 8: {
                return Float.class.getName();
            }
            case 0: {
                return null;
            }
            case 19: {
                return Object.class.getName();
            }
            case -1: {
                return Object.class.getName();
            }
            case 17: {
                return Array.class.getName();
            }
            case 18: {
                return ResultSet.class.getName();
            }
            case 22: {
                return GEOMETRY_CLASS_NAME;
            }
        }
        throw DbException.throwInternalError("type=" + n);
    }

    public static DataType getDataType(int n) {
        if (n == -1) {
            throw DbException.get(50004, "?");
        }
        DataType dataType = TYPES_BY_VALUE_TYPE.get(n);
        if (dataType == null) {
            dataType = TYPES_BY_VALUE_TYPE.get(0);
        }
        return dataType;
    }

    public static int convertTypeToSQLType(int n) {
        return DataType.getDataType((int)n).sqlType;
    }

    private static int convertSQLTypeToValueType(int n, String string) {
        switch (n) {
            case 1111: 
            case 2000: {
                if (!string.equalsIgnoreCase("geometry")) break;
                return 22;
            }
        }
        return DataType.convertSQLTypeToValueType(n);
    }

    public static int getValueTypeFromResultSet(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        return DataType.convertSQLTypeToValueType(resultSetMetaData.getColumnType(n), resultSetMetaData.getColumnTypeName(n));
    }

    public static int convertSQLTypeToValueType(int n) {
        switch (n) {
            case -15: 
            case 1: {
                return 21;
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                return 13;
            }
            case 2: 
            case 3: {
                return 6;
            }
            case -7: 
            case 16: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 3;
            }
            case -6: {
                return 2;
            }
            case -5: {
                return 5;
            }
            case 7: {
                return 8;
            }
            case 6: 
            case 8: {
                return 7;
            }
            case -4: 
            case -3: 
            case -2: {
                return 12;
            }
            case 1111: 
            case 2000: {
                return 19;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 9;
            }
            case 93: {
                return 11;
            }
            case 2004: {
                return 15;
            }
            case 2005: 
            case 2011: {
                return 16;
            }
            case 0: {
                return 0;
            }
            case 2003: {
                return 17;
            }
            case -10: {
                return 18;
            }
        }
        throw DbException.get(50004, "" + n);
    }

    public static int getTypeFromClass(Class<?> clazz) {
        if (clazz == null || Void.TYPE == clazz) {
            return 0;
        }
        if (clazz.isPrimitive()) {
            clazz = Utils.getNonPrimitiveClass(clazz);
        }
        if (String.class == clazz) {
            return 13;
        }
        if (Integer.class == clazz) {
            return 4;
        }
        if (Long.class == clazz) {
            return 5;
        }
        if (Boolean.class == clazz) {
            return 1;
        }
        if (Double.class == clazz) {
            return 7;
        }
        if (Byte.class == clazz) {
            return 2;
        }
        if (Short.class == clazz) {
            return 3;
        }
        if (Character.class == clazz) {
            throw DbException.get(22018, "char (not supported)");
        }
        if (Float.class == clazz) {
            return 8;
        }
        if (byte[].class == clazz) {
            return 12;
        }
        if (UUID.class == clazz) {
            return 20;
        }
        if (Void.class == clazz) {
            return 0;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return 6;
        }
        if (ResultSet.class.isAssignableFrom(clazz)) {
            return 18;
        }
        if (Value.ValueBlob.class.isAssignableFrom(clazz)) {
            return 15;
        }
        if (Value.ValueClob.class.isAssignableFrom(clazz)) {
            return 16;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return 10;
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return 9;
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return 11;
        }
        if (java.util.Date.class.isAssignableFrom(clazz)) {
            return 11;
        }
        if (Reader.class.isAssignableFrom(clazz)) {
            return 16;
        }
        if (Clob.class.isAssignableFrom(clazz)) {
            return 16;
        }
        if (InputStream.class.isAssignableFrom(clazz)) {
            return 15;
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            return 15;
        }
        if (Object[].class.isAssignableFrom(clazz)) {
            return 17;
        }
        if (DataType.isGeometryClass(clazz)) {
            return 22;
        }
        return 19;
    }

    public static Value convertToValue(SessionInterface sessionInterface, Object object, int n) {
        if (object == null) {
            return ValueNull.INSTANCE;
        }
        if (n == 19) {
            return ValueJavaObject.getNoCopy(object, null, sessionInterface.getDataHandler());
        }
        if (object instanceof String) {
            return ValueString.get((String)object);
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof Long) {
            return ValueLong.get((Long)object);
        }
        if (object instanceof Integer) {
            return ValueInt.get((Integer)object);
        }
        if (object instanceof BigDecimal) {
            return ValueDecimal.get((BigDecimal)object);
        }
        if (object instanceof Boolean) {
            return ValueBoolean.get((Boolean)object);
        }
        if (object instanceof Byte) {
            return ValueByte.get((Byte)object);
        }
        if (object instanceof Short) {
            return ValueShort.get((Short)object);
        }
        if (object instanceof Float) {
            return ValueFloat.get(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return ValueDouble.get((Double)object);
        }
        if (object instanceof byte[]) {
            return ValueBytes.get((byte[])object);
        }
        if (object instanceof Date) {
            return ValueDate.get((Date)object);
        }
        if (object instanceof Time) {
            return ValueTime.get((Time)object);
        }
        if (object instanceof Timestamp) {
            return ValueTimestamp.get((Timestamp)object);
        }
        if (object instanceof java.util.Date) {
            return ValueTimestamp.get(new Timestamp(((java.util.Date)object).getTime()));
        }
        if (object instanceof Reader) {
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            return sessionInterface.getDataHandler().getLobStorage().createClob(bufferedReader, -1L);
        }
        if (object instanceof Clob) {
            try {
                BufferedReader bufferedReader = new BufferedReader(((Clob)object).getCharacterStream());
                return sessionInterface.getDataHandler().getLobStorage().createClob(bufferedReader, -1L);
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
        if (object instanceof InputStream) {
            return sessionInterface.getDataHandler().getLobStorage().createBlob((InputStream)object, -1L);
        }
        if (object instanceof Blob) {
            try {
                return sessionInterface.getDataHandler().getLobStorage().createBlob(((Blob)object).getBinaryStream(), -1L);
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
        if (object instanceof ResultSet) {
            if (object instanceof SimpleResultSet) {
                return ValueResultSet.get((ResultSet)object);
            }
            return ValueResultSet.getCopy((ResultSet)object, Integer.MAX_VALUE);
        }
        if (object instanceof UUID) {
            UUID uUID = (UUID)object;
            return ValueUuid.get(uUID.getMostSignificantBits(), uUID.getLeastSignificantBits());
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n2 = objectArray.length;
            Value[] valueArray = new Value[n2];
            for (int i = 0; i < n2; ++i) {
                valueArray[i] = DataType.convertToValue(sessionInterface, objectArray[i], n);
            }
            return ValueArray.get(object.getClass().getComponentType(), valueArray);
        }
        if (object instanceof Character) {
            return ValueStringFixed.get(((Character)object).toString());
        }
        if (DataType.isGeometry(object)) {
            return ValueGeometry.getFromGeometry(object);
        }
        return ValueJavaObject.getNoCopy(object, null, sessionInterface.getDataHandler());
    }

    public static boolean isGeometryClass(Class<?> clazz) {
        if (clazz == null || GEOMETRY_CLASS == null) {
            return false;
        }
        return GEOMETRY_CLASS.isAssignableFrom(clazz);
    }

    public static boolean isGeometry(Object object) {
        if (object == null) {
            return false;
        }
        return DataType.isGeometryClass(object.getClass());
    }

    public static DataType getTypeByName(String string) {
        return TYPES_BY_NAME.get(string);
    }

    public static boolean isLargeObject(int n) {
        return n == 15 || n == 16;
    }

    public static boolean isStringType(int n) {
        return n == 13 || n == 21 || n == 14;
    }

    public static boolean supportsAdd(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static int getAddProofType(int n) {
        switch (n) {
            case 2: {
                return 5;
            }
            case 8: {
                return 7;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 3: {
                return 5;
            }
        }
        return n;
    }

    public static Object getDefaultForPrimitiveType(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        throw DbException.throwInternalError("primitive=" + clazz.toString());
    }

    public static Object convertTo(JdbcConnection jdbcConnection, Value value, Class<?> clazz) {
        if (clazz == Blob.class) {
            return new JdbcBlob(jdbcConnection, value, 0);
        }
        if (clazz == Clob.class) {
            return new JdbcClob(jdbcConnection, value, 0);
        }
        if (value.getType() == 19) {
            Object object;
            Object object2 = object = SysProperties.serializeJavaObject ? Utils.deserialize(value.getBytes(), jdbcConnection.getSession().getDataHandler()) : value.getObject();
            if (clazz.isAssignableFrom(object.getClass())) {
                return object;
            }
        }
        throw DbException.getUnsupportedException(clazz.getName());
    }

    static {
        Class<?> clazz;
        TYPES = New.arrayList();
        TYPES_BY_NAME = New.hashMap();
        TYPES_BY_VALUE_TYPE = New.arrayList();
        try {
            clazz = Utils.loadUserClass(GEOMETRY_CLASS_NAME);
        }
        catch (Exception exception) {
            clazz = null;
        }
        GEOMETRY_CLASS = clazz;
        for (int i = 0; i < 23; ++i) {
            TYPES_BY_VALUE_TYPE.add(null);
        }
        DataType.add(0, 0, "Null", new DataType(), new String[]{"NULL"}, 0);
        DataType.add(13, 12, "String", DataType.createString(true), new String[]{"VARCHAR", "VARCHAR2", "NVARCHAR", "NVARCHAR2", "VARCHAR_CASESENSITIVE", "CHARACTER VARYING", "TID"}, 48);
        DataType.add(13, -1, "String", DataType.createString(true), new String[]{"LONGVARCHAR", "LONGNVARCHAR"}, 48);
        DataType.add(21, 1, "String", DataType.createString(true), new String[]{"CHAR", "CHARACTER", "NCHAR"}, 48);
        DataType.add(14, 12, "String", DataType.createString(false), new String[]{"VARCHAR_IGNORECASE"}, 48);
        DataType.add(1, 16, "Boolean", DataType.createDecimal(1, 1, 0, 5, false, false), new String[]{"BOOLEAN", "BIT", "BOOL"}, 0);
        DataType.add(2, -6, "Byte", DataType.createDecimal(3, 3, 0, 4, false, false), new String[]{"TINYINT"}, 1);
        DataType.add(3, 5, "Short", DataType.createDecimal(5, 5, 0, 6, false, false), new String[]{"SMALLINT", "YEAR", "INT2"}, 20);
        DataType.add(4, 4, "Int", DataType.createDecimal(10, 10, 0, 11, false, false), new String[]{"INTEGER", "INT", "MEDIUMINT", "INT4", "SIGNED"}, 20);
        DataType.add(4, 4, "Int", DataType.createDecimal(10, 10, 0, 11, false, true), new String[]{"SERIAL"}, 20);
        DataType.add(5, -5, "Long", DataType.createDecimal(19, 19, 0, 20, false, false), new String[]{"BIGINT", "INT8", "LONG"}, 24);
        DataType.add(5, -5, "Long", DataType.createDecimal(19, 19, 0, 20, false, true), new String[]{"IDENTITY", "BIGSERIAL"}, 24);
        DataType.add(6, 3, "BigDecimal", DataType.createDecimal(Integer.MAX_VALUE, 65535, Short.MAX_VALUE, 65535, true, false), new String[]{"DECIMAL", "DEC"}, 64);
        DataType.add(6, 2, "BigDecimal", DataType.createDecimal(Integer.MAX_VALUE, 65535, Short.MAX_VALUE, 65535, true, false), new String[]{"NUMERIC", "NUMBER"}, 64);
        DataType.add(8, 7, "Float", DataType.createDecimal(7, 7, 0, 15, false, false), new String[]{"REAL", "FLOAT4"}, 24);
        DataType.add(7, 8, "Double", DataType.createDecimal(17, 17, 0, 24, false, false), new String[]{"DOUBLE", "DOUBLE PRECISION"}, 24);
        DataType.add(7, 6, "Double", DataType.createDecimal(17, 17, 0, 24, false, false), new String[]{"FLOAT", "FLOAT8"}, 24);
        DataType.add(9, 92, "Time", DataType.createDate(6, "TIME", 0, 8), new String[]{"TIME"}, 56);
        DataType.add(10, 91, "Date", DataType.createDate(8, "DATE", 0, 10), new String[]{"DATE"}, 56);
        DataType.add(11, 93, "Timestamp", DataType.createDate(23, "TIMESTAMP", 10, 23), new String[]{"TIMESTAMP", "DATETIME", "SMALLDATETIME"}, 56);
        DataType.add(12, -3, "Bytes", DataType.createString(false), new String[]{"VARBINARY"}, 32);
        DataType.add(12, -2, "Bytes", DataType.createString(false), new String[]{"BINARY", "RAW", "BYTEA", "LONG RAW"}, 32);
        DataType.add(12, -4, "Bytes", DataType.createString(false), new String[]{"LONGVARBINARY"}, 32);
        DataType.add(20, -2, "Bytes", DataType.createString(false), new String[]{"UUID"}, 32);
        DataType.add(19, 1111, "Object", DataType.createString(false), new String[]{"OTHER", "OBJECT", "JAVA_OBJECT"}, 24);
        DataType.add(15, 2004, "Blob", DataType.createLob(), new String[]{"BLOB", "TINYBLOB", "MEDIUMBLOB", "LONGBLOB", "IMAGE", "OID"}, 104);
        DataType.add(16, 2005, "Clob", DataType.createLob(), new String[]{"CLOB", "TINYTEXT", "TEXT", "MEDIUMTEXT", "LONGTEXT", "NTEXT", "NCLOB"}, 104);
        DataType.add(22, 1111, "Geometry", DataType.createString(false), new String[]{"GEOMETRY"}, 32);
        DataType dataType = new DataType();
        dataType.prefix = "(";
        dataType.suffix = "')";
        DataType.add(17, 2003, "Array", dataType, new String[]{"ARRAY"}, 32);
        dataType = new DataType();
        DataType.add(18, -10, "ResultSet", dataType, new String[]{"RESULT_SET"}, 400);
        int n = TYPES_BY_VALUE_TYPE.size();
        for (int i = 0; i < n; ++i) {
            DataType dataType2 = TYPES_BY_VALUE_TYPE.get(i);
            if (dataType2 == null) {
                DbException.throwInternalError("unmapped type " + i);
            }
            Value.getOrder(i);
        }
    }
}

