/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.BaseException;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.maths.matrices.IVectorTransformation;
import ec.tstoolkit.maths.matrices.SubMatrix;

public class HyperbolicHouseholderReflection
implements IVectorTransformation {
    private final int pos_;
    private double beta_;
    private double mu_;
    private DataBlock v_;

    private HyperbolicHouseholderReflection(int pos) {
        this.pos_ = pos;
    }

    public static HyperbolicHouseholderReflection from(DataBlock v, int pos) {
        HyperbolicHouseholderReflection reflection = new HyperbolicHouseholderReflection(pos);
        reflection.householder(v);
        return reflection;
    }

    public static HyperbolicHouseholderReflection inPlace(DataBlock v, int pos) {
        HyperbolicHouseholderReflection reflection = new HyperbolicHouseholderReflection(pos);
        reflection.v_ = v.clone();
        reflection.inPlaceHouseholder();
        return reflection;
    }

    public DataBlock getHouseholderVector() {
        return this.v_;
    }

    public double getNrm2() {
        return this.mu_;
    }

    public double getBeta() {
        return this.beta_;
    }

    private void householder(DataBlock x) {
        int n = x.getLength();
        if (n == 1) {
            x.set(0, Math.abs(x.get(0)));
            return;
        }
        this.v_ = x.deepClone();
        this.inPlaceHouseholder();
        x.set(0.0);
        x.set(0, this.mu_);
    }

    private void inPlaceHouseholder() {
        int i;
        int n = this.v_.getLength();
        if (n == 1) {
            return;
        }
        double[] v = this.v_.getData();
        int beg = this.v_.getStartPosition();
        int end = this.v_.getEndPosition();
        int inc = this.v_.getIncrement();
        int pend = beg + inc * this.pos_;
        double sigp = 0.0;
        double sign = 0.0;
        for (i = beg + inc; i != pend; i += inc) {
            sigp += v[i] * v[i];
        }
        for (i = pend; i != end; i += inc) {
            sign += v[i] * v[i];
        }
        if (sigp < 1.0E-17 && sign < 1.0E-17) {
            return;
        }
        double x0 = v[beg];
        double sig = x0 * x0 + sigp - sign;
        this.mu_ = Math.sqrt(sig);
        double v0 = x0 <= 0.0 ? x0 - this.mu_ : -sig / (x0 + this.mu_);
        this.beta_ = 2.0 / (sig + v0 * v0);
        v[beg] = v0;
    }

    @Override
    public void transform(DataBlock y) {
        if (this.beta_ == 0.0) {
            return;
        }
        double vy = y.jdot(this.pos_, this.v_);
        y.addAY(-this.beta_ * vy, this.v_);
    }

    public static boolean triangularize(SubMatrix M, int npos) {
        try {
            int r = M.getRowsCount();
            int c = M.getColumnsCount();
            SubMatrix L = M;
            do {
                HyperbolicHouseholderReflection.reflection(L.rows(), npos--);
            } while (!(L = L.extract(1, r--, 1, c--)).isEmpty());
            return true;
        }
        catch (BaseException err) {
            return false;
        }
    }

    public static void reflection(DataBlockIterator vectors, int npos) {
        DataBlock cur = vectors.getData();
        HyperbolicHouseholderReflection reflection = HyperbolicHouseholderReflection.from(cur, npos);
        while (vectors.next()) {
            reflection.transform(cur);
        }
    }
}

