/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.util;

import it.bancaditalia.oss.sdmx.util.LoginDialog;
import it.bancaditalia.oss.sdmx.util.SdmxLogHandler;
import it.bancaditalia.oss.sdmx.util.SdmxProxySelector;
import it.bancaditalia.oss.sdmx.util.SimpleProxySelector;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import javax.swing.JFrame;

public class Configuration {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final String SDMX_CODES_POLICY_ID = "code";
    public static final String SDMX_CODES_POLICY_DESC = "description";
    public static final String SDMX_CODES_POLICY_BOTH = "both";
    public static final String SDMX_CODES_POLICY_ATTRIBUTES = "attributes";
    protected static final String PROXY_AUTH_KERBEROS = "Kerberos";
    protected static final String PROXY_AUTH_DIGEST = "digest";
    protected static final String PROXY_AUTH_BASIC = "basic";
    protected static final String JAVA_SECURITY_KERBEROS_PROP = "java.security.krb5.conf";
    protected static final String JAVA_SECURITY_AUTH_LOGIN_CONFIG_PROP = "java.security.auth.login.config";
    protected static final String HTTP_AUTH_PREF_PROP = "http.auth.preference";
    protected static final String SSL_DISABLE_CERT_CHECK_PROP = "ssl.disable.cert.check";
    protected static final String SSL_TRUSTSTORE_PROP = "javax.net.ssl.trustStore";
    protected static final String GLOBAL_CONFIGURATION_FILE_PROP = "SDMX_CONF";
    protected static final String EXTERNAL_PROVIDERS_PROP = "external.providers";
    protected static final String PROXY_NAME_PROP = "http.proxy.name";
    protected static final String PROXY_DEFAULT_PROP = "http.proxy.default";
    protected static final String HTTP_AUTH_USER_PROP = "http.auth.user";
    protected static final String PROXY_AUTH_PW_PROP = "http.auth.pw";
    protected static final String REVERSE_DUMP_PROP = "reverse.dump";
    protected static final String SDMX_LANG_PROP = "sdmx.lang";
    protected static final String LATE_RESP_RETRIES_PROP = "late.response.retries";
    protected static final String TABLE_DUMP_PROP = "table.dump";
    protected static final String READ_TIMEOUT_PROP = "read.timeout";
    protected static final String CONNECT_TIMEOUT_PROP = "connect.timeout";
    protected static final Logger SDMX_LOGGER = Logger.getLogger("SDMX");
    protected static List<Locale.LanguageRange> SDMX_LANG = Locale.LanguageRange.parse("en");
    private static final String UIS_API_KEY_PROP = "uis.api.key";
    private static final String SDMX_CODES_POLICY = "handle.sdmx.codes";
    private static final String REVERSE_DUMP_DEFAULT = "FALSE";
    private static final String TABLE_DUMP_DEFAULT = "FALSE";
    private static final String SDMX_DEFAULT_LANG = "en";
    private static final String SDMX_DEFAULT_TIMEOUT = "0";
    private static final String DUMP_XML_PREFIX = "xml.dump.prefix";
    private static final String sourceClass = Configuration.class.getSimpleName();
    private static final String CONFIGURATION_FILE_NAME = "configuration.properties";
    private static Properties props = new Properties();
    private static boolean inited = false;
    private static Subject subject;

    protected static void setSdmxLogger() {
        if (SDMX_LOGGER != null) {
            Configuration.getSdmxLogger();
        }
        LinkedList<Handler> linkedList = new LinkedList<Handler>();
        Logger logger = SDMX_LOGGER;
        while (logger != null) {
            linkedList.addAll(Arrays.asList(logger.getHandlers()));
            logger = logger.getUseParentHandlers() ? logger.getParent() : null;
        }
        if (linkedList.size() == 0) {
            SdmxLogHandler sdmxLogHandler = new SdmxLogHandler();
            ((Handler)sdmxLogHandler).setLevel(Level.INFO);
            SDMX_LOGGER.addHandler(sdmxLogHandler);
        } else if (linkedList.size() == 1 && linkedList.get(0) instanceof ConsoleHandler && ((Handler)linkedList.get(0)).getFormatter() instanceof SimpleFormatter) {
            logger = SDMX_LOGGER;
            while (logger != null) {
                if (logger.getHandlers().length == 1) {
                    Handler handler = logger.getHandlers()[0];
                    Level level = handler.getLevel();
                    logger.removeHandler(handler);
                    handler = new SdmxLogHandler();
                    handler.setLevel(level);
                    logger.addHandler(handler);
                    break;
                }
                logger = logger.getUseParentHandlers() ? logger.getParent() : null;
            }
        }
    }

    public static Logger getSdmxLogger() {
        return SDMX_LOGGER;
    }

    public static Properties getConfiguration() {
        return props;
    }

    public static boolean isReverse() {
        return props.getProperty(REVERSE_DUMP_PROP, "FALSE").equalsIgnoreCase("TRUE");
    }

    public static boolean isTable() {
        return props.getProperty(TABLE_DUMP_PROP, "FALSE").equalsIgnoreCase("TRUE");
    }

    public static String getExternalProviders() {
        return props.getProperty(EXTERNAL_PROVIDERS_PROP);
    }

    public static int getReadTimeout(String string) {
        String string2 = props.getProperty(string + "." + READ_TIMEOUT_PROP, null);
        if (string2 == null) {
            string2 = props.getProperty(READ_TIMEOUT_PROP, SDMX_DEFAULT_TIMEOUT);
        }
        return Integer.parseInt(string2);
    }

    public static int getConnectTimeout(String string) {
        String string2 = props.getProperty(string + "." + CONNECT_TIMEOUT_PROP, null);
        if (string2 == null) {
            string2 = props.getProperty(CONNECT_TIMEOUT_PROP, SDMX_DEFAULT_TIMEOUT);
        }
        return Integer.parseInt(string2);
    }

    public static String getCodesPolicy() {
        String string = props.getProperty(SDMX_CODES_POLICY, SDMX_CODES_POLICY_ID);
        if (!(string.equalsIgnoreCase(SDMX_CODES_POLICY_ID) || string.equalsIgnoreCase(SDMX_CODES_POLICY_DESC) || string.equalsIgnoreCase(SDMX_CODES_POLICY_BOTH))) {
            SDMX_LOGGER.warning("The value " + string + "for the key " + SDMX_CODES_POLICY + " is not valid. Using default.");
            string = SDMX_CODES_POLICY_ID;
        }
        return string;
    }

    public static List<Locale.LanguageRange> getLanguages() {
        Configuration.init();
        return SDMX_LANG;
    }

    public static String getLateResponseRetries(int n) {
        return props.getProperty(LATE_RESP_RETRIES_PROP, Integer.toString(n));
    }

    public static void setLanguages(String string) {
        SDMX_LANG = Locale.LanguageRange.parse(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Object object = Configuration.class;
        synchronized (Configuration.class) {
            File file;
            if (inited) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            inited = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            Configuration.setSdmxLogger();
            object = null;
            String string = System.getProperty(GLOBAL_CONFIGURATION_FILE_PROP);
            if (string != null && !string.isEmpty()) {
                file = new File(string);
                if (!file.exists()) {
                    string = CONFIGURATION_FILE_NAME;
                    System.err.println("Configuration file set by System property: " + string + " not found. Trying default config file.");
                }
            } else {
                string = CONFIGURATION_FILE_NAME;
            }
            String string2 = System.getenv(GLOBAL_CONFIGURATION_FILE_PROP);
            file = new File(string);
            if (file.exists()) {
                try {
                    Configuration.init(file);
                    object = System.getProperty("user.dir") + File.separator + string;
                    SDMX_LOGGER.info("Local configuration file found: " + (String)object);
                }
                catch (IOException | SecurityException exception) {
                    exception.printStackTrace();
                    SDMX_LOGGER.finer(Configuration.logException(exception));
                }
            } else if (string2 != null && !string2.isEmpty() && (file = new File(string2)).exists()) {
                try {
                    Configuration.init(file);
                    object = string2;
                    SDMX_LOGGER.info("Global configuration file found: " + (String)object);
                }
                catch (IOException | SecurityException exception) {
                    exception.printStackTrace();
                    SDMX_LOGGER.finer(Configuration.logException(exception));
                }
            } else if (object == null) {
                try {
                    Class<?> clazz = Class.forName("it.bancaditalia.oss.sdmx.util.SdmxConfiguration");
                    Method method = clazz.getMethod("init", new Class[0]);
                    method.invoke(null, new Object[0]);
                    object = clazz.getCanonicalName();
                    SDMX_LOGGER.info("Class configuration found: " + (String)object);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    SDMX_LOGGER.fine("Class configuration not found, skipping to global conf");
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                    SDMX_LOGGER.info("Error during SdmxConfiguration class initialization, skipping to global conf.");
                    SDMX_LOGGER.severe(Configuration.logException(invocationTargetException.getCause()));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException exception) {
                    exception.printStackTrace();
                }
            }
            System.setProperty("https.protocols", "TLSv1.1,TLSv1.2");
            return;
        }
    }

    private static void init(File file) throws SecurityException, IOException {
        try (Object object = new FileInputStream(file);){
            LogManager.getLogManager().readConfiguration((InputStream)object);
        }
        object = new FileInputStream(file);
        var2_2 = null;
        try {
            props.load((InputStream)object);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (var2_2 != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    ((FileInputStream)object).close();
                }
            }
        }
        object = props.getProperty(SSL_TRUSTSTORE_PROP);
        if (object != null && !((String)object).isEmpty()) {
            System.setProperty(SSL_TRUSTSTORE_PROP, (String)object);
        }
        Configuration.setupTrustAllCerts();
        SDMX_LANG = Locale.LanguageRange.parse(props.getProperty(SDMX_LANG_PROP, SDMX_DEFAULT_LANG));
        Configuration.configureProxy(props);
    }

    private static void setupTrustAllCerts() {
        if ("TRUE".equalsIgnoreCase(props.getProperty(SSL_DISABLE_CERT_CHECK_PROP))) {
            SDMX_LOGGER.fine("The SSL Certificate checks are disabled...");
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }
            }};
            SSLContext sSLContext = null;
            try {
                sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(null, trustManagerArray, new SecureRandom());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                SDMX_LOGGER.fine(Configuration.logException(noSuchAlgorithmException));
            }
            catch (KeyManagementException keyManagementException) {
                SDMX_LOGGER.fine(Configuration.logException(keyManagementException));
            }
            if (sSLContext != null) {
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            }
            HttpsURLConnection.setDefaultHostnameVerifier((string, sSLSession) -> true);
        }
    }

    public static void setDefaultProxy(String string, String string2, String string3, String string4) {
        if (string == null || string.isEmpty() || string2 == null || string2.isEmpty()) {
            return;
        }
        SimpleProxySelector simpleProxySelector = new SimpleProxySelector(string, Integer.parseInt(string2));
        ProxySelector.setDefault(simpleProxySelector);
        if (string3 != null && !string3.isEmpty()) {
            Configuration.setCredentials(PROXY_AUTH_BASIC, string3, string4);
        }
    }

    private static void configureProxy(Properties properties) {
        String string;
        Object object;
        String string2;
        String[] stringArray;
        Logger logger = SDMX_LOGGER;
        logger.entering(sourceClass, "configureProxy");
        String string3 = properties.getProperty(PROXY_DEFAULT_PROP);
        String string4 = null;
        int n = 0;
        boolean bl = false;
        if (string3 != null && !string3.isEmpty()) {
            bl = true;
            stringArray = string3.split(":");
            if (stringArray.length != 2 || stringArray[0] == null || stringArray[0].isEmpty() || stringArray[1] == null || stringArray[1].isEmpty()) {
                throw new IllegalArgumentException("Proxy settings must be valid. found: '" + string3 + "'");
            }
            string4 = stringArray[0].trim();
            n = Integer.parseInt(stringArray[1].trim());
        }
        stringArray = new SdmxProxySelector(string4, n);
        int n2 = 0;
        while ((string2 = properties.getProperty(PROXY_NAME_PROP + n2)) != null && !string2.isEmpty()) {
            bl = true;
            object = null;
            object = string2.split(":");
            if (object == null || ((String[])object).length != 2 || object[0] == null || object[0].isEmpty() || object[1] == null || object[1].isEmpty()) {
                throw new IllegalArgumentException("Proxy settings must be valid. host: '" + object[0] + "', port: '" + object[1] + "'");
            }
            string = properties.getProperty(PROXY_NAME_PROP + n2 + ".urls");
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("Proxy settings must be valid. host: '" + (String)object[0] + "', port: '" + (String)object[1] + "', urls: " + string);
            }
            String[] stringArray2 = string.split(",");
            stringArray.addProxy((String)object[0], (String)object[1], stringArray2);
            logger.finer("Proxy has been configured: '" + string2 + "' for " + string);
            ++n2;
        }
        if (bl) {
            ProxySelector.setDefault((ProxySelector)stringArray);
        }
        if (properties != null && bl) {
            String string5 = properties.getProperty(HTTP_AUTH_PREF_PROP);
            if (string5 != null) {
                string5 = string5.trim();
                System.setProperty(HTTP_AUTH_PREF_PROP, string5);
                logger.finer(string5 + " authentication enabled.");
                if (string5.equalsIgnoreCase(PROXY_AUTH_KERBEROS)) {
                    string2 = properties.getProperty(JAVA_SECURITY_KERBEROS_PROP);
                    object = properties.getProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG_PROP);
                    string = System.getenv().get("KRB5CCNAME");
                    if (string != null && object != null && string2 != null) {
                        string = string.trim();
                        object = ((String)object).trim();
                        string2 = string2.trim();
                        System.setProperty("user.krb5cc", string);
                        System.setProperty(JAVA_SECURITY_KERBEROS_PROP, string2);
                        System.setProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG_PROP, (String)object);
                        logger.finer("java.security.krb5.conf = " + string2);
                        logger.finer("java.security.auth.login.config = " + (String)object);
                        logger.finer("Environment variable KRB5CCNAME = " + string);
                    } else {
                        logger.warning("Kerberos ticket cache not configured because one of the parameters is not set.");
                        logger.warning("java.security.krb5.conf = " + string2);
                        logger.warning("java.security.auth.login.config = " + (String)object);
                        logger.warning("Environment variable KRB5CCNAME = " + string);
                    }
                } else if (string5.equalsIgnoreCase(PROXY_AUTH_BASIC)) {
                    string2 = properties.getProperty(HTTP_AUTH_USER_PROP);
                    object = properties.getProperty(PROXY_AUTH_PW_PROP);
                    Configuration.setCredentials(string5, string2, (String)object);
                    properties.remove(PROXY_AUTH_PW_PROP);
                } else {
                    logger.finer("Authentication type not supported: " + string5);
                }
            } else {
                logger.finer("No authentication enabled.");
            }
        }
        logger.exiting(sourceClass, "configureProxy");
    }

    private static void setCredentials(String string, String string2, String string3) {
        Object object;
        Object object2;
        System.setProperty(HTTP_AUTH_PREF_PROP, string);
        if (string2 == null || string3 == null) {
            object2 = new JFrame("Proxy Authentication");
            ((JFrame)object2).setDefaultCloseOperation(2);
            object = new LoginDialog((Frame)object2, "Proxy Authentication");
            ((Dialog)object).setVisible(true);
            string2 = ((LoginDialog)object).getUsername();
            string3 = ((LoginDialog)object).getPassword();
            ((Window)object2).dispose();
        }
        object2 = string2.trim();
        object = string3.trim();
        Authenticator.setDefault(new Authenticator((String)object2, (String)object){
            final /* synthetic */ String val$user;
            final /* synthetic */ String val$pw;
            {
                this.val$user = string;
                this.val$pw = string2;
            }

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                Logger logger = SDMX_LOGGER;
                logger.entering(sourceClass, "getPasswordAuthentication");
                PasswordAuthentication passwordAuthentication = new PasswordAuthentication(this.val$user, this.val$pw.toCharArray());
                logger.finer("Requesting Host  : " + this.getRequestingHost());
                logger.finer("Requesting Port  : " + this.getRequestingPort());
                logger.finer("Requesting Protocol: " + this.getRequestingProtocol());
                logger.finer("Requesting Scheme : " + this.getRequestingScheme());
                logger.exiting(sourceClass, "getPasswordAuthentication");
                return passwordAuthentication;
            }
        });
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("win") >= 0;
    }

    public static String getUISApiKey() {
        return props.getProperty(UIS_API_KEY_PROP, null);
    }

    private static String logException(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        stringWriter.flush();
        return stringWriter.toString();
    }

    public static String getDumpPrefix() {
        String string = props.getProperty(DUMP_XML_PREFIX);
        if (string == null || string.isEmpty()) {
            SDMX_LOGGER.warning("The directory set for storing xml files is not correctly set.");
            props.remove(DUMP_XML_PREFIX);
        }
        return string;
    }

    public static void setDumpPrefix(String string) {
        if (string == null || string.isEmpty()) {
            SDMX_LOGGER.warning("The directory for storing xml files cannot be null");
        } else {
            File file = new File(string);
            if (file.exists() && file.isDirectory()) {
                props.put(DUMP_XML_PREFIX, string);
            } else {
                SDMX_LOGGER.warning("The directory for storing xml files must already exist");
            }
        }
    }

    public static boolean isDumpXml() {
        return props.getProperty(DUMP_XML_PREFIX) != null && !props.getProperty(DUMP_XML_PREFIX).isEmpty();
    }

    public static void setSubject(Subject subject) {
        Configuration.subject = subject;
    }

    public static Subject getSubject() {
        return subject;
    }

    static {
        Configuration.init();
    }
}

