/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.MCOD;

import java.util.ArrayList;
import moa.clusterers.outliers.MCOD.ISBIndex;
import moa.clusterers.outliers.utils.mtree.DistanceFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicroCluster
implements DistanceFunctions.EuclideanCoordinate,
Comparable<MicroCluster> {
    public ISBIndex.ISBNode mcc;
    public ArrayList<ISBIndex.ISBNode> nodes;

    public MicroCluster(ISBIndex.ISBNode mcc) {
        this.mcc = mcc;
        this.nodes = new ArrayList();
        this.AddNode(mcc);
    }

    public void AddNode(ISBIndex.ISBNode node) {
        if (node != null) {
            this.nodes.add(node);
        }
    }

    public void RemoveNode(ISBIndex.ISBNode node) {
        if (node != null) {
            this.nodes.remove(node);
        }
    }

    public int GetNodesCount() {
        return this.nodes.size();
    }

    @Override
    public int dimensions() {
        return this.mcc.obj.dimensions();
    }

    @Override
    public double get(int index) {
        return this.mcc.obj.get(index);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MicroCluster) {
            MicroCluster that = (MicroCluster)obj;
            if (this.dimensions() != that.dimensions()) {
                return false;
            }
            for (int i = 0; i < this.dimensions(); ++i) {
                if (this.mcc.obj.get(i) == that.mcc.obj.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(MicroCluster that) {
        int dimensions = Math.min(this.dimensions(), that.dimensions());
        for (int i = 0; i < dimensions; ++i) {
            double v2;
            double v1 = this.mcc.obj.get(i);
            if (v1 > (v2 = that.mcc.obj.get(i))) {
                return 1;
            }
            if (!(v1 < v2)) continue;
            return -1;
        }
        if (this.dimensions() > dimensions) {
            return 1;
        }
        if (that.dimensions() > dimensions) {
            return -1;
        }
        return 0;
    }
}

