## ----set-options, echo = FALSE------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>", dev = "png", fig.width = 7, fig.height = 3.5, message = FALSE, warning = FALSE)
options(width = 80, tibble.width = Inf)

## -----------------------------------------------------------------------------
(M <- rbind(c(1,2,3,3,1),c(2,-3,2,3,-2)))

## -----------------------------------------------------------------------------
library("freegroup")
(x <- free(M))

## -----------------------------------------------------------------------------
(y <- as.free("aabbbcccc"))

## -----------------------------------------------------------------------------
x+y

## -----------------------------------------------------------------------------
x*5

## -----------------------------------------------------------------------------
x*(0:3)

## -----------------------------------------------------------------------------
abc(1:9)

## -----------------------------------------------------------------------------
rfree(10,4)

## -----------------------------------------------------------------------------
(u <- rfree(10,4))
-u
u-u

## -----------------------------------------------------------------------------
sum(u)

## -----------------------------------------------------------------------------
u
z <- alpha(26)
u^z

## -----------------------------------------------------------------------------
sum(u^z) == sum(u^z)

## -----------------------------------------------------------------------------
free(rbind(1:30,1))

## -----------------------------------------------------------------------------
options(symbols = state.abb)
free(rbind(1:50,1))

