/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.common.util.iterators.BitSetIntDomainIterator;
import choco.cp.solver.variables.delta.BitSetDeltaDomain;
import choco.cp.solver.variables.integer.AbstractIntDomain;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.structure.OneWordSBitSet32;
import choco.kernel.memory.structure.OneWordSBitSet64;
import choco.kernel.solver.propagation.PropagationEngine;
import choco.kernel.solver.variables.integer.IBitSetIntDomain;
import java.util.Random;

public final class BitSetIntDomain
extends AbstractIntDomain
implements IBitSetIntDomain {
    private static final Random random = new Random();
    private final int offset;
    private final IStateInt size;
    private final IStateInt inf;
    private final IStateInt sup;
    private final IStateBitSet contents;
    private final int capacity;
    protected BitSetIntDomainIterator _iterator = null;
    protected DisposableIntIterator _cachedDeltaIntDomainIterator = null;

    public BitSetIntDomain(IntDomainVarImpl v, int a, int b, IEnvironment environment, PropagationEngine propagationEngine) {
        super(v, propagationEngine);
        this.capacity = b - a + 1;
        this.offset = a;
        this.size = environment.makeInt(this.capacity);
        this.contents = this.capacity < 32 ? new OneWordSBitSet32(environment, this.capacity) : (this.capacity < 64 ? new OneWordSBitSet64(environment, this.capacity) : environment.makeBitSet(this.capacity));
        this.contents.set(0, this.capacity);
        this.deltaDom = new BitSetDeltaDomain(this.capacity, this.offset);
        this.inf = environment.makeInt(a);
        this.sup = environment.makeInt(b);
    }

    public BitSetIntDomain(IntDomainVarImpl v, int[] sortedValues, IEnvironment environment, PropagationEngine propagationEngine) {
        super(v, propagationEngine);
        int a = sortedValues[0];
        int b = sortedValues[sortedValues.length - 1];
        this.capacity = b - a + 1;
        this.offset = a;
        this.size = environment.makeInt(sortedValues.length);
        this.contents = this.capacity < 32 ? new OneWordSBitSet32(environment, this.capacity) : (this.capacity < 64 ? new OneWordSBitSet64(environment, this.capacity) : environment.makeBitSet(this.capacity));
        for (int sortedValue : sortedValues) {
            this.contents.set(sortedValue - a);
        }
        this.deltaDom = new BitSetDeltaDomain(this.capacity, this.offset);
        this.inf = environment.makeInt(a);
        this.sup = environment.makeInt(b);
    }

    @Override
    public IStateBitSet getContent() {
        return this.contents;
    }

    @Override
    public int getInf() {
        return this.inf.get();
    }

    @Override
    public int getSup() {
        return this.sup.get();
    }

    @Override
    public int updateInf(int x) {
        int newi = x - this.offset;
        int i = this.inf.get() - this.offset;
        while (i < newi) {
            assert (this.contents.get(i));
            this.removeIndex(i);
            i = this.contents.nextSetBit(i + 1);
        }
        this.inf.set(this.contents.nextSetBit(newi) + this.offset);
        return this.inf.get();
    }

    @Override
    public int updateSup(int x) {
        int newi = x - this.offset;
        int i = this.sup.get() - this.offset;
        while (i > newi) {
            assert (this.contents.get(i));
            this.removeIndex(i);
            i = this.contents.prevSetBit(i - 1);
        }
        this.sup.set(this.contents.prevSetBit(newi) + this.offset);
        return this.sup.get();
    }

    @Override
    public boolean contains(int x) {
        return this.contents.get(x - this.offset);
    }

    @Override
    public boolean remove(int x) {
        int i = x - this.offset;
        if (this.contents.get(i)) {
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    private void removeIndex(int i) {
        this.contents.clear(i);
        this.deltaDom.remove(i + this.offset);
        assert (!this.contents.get(i));
        this.size.add(-1);
    }

    @Override
    public void restrict(int x) {
        int xi = x - this.offset;
        int i = this.contents.nextSetBit(0);
        while (i >= 0) {
            if (i != xi) {
                this.deltaDom.remove(i + this.offset);
            }
            i = this.contents.nextSetBit(i + 1);
        }
        this.contents.clear();
        this.contents.set(xi);
        this.size.set(1);
        this.sup.set(x);
        this.inf.set(x);
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    @Override
    public DisposableIntIterator getIterator() {
        if (this._iterator == null) {
            this._iterator = new BitSetIntDomainIterator();
        } else if (!this._iterator.reusable()) {
            this._iterator = new BitSetIntDomainIterator();
        }
        this._iterator.init(this.offset, this.contents);
        return this._iterator;
    }

    @Override
    public final int getNextValue(int x) {
        int i = x - this.offset;
        if (i < 0 || x < this.inf.get()) {
            return this.getInf();
        }
        int bit = this.contents.nextSetBit(i + 1);
        if (bit < 0) {
            return Integer.MAX_VALUE;
        }
        return bit + this.offset;
    }

    @Override
    public final int fastNextValue(int x) {
        int bit = this.contents.nextSetBit(x - this.offset + 1);
        if (bit < 0) {
            return Integer.MAX_VALUE;
        }
        return bit + this.offset;
    }

    @Override
    public int getPrevValue(int x) {
        int i = x - this.offset;
        if (x > this.sup.get()) {
            return this.sup.get();
        }
        return this.contents.prevSetBit(i - 1) + this.offset;
    }

    @Override
    public boolean hasNextValue(int x) {
        return x < this.sup.get();
    }

    @Override
    public boolean hasPrevValue(int x) {
        return x > this.inf.get();
    }

    @Override
    public int getRandomValue() {
        int size = this.getSize();
        if (size == 1) {
            return this.getInf();
        }
        int rand = random.nextInt(size);
        int val = this.getInf() - this.offset;
        for (int o = 0; o < rand; ++o) {
            val = this.contents.nextSetBit(val + 1);
        }
        return val + this.offset;
    }

    @Override
    public boolean isEnumerated() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return this.offset == 0 && this.offset + this.capacity - 1 == 1;
    }

    @Override
    public String toString() {
        return "{" + this.getInf() + "..." + this.getSup() + '}';
    }

    @Override
    public String pretty() {
        StringBuilder buf = new StringBuilder("{");
        int maxDisplay = 15;
        int count = 0;
        DisposableIntIterator it = this.getIterator();
        while (it.hasNext() && count < 15) {
            int val = it.next();
            if (++count > 1) {
                buf.append(", ");
            }
            buf.append(val);
        }
        it.dispose();
        if (this.getSize() > 15) {
            buf.append("..., ");
            buf.append(this.getSup());
        }
        buf.append('}');
        return buf.toString();
    }
}

