/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.iterators;

import choco.kernel.common.util.disposable.PoolManager;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.iterators.IStored;

public final class OneValueIterator
extends DisposableIntIterator
implements IStored {
    private static final ThreadLocal<PoolManager<OneValueIterator>> manager = new ThreadLocal();
    private int value;
    private boolean next;
    private boolean isStored;

    private OneValueIterator() {
    }

    public static OneValueIterator getIterator(int aValue) {
        OneValueIterator it;
        PoolManager<OneValueIterator> tmanager = manager.get();
        if (tmanager == null) {
            tmanager = new PoolManager();
            manager.set(tmanager);
        }
        if ((it = tmanager.getE()) == null) {
            it = new OneValueIterator();
        }
        it.init(aValue);
        return it;
    }

    public void init(int aValue) {
        super.init();
        this.value = aValue;
        this.next = true;
    }

    @Override
    public boolean hasNext() {
        return this.next;
    }

    @Override
    public int next() {
        this.next = false;
        return this.value;
    }

    @Override
    public void dispose() {
        super.dispose();
        manager.get().returnE(this);
    }

    @Override
    public void push() {
        this.isStored = true;
    }

    @Override
    public void pop() {
        this.isStored = false;
    }

    @Override
    public boolean isStored() {
        return this.isStored;
    }
}

