/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.scorecard;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NumberAdapter;
import org.dmg.pmml.scorecard.Characteristics;
import org.dmg.pmml.scorecard.HasBaselineScore;
import org.dmg.pmml.scorecard.PMMLAttributes;
import org.dmg.pmml.scorecard.PMMLElements;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="Scorecard", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "characteristics", "modelVerification"})
@Added(value=Version.PMML_4_1)
@JsonRootName(value="Scorecard")
@JsonPropertyOrder(value={"modelName", "miningFunction", "algorithmName", "initialScore", "useReasonCodes", "reasonCodeAlgorithm", "baselineScore", "baselineMethod", "scorable", "mathContext", "extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "characteristics", "modelVerification"})
public class Scorecard
extends Model
implements HasExtensions<Scorecard>,
HasBaselineScore<Scorecard> {
    @XmlAttribute(name="modelName")
    @JsonProperty(value="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    @JsonProperty(value="functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="initialScore")
    @XmlJavaTypeAdapter(value=NumberAdapter.class)
    @JsonProperty(value="initialScore")
    private Number initialScore;
    @XmlAttribute(name="useReasonCodes")
    @JsonProperty(value="useReasonCodes")
    private Boolean useReasonCodes;
    @XmlAttribute(name="reasonCodeAlgorithm")
    @JsonProperty(value="reasonCodeAlgorithm")
    private ReasonCodeAlgorithm reasonCodeAlgorithm;
    @XmlAttribute(name="baselineScore")
    @XmlJavaTypeAdapter(value=NumberAdapter.class)
    @JsonProperty(value="baselineScore")
    private Number baselineScore;
    @XmlAttribute(name="baselineMethod")
    @JsonProperty(value="baselineMethod")
    private BaselineMethod baselineMethod;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    @JsonProperty(value="isScorable")
    private Boolean scorable;
    @XmlAttribute(name="x-mathContext")
    @Added(value=Version.XPMML)
    @JsonProperty(value="x-mathContext")
    private MathContext mathContext;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Output")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelStats")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Targets")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name="Characteristics", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="Characteristics")
    private Characteristics characteristics;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelVerification")
    private ModelVerification modelVerification;
    private static final Number DEFAULT_INITIAL_SCORE = new NumberAdapter().unmarshal("0");
    private static final Boolean DEFAULT_USE_REASON_CODES = true;
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67371270L;

    public Scorecard() {
    }

    @ValueConstructor
    public Scorecard(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="miningSchema") MiningSchema miningSchema, @Property(value="characteristics") Characteristics characteristics) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.characteristics = characteristics;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public Scorecard setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SCORECARD_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public Scorecard setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public Scorecard setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Number getInitialScore() {
        if (this.initialScore == null) {
            return DEFAULT_INITIAL_SCORE;
        }
        return this.initialScore;
    }

    public Scorecard setInitialScore(@Property(value="initialScore") Number initialScore) {
        this.initialScore = initialScore;
        return this;
    }

    public boolean isUseReasonCodes() {
        if (this.useReasonCodes == null) {
            return DEFAULT_USE_REASON_CODES;
        }
        return this.useReasonCodes;
    }

    public Scorecard setUseReasonCodes(@Property(value="useReasonCodes") Boolean useReasonCodes) {
        this.useReasonCodes = useReasonCodes;
        return this;
    }

    public ReasonCodeAlgorithm getReasonCodeAlgorithm() {
        if (this.reasonCodeAlgorithm == null) {
            return ReasonCodeAlgorithm.POINTS_BELOW;
        }
        return this.reasonCodeAlgorithm;
    }

    public Scorecard setReasonCodeAlgorithm(@Property(value="reasonCodeAlgorithm") ReasonCodeAlgorithm reasonCodeAlgorithm) {
        this.reasonCodeAlgorithm = reasonCodeAlgorithm;
        return this;
    }

    @Override
    public Number getBaselineScore() {
        return this.baselineScore;
    }

    @Override
    public Scorecard setBaselineScore(@Property(value="baselineScore") Number baselineScore) {
        this.baselineScore = baselineScore;
        return this;
    }

    public BaselineMethod getBaselineMethod() {
        if (this.baselineMethod == null) {
            return BaselineMethod.OTHER;
        }
        return this.baselineMethod;
    }

    public Scorecard setBaselineMethod(@Property(value="baselineMethod") BaselineMethod baselineMethod) {
        this.baselineMethod = baselineMethod;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public Scorecard setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    @Override
    public Scorecard setMathContext(@Property(value="mathContext") MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Scorecard addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema requireMiningSchema() {
        if (this.miningSchema == null) {
            throw new MissingElementException(this, PMMLElements.SCORECARD_MININGSCHEMA);
        }
        return this.miningSchema;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public Scorecard setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public Scorecard setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public Scorecard setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public Scorecard setModelExplanation(@Property(value="modelExplanation") ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public Scorecard setTargets(@Property(value="targets") Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public Scorecard setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public Characteristics requireCharacteristics() {
        if (this.characteristics == null) {
            throw new MissingElementException(this, PMMLElements.SCORECARD_CHARACTERISTICS);
        }
        return this.characteristics;
    }

    public Characteristics getCharacteristics() {
        return this.characteristics;
    }

    public Scorecard setCharacteristics(@Property(value="characteristics") Characteristics characteristics) {
        this.characteristics = characteristics;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public Scorecard setModelVerification(@Property(value="modelVerification") ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getTargets(), this.getLocalTransformations(), this.getCharacteristics(), this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum ReasonCodeAlgorithm implements StringValue<ReasonCodeAlgorithm>
    {
        POINTS_ABOVE("pointsAbove"),
        POINTS_BELOW("pointsBelow");

        private final String value;

        private ReasonCodeAlgorithm(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static ReasonCodeAlgorithm fromValue(String v) {
            for (ReasonCodeAlgorithm c : ReasonCodeAlgorithm.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum BaselineMethod implements StringValue<BaselineMethod>
    {
        MAX("max"),
        MIN("min"),
        MEAN("mean"),
        NEUTRAL("neutral"),
        OTHER("other");

        private final String value;

        private BaselineMethod(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static BaselineMethod fromValue(String v) {
            for (BaselineMethod c : BaselineMethod.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

