/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.plots.PlotController;
import org.rosuda.deducer.plots.Position;

public class PositionPanel
extends JPanel {
    private JTextField height;
    private JLabel hieghtLabel;
    private JTextField width;
    private JLabel widthLabel;
    private JComboBox position;
    private Position model;

    public PositionPanel(Position position) {
        this.initGUI();
        this.setModel(position);
    }

    public PositionPanel() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.setLayout((LayoutManager)anchorLayout);
            this.setPreferredSize(new Dimension(190, 109));
            this.setBorder(BorderFactory.createTitledBorder("Position"));
            this.height = new JTextField();
            this.add((Component)this.height, new AnchorConstraint(655, 899, 857, 557, 1, 1, 1, 1));
            this.height.setPreferredSize(new Dimension(56, 22));
            this.hieghtLabel = new JLabel();
            this.add((Component)this.hieghtLabel, new AnchorConstraint(692, 557, 830, 106, 1, 1, 1, 1));
            this.hieghtLabel.setText("Height:");
            this.hieghtLabel.setPreferredSize(new Dimension(74, 15));
            this.hieghtLabel.setHorizontalAlignment(11);
            this.width = new JTextField();
            this.add((Component)this.width, new AnchorConstraint(463, 899, 665, 557, 1, 1, 1, 1));
            this.width.setPreferredSize(new Dimension(56, 22));
            this.widthLabel = new JLabel();
            this.add((Component)this.widthLabel, new AnchorConstraint(500, 557, 637, 106, 1, 1, 1, 1));
            this.widthLabel.setText("Width:");
            this.widthLabel.setPreferredSize(new Dimension(74, 15));
            this.widthLabel.setHorizontalAlignment(11);
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(PlotController.getPositionNames());
            this.position = new JComboBox();
            this.add((Component)this.position, new AnchorConstraint(188, 960, 389, 40, 1, 1, 1, 1));
            this.position.setModel(defaultComboBoxModel);
            this.position.setPreferredSize(new Dimension(170, 22));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setModel(Position position) {
        this.model = position;
        this.position.setSelectedItem(position.name);
        if (position.height != null) {
            this.height.setText(position.height.toString());
        }
        if (position.width != null) {
            this.width.setText(position.width.toString());
        }
    }

    public void updateModel() {
        this.model.name = this.position.getSelectedItem().toString();
        String string = this.height.getText();
        if (string != null && string.length() > 0) {
            try {
                this.model.height = new Double(Double.parseDouble(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = this.width.getText()) != null && string.length() > 0) {
            try {
                this.model.width = new Double(Double.parseDouble(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Position getModel() {
        this.updateModel();
        return this.model;
    }
}

