/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.syntaxtree.mut;

import java.util.ArrayList;
import net.sourceforge.jclec.syntaxtree.IMutateSyntaxTree;
import net.sourceforge.jclec.syntaxtree.NonTerminalNode;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeSchema;
import net.sourceforge.jclec.util.random.IRandGen;

public class RecurseNTMutator
implements IMutateSyntaxTree {
    private static final long serialVersionUID = -2706522794304044852L;

    public boolean equals(Object other) {
        return other instanceof RecurseNTMutator;
    }

    @Override
    public SyntaxTree mutateSyntaxTree(SyntaxTree parent, SyntaxTreeSchema schema, IRandGen randgen) {
        SyntaxTree son = new SyntaxTree();
        int p0_branchStart = this.selectSymbol(parent, schema, randgen);
        if (p0_branchStart == -1) {
            int i = 0;
            while (i < parent.size()) {
                son.addNode(parent.getNode(i).copy());
                ++i;
            }
            return son;
        }
        NonTerminalNode selectedProduction = this.chooseRecursiveProduction(parent.getNode(p0_branchStart).getSymbol(), schema, randgen);
        int p0_branchEnd = parent.subTree(p0_branchStart);
        int i = 0;
        while (i < p0_branchStart) {
            son.addNode(parent.getNode(i).copy());
            ++i;
        }
        this.addProduction(parent, son, selectedProduction, p0_branchStart, p0_branchEnd, schema, randgen);
        int j = p0_branchEnd;
        while (j < parent.size()) {
            son.addNode(parent.getNode(j).copy());
            ++j;
        }
        if (son.derivSize() > schema.getMaxDerivSize()) {
            son.clear();
            i = 0;
            while (i < parent.size()) {
                son.addNode(parent.getNode(i).copy());
                ++i;
            }
        }
        return son;
    }

    private final int selectSymbol(SyntaxTree tree, SyntaxTreeSchema schema, IRandGen randgen) {
        int startPos;
        int treeLength = tree.size();
        int actPos = startPos = randgen.choose(0, treeLength);
        int i = 0;
        while (i < treeLength) {
            actPos = (startPos + i) % treeLength;
            if (!schema.isTerminal(tree.getNode(actPos).getSymbol())) {
                NonTerminalNode nonTerminalSymbols = (NonTerminalNode)tree.getNode(actPos);
                int j = 0;
                while (j < nonTerminalSymbols.getProduction().length) {
                    if (tree.getNode(actPos).getSymbol().equalsIgnoreCase(nonTerminalSymbols.getProduction()[j])) {
                        int p = actPos + 1;
                        while (p < tree.size()) {
                            if (tree.getNode(p).getSymbol().equalsIgnoreCase(nonTerminalSymbols.getProduction()[j])) {
                                return p;
                            }
                            ++p;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return -1;
    }

    public void addProduction(SyntaxTree parent, SyntaxTree son, NonTerminalNode selectedProduction, int initialPoint, int finalPoint, SyntaxTreeSchema schema, IRandGen randgen) {
        son.addNode(selectedProduction);
        boolean visited = false;
        int selProdSize = selectedProduction.getProduction().length;
        int i = 0;
        while (i < selProdSize) {
            if (selectedProduction.getProduction()[i].equalsIgnoreCase(selectedProduction.getSymbol()) && !visited) {
                visited = true;
                int endBranch = parent.subTree(initialPoint);
                int h = initialPoint;
                while (h < endBranch) {
                    son.addNode(parent.getNode(h).copy());
                    ++h;
                }
            } else {
                schema.fillSyntaxBranch(son, selectedProduction.getProduction()[i], randgen);
            }
            ++i;
        }
    }

    public NonTerminalNode chooseRecursiveProduction(String selectedSymbol, SyntaxTreeSchema schema, IRandGen randgen) {
        NonTerminalNode[] nonTerminalNodes = schema.getNonTerminals();
        ArrayList<NonTerminalNode> recursiveNonTerminalNodes = new ArrayList<NonTerminalNode>();
        boolean recursive = false;
        int h = 0;
        while (h < nonTerminalNodes.length) {
            if (nonTerminalNodes[h].getSymbol().equalsIgnoreCase(selectedSymbol)) {
                recursive = false;
                int j = 0;
                while (j < nonTerminalNodes[h].getProduction().length && !recursive) {
                    if (selectedSymbol.equalsIgnoreCase(nonTerminalNodes[h].getProduction()[j])) {
                        recursive = true;
                        recursiveNonTerminalNodes.add(nonTerminalNodes[h]);
                    }
                    ++j;
                }
            }
            ++h;
        }
        int nOfProduction = randgen.choose(0, recursiveNonTerminalNodes.size() - 1);
        return (NonTerminalNode)recursiveNonTerminalNodes.get(nOfProduction);
    }
}

