/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.bool;

import choco.cp.solver.constraints.integer.bool.BooleanFactory;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class LargeXnor
extends AbstractLargeIntSConstraint {
    LargeXnor(IntDomainVar[] vars) {
        super(ConstraintEvent.LINEAR, vars);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 8;
    }

    @Override
    public void awake() throws ContradictionException {
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            if (!((IntDomainVar[])this.vars)[i].isInstantiated()) continue;
            this.filter(i);
            break;
        }
    }

    private void filter(int idx) throws ContradictionException {
        int val = ((IntDomainVar[])this.vars)[idx].getVal();
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            if (idx == i) continue;
            ((IntDomainVar[])this.vars)[i].instantiate(val, this, false);
        }
    }

    @Override
    public void propagate() throws ContradictionException {
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        for (int aTuple : tuple) {
            if (aTuple == tuple[0]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean isEntailed() {
        for (IntDomainVar var : (IntDomainVar[])this.vars) {
            if (var.isInstantiated()) {
                if (var.getVal() == ((IntDomainVar[])this.vars)[0].getVal()) continue;
                return Boolean.FALSE;
            }
            return null;
        }
        return Boolean.TRUE;
    }

    @Override
    public AbstractSConstraint<IntDomainVar> opposite(Solver solver) {
        return BooleanFactory.xor((IntDomainVar[])this.vars);
    }
}

