/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.global.matching;

import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBool;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.global.matching.AbstractBipartiteGraph;
import choco.kernel.solver.variables.integer.IntDomainVar;

public abstract class AbstractBipartiteFlow
extends AbstractBipartiteGraph {
    protected int[] minFlow;
    protected int[] maxFlow;
    protected IStateIntVector flow;
    protected boolean compatibleFlow;
    protected IStateBool compatibleSupport;

    public AbstractBipartiteFlow(IEnvironment environment, IntDomainVar[] vars, int nbLeft, int nbRight) {
        super(environment, vars, nbLeft, nbRight);
        this.flow = environment.makeIntVector(this.nbRightVertices, 0);
        this.minFlow = new int[this.nbRightVertices];
        this.maxFlow = new int[this.nbRightVertices];
        this.left2rightArc = new int[this.nbLeftVertices + 1];
        this.queue = new AbstractBipartiteGraph.IntQueue(this.nbVertices);
        this.compatibleSupport = environment.makeBool(true);
    }

    @Override
    protected void init() {
        super.init();
        for (int i = 0; i < this.nbRightVertices; ++i) {
            this.flow.set(i, 0);
        }
        this.compatibleSupport.set(true);
    }

    protected int getMinFlow(int j) {
        return this.minFlow[j];
    }

    protected int getMaxFlow(int j) {
        return this.maxFlow[j];
    }

    @Override
    public void setMatch(int i, int j) {
        assert (0 <= i && i < this.nbLeftVertices && 0 <= j && j < this.nbRightVertices);
        int j0 = this.refMatch.get(i);
        if (j0 != j) {
            if (j0 >= 0) {
                this.refMatch.set(i, -1);
                this.decreaseMatchingSize(j0);
            }
            if (this.flow.get(j) < this.getMaxFlow(j)) {
                this.refMatch.set(i, j);
                this.increaseMatchingSize(j);
            }
        }
    }

    @Override
    public void deleteMatch(int i, int j) {
        assert (0 <= i && i < this.nbLeftVertices && 0 <= j && j < this.nbRightVertices);
        if (j == this.refMatch.get(i)) {
            this.refMatch.set(i, -1);
            this.decreaseMatchingSize(j);
        }
    }

    @Override
    public void putRefMatch(int i, int j) {
        this.refMatch.set(i, j);
    }

    @Override
    public boolean mayDiminishFlowFromSource(int j) {
        return this.flow.get(j) > this.getMinFlow(j);
    }

    @Override
    public boolean mayGrowFlowFromSource(int j) {
        return this.flow.get(j) < this.getMaxFlow(j);
    }

    @Override
    public boolean mustGrowFlowFromSource(int j) {
        return this.flow.get(j) < this.getMinFlow(j);
    }

    @Override
    public void increaseMatchingSize(int j) {
        this.matchingSize.add(1);
        this.flow.set(j, this.flow.get(j) + 1);
        int delta = this.flow.get(j) - this.getMaxFlow(j);
        if (delta > 0) {
            this.compatibleSupport.set(false);
        }
    }

    @Override
    public void decreaseMatchingSize(int j) {
        this.matchingSize.add(-1);
        this.flow.set(j, this.flow.get(j) - 1);
        int delta = this.getMinFlow(j) - this.flow.get(j);
        if (delta > 0) {
            this.compatibleSupport.set(false);
        }
    }

    @Override
    public int findAlternatingPath() {
        int j;
        int eopath = -1;
        int n = this.nbLeftVertices;
        int m = this.nbRightVertices;
        this.queue.init();
        for (j = 0; j < this.nbRightVertices; ++j) {
            if (!this.mustGrowFlowFromSource(j)) continue;
            this.queue.push(j + n);
        }
        if (this.queue.getSize() == 0) {
            this.compatibleFlow = true;
            for (j = 0; j < this.nbRightVertices; ++j) {
                if (!this.mayGrowFlowFromSource(j)) continue;
                this.queue.push(j + n);
            }
        } else {
            this.compatibleFlow = false;
        }
        while (this.queue.getSize() > 0) {
            int x = this.queue.pop();
            if (x >= n && x < m + n) {
                boolean shouldBreak = false;
                int[] yy = this.mayInverseMatch(x -= n);
                for (int i = 0; i < yy.length; ++i) {
                    int y = yy[i];
                    if (!this.mayGrowFlowBetween(x, y) || this.queue.onceInQueue(y)) continue;
                    this.left2rightArc[y] = x;
                    if (this.mayGrowFlowToSink(y)) {
                        eopath = y;
                        shouldBreak = true;
                        break;
                    }
                    this.queue.push(y);
                }
                if (!this.compatibleFlow && this.mayDiminishFlowFromSource(x) && !this.queue.onceInQueue(n + m)) {
                    this.left2rightArc[n] = x;
                    this.queue.push(n + m);
                }
                if (!shouldBreak) continue;
                break;
            }
            if (x < n) {
                int y = this.match(x);
                if (this.queue.onceInQueue(y + n)) continue;
                this.right2leftArc[y] = x;
                this.queue.push(y + n);
                continue;
            }
            if (this.compatibleFlow) continue;
            for (int j2 = 0; j2 < this.nbRightVertices; ++j2) {
                if (!this.mayGrowFlowFromSource(j2) || this.queue.onceInQueue(j2 + n)) continue;
                this.right2leftArc[j2] = n;
                this.queue.push(j2 + n);
            }
        }
        return eopath;
    }

    @Override
    public void augment(int x) {
        int y = this.left2rightArc[x];
        if (this.compatibleFlow) {
            while (!this.mayGrowFlowFromSource(y)) {
                this.putRefMatch(x, y);
                x = this.right2leftArc[y];
                y = this.left2rightArc[x];
            }
        } else {
            int n = this.nbLeftVertices;
            int m = this.nbRightVertices;
            while (!this.mustGrowFlowFromSource(y)) {
                this.putRefMatch(x, y);
                x = this.right2leftArc[y];
                if (x == n) {
                    this.increaseMatchingSize(y);
                    y = this.left2rightArc[x];
                    this.decreaseMatchingSize(y);
                    x = this.right2leftArc[y];
                }
                y = this.left2rightArc[x];
            }
        }
        this.putRefMatch(x, y);
        this.increaseMatchingSize(y);
    }

    @Override
    protected void removeUselessEdges() throws ContradictionException {
        if (!this.compatibleSupport.get()) {
            this.matchingSize.set(0);
            for (int i = 0; i < this.nbLeftVertices; ++i) {
                this.refMatch.set(i, -1);
            }
            for (int j = 0; j < this.nbRightVertices; ++j) {
                this.flow.set(j, 0);
            }
            this.augmentFlow();
        }
        super.removeUselessEdges();
    }
}

