/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.apache.log4j.Logger;
import org.xmlcml.euclid.Real2Array;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.Univariate;

public class Bivariate {
    private static final Logger LOG = Logger.getLogger(Bivariate.class);
    private Real2Array real2Array;
    private Double slope;
    private Double intercept;
    private RealArray xarr;
    private RealArray yarr;
    private Double corrCoeff;
    private RealArray residuals;

    public Bivariate(Real2Array real2Array) {
        this.real2Array = real2Array;
        this.xarr = real2Array.getXArray();
        this.yarr = real2Array.getYArray();
    }

    public Double getSlope() {
        this.ensureSlope();
        return this.slope;
    }

    public Double getIntercept() {
        this.ensureSlope();
        return this.intercept;
    }

    private void ensureSlope() {
        if (this.slope == null && this.xarr.size() > 1) {
            double count = this.xarr.size();
            double sigmax = this.xarr.sumAllElements();
            double sigmay = this.yarr.sumAllElements();
            double sigmaxy = this.xarr.sumProductOfAllElements(this.yarr);
            double numerator = sigmaxy - sigmax * sigmay / count;
            double sigmax2 = this.xarr.sumProductOfAllElements(this.xarr);
            double sigmay2 = this.yarr.sumProductOfAllElements(this.yarr);
            double denominator = sigmax2 - sigmax * sigmax / count;
            this.slope = numerator / denominator;
            this.intercept = sigmay / count - this.slope * sigmax / count;
            this.corrCoeff = (count * sigmaxy - sigmax * sigmay) / Math.sqrt((count * sigmax2 - sigmax * sigmax) * (count * sigmay2 - sigmay * sigmay));
        }
    }

    public Double getCorrelationCoefficient() {
        this.ensureSlope();
        return this.corrCoeff;
    }

    public RealArray getResiduals() {
        this.ensureSlope();
        this.residuals = new RealArray(this.xarr.size());
        for (int i = 0; i < this.xarr.size(); ++i) {
            double deltay = this.yarr.elementAt(i) - (this.slope * this.xarr.elementAt(i) + this.intercept);
            this.residuals.setElementAt(i, deltay);
        }
        return this.residuals;
    }

    public RealArray getNormalizedResiduals() {
        this.getResiduals();
        LOG.trace((Object)("R> " + this.residuals.format(2)));
        Univariate univariate = new Univariate(this.residuals);
        RealArray normalisedResiduals = univariate.getNormalizedValues();
        LOG.trace((Object)("N> " + normalisedResiduals.format(2)));
        return normalisedResiduals;
    }
}

