/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.advanced.math;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import jdplus.toolkit.base.api.advanced.math.Polynomials;

public final class PolynomialsLoader {

    public static final class Processor {
        private final Iterable<Polynomials.Processor> source = ServiceLoader.load(Polynomials.Processor.class);
        private final AtomicReference<Polynomials.Processor> resource = new AtomicReference<Polynomials.Processor>(this.doLoad());
        private final Consumer<Iterable> cleaner = loader -> ((ServiceLoader)loader).reload();

        private Polynomials.Processor doLoad() throws IllegalStateException {
            return StreamSupport.stream(this.source.spliterator(), false).findFirst().orElseThrow(() -> new IllegalStateException("Missing mandatory provider of Polynomials.Processor"));
        }

        public Polynomials.Processor get() {
            return this.resource.get();
        }

        public void set(Polynomials.Processor newValue) {
            this.resource.set(Objects.requireNonNull(newValue));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reload() throws IllegalStateException {
            Iterable<Polynomials.Processor> iterable = this.source;
            synchronized (iterable) {
                this.cleaner.accept(this.source);
                this.set(this.doLoad());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() throws IllegalStateException {
            Iterable<Polynomials.Processor> iterable = this.source;
            synchronized (iterable) {
                this.set(this.doLoad());
            }
        }
    }
}

