/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13;

import jdplus.sa.base.api.StationaryVarianceDecomposition;
import jdplus.sa.base.core.diagnostics.GenericSaTests;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.x13.base.core.x11.X11Results;
import jdplus.x13.base.core.x13.Mstatistics;
import jdplus.x13.base.core.x13.X13Finals;
import jdplus.x13.base.core.x13.X13Preadjustment;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class X13Diagnostics {
    private final StationaryVarianceDecomposition varianceDecomposition;
    private final GenericSaTests genericDiagnostics;
    private final Mstatistics mstatistics;

    public static X13Diagnostics of(RegSarimaModel preprocessing, X13Preadjustment preadj, X11Results xrslts, X13Finals finals) {
        TsData li;
        Mstatistics mstats = Mstatistics.of(preadj, xrslts, finals);
        boolean mul = xrslts.getMode().isMultiplicative();
        TsDomain dom = xrslts.getActualDomain();
        TsData sa = TsData.fitToDomain((TsData)xrslts.getD11(), (TsDomain)dom);
        TsData i = TsData.fitToDomain((TsData)xrslts.getD13(), (TsDomain)dom);
        TsData t = TsData.fitToDomain((TsData)xrslts.getD12(), (TsDomain)dom);
        TsData si = TsData.fitToDomain((TsData)xrslts.getD8(), (TsDomain)dom);
        TsData y = TsData.fitToDomain((TsData)xrslts.getB1(), (TsDomain)dom);
        TsData lsa = mul ? sa.log() : sa;
        TsData tsData = li = mul ? i.log() : i;
        TsData lin = preprocessing != null ? preprocessing.linearizedSeries() : (mul ? preadj.getA1().log() : preadj.getA1());
        GenericSaTests gsadiags = GenericSaTests.builder().mul(mul).regarima(preprocessing).lin(lin).res(preprocessing == null ? null : preprocessing.fullResiduals()).y(y).sa(sa).irr(i).si(si).lsa(lsa).lirr(li).build();
        return new X13Diagnostics(X13Diagnostics.varDecomposition(mstats), gsadiags, mstats);
    }

    private static StationaryVarianceDecomposition varDecomposition(Mstatistics m) {
        return StationaryVarianceDecomposition.builder().C(m.getVarC()).S(m.getVarS()).I(m.getVarI()).Calendar(m.getVarTD()).P(m.getVarP()).trendType(StationaryVarianceDecomposition.TrendType.Linear).build();
    }

    @Generated
    public StationaryVarianceDecomposition getVarianceDecomposition() {
        return this.varianceDecomposition;
    }

    @Generated
    public GenericSaTests getGenericDiagnostics() {
        return this.genericDiagnostics;
    }

    @Generated
    public Mstatistics getMstatistics() {
        return this.mstatistics;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof X13Diagnostics)) {
            return false;
        }
        X13Diagnostics other = (X13Diagnostics)o;
        StationaryVarianceDecomposition this$varianceDecomposition = this.getVarianceDecomposition();
        StationaryVarianceDecomposition other$varianceDecomposition = other.getVarianceDecomposition();
        if (this$varianceDecomposition == null ? other$varianceDecomposition != null : !this$varianceDecomposition.equals(other$varianceDecomposition)) {
            return false;
        }
        GenericSaTests this$genericDiagnostics = this.getGenericDiagnostics();
        GenericSaTests other$genericDiagnostics = other.getGenericDiagnostics();
        if (this$genericDiagnostics == null ? other$genericDiagnostics != null : !this$genericDiagnostics.equals(other$genericDiagnostics)) {
            return false;
        }
        Mstatistics this$mstatistics = this.getMstatistics();
        Mstatistics other$mstatistics = other.getMstatistics();
        return !(this$mstatistics == null ? other$mstatistics != null : !this$mstatistics.equals(other$mstatistics));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StationaryVarianceDecomposition $varianceDecomposition = this.getVarianceDecomposition();
        result = result * 59 + ($varianceDecomposition == null ? 43 : $varianceDecomposition.hashCode());
        GenericSaTests $genericDiagnostics = this.getGenericDiagnostics();
        result = result * 59 + ($genericDiagnostics == null ? 43 : $genericDiagnostics.hashCode());
        Mstatistics $mstatistics = this.getMstatistics();
        result = result * 59 + ($mstatistics == null ? 43 : $mstatistics.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "X13Diagnostics(varianceDecomposition=" + String.valueOf(this.getVarianceDecomposition()) + ", genericDiagnostics=" + String.valueOf(this.getGenericDiagnostics()) + ", mstatistics=" + String.valueOf(this.getMstatistics()) + ")";
    }

    @Generated
    private X13Diagnostics(StationaryVarianceDecomposition varianceDecomposition, GenericSaTests genericDiagnostics, Mstatistics mstatistics) {
        this.varianceDecomposition = varianceDecomposition;
        this.genericDiagnostics = genericDiagnostics;
        this.mstatistics = mstatistics;
    }
}

