/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.models;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.rosuda.deducer.models.LogisticModel;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class LogisticExplorerRoc
extends JDialog
implements ActionListener,
FocusListener {
    private JCheckBox roc;
    private JCheckBox diag;
    private JPanel okayCancel;
    private JCheckBox auc;
    private JCheckBox predProbs;
    private JPanel optionsPanel;
    private LogisticModel model;

    public LogisticExplorerRoc(JFrame jFrame, LogisticModel logisticModel) {
        super(jFrame);
        this.initGUI();
        this.setModel(logisticModel);
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.roc = new JCheckBox();
            this.getContentPane().add(this.roc);
            this.roc.setText("Display ROC Plot");
            this.roc.setBounds(81, 10, 149, 18);
            this.optionsPanel = new JPanel();
            this.getContentPane().add(this.optionsPanel);
            this.optionsPanel.setBounds(12, 37, 255, 104);
            this.optionsPanel.setBorder(BorderFactory.createTitledBorder("Options"));
            this.optionsPanel.setLayout(null);
            this.predProbs = new JCheckBox();
            this.optionsPanel.add(this.predProbs);
            this.predProbs.setText("Predictive probabilities");
            this.predProbs.setBounds(52, 24, 187, 18);
            this.predProbs.addFocusListener(this);
            this.diag = new JCheckBox();
            this.optionsPanel.add(this.diag);
            this.diag.setText("Diagonal line");
            this.diag.setBounds(52, 49, 187, 18);
            this.diag.addFocusListener(this);
            this.auc = new JCheckBox();
            this.optionsPanel.add(this.auc);
            this.auc.setText("AUC");
            this.auc.setBounds(52, 74, 187, 18);
            this.auc.addFocusListener(this);
            this.okayCancel = new OkayCancelPanel(false, false, this);
            this.getContentPane().add(this.okayCancel);
            this.okayCancel.setBounds(93, 147, 174, 37);
            this.setSize(287, 230);
            this.setTitle("Receiver Operating Characteristic");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setModel(LogisticModel logisticModel) {
        this.model = logisticModel;
        this.roc.setSelected(this.model.roc.roc);
        this.predProbs.setSelected(this.model.roc.predProbs);
        this.diag.setSelected(this.model.roc.diag);
        this.auc.setSelected(this.model.roc.auc);
    }

    public void updateModel() {
        this.model.roc.roc = this.roc.isSelected();
        this.model.roc.predProbs = this.predProbs.isSelected();
        this.model.roc.diag = this.diag.isSelected();
        this.model.roc.auc = this.auc.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "OK") {
            this.updateModel();
            this.dispose();
        } else if (string == "Cancel") {
            this.dispose();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.roc.setSelected(true);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }
}

