/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.exprtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import net.sf.jclec.exprtree.ExprTree;
import net.sf.jclec.exprtree.ExprTreeIndividual;
import net.sf.jclec.exprtree.IExprTreeSpecies;
import net.sf.jclec.exprtree.IPrimitive;
import net.sf.jclec.util.random.IRandGen;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExprTreeSpecies<I extends ExprTreeIndividual>
implements IExprTreeSpecies<I> {
    protected ExprTreeSchema[] genotypeSchema;

    @Override
    public int numberOfExprTrees() {
        return this.genotypeSchema.length;
    }

    @Override
    public IExprTreeSpecies.IExprTreeSchema[] getGenotypeSchema() {
        return this.genotypeSchema;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ExprTreeSchema
    implements IExprTreeSpecies.IExprTreeSchema {
        protected int minTreeSize;
        protected int maxTreeSize;
        protected Class<?> rootType;
        protected IPrimitive[] terminals;
        protected IPrimitive[] functions;
        protected HashMap<Class, IPrimitive[]> allMap;
        protected HashMap<Class, IPrimitive[]> termMap;
        protected HashMap<Class, IPrimitive[]> funcMap;

        protected ExprTreeSchema() {
        }

        @Override
        public int getMinTreeSize() {
            return this.minTreeSize;
        }

        @Override
        public int getMaxTreeSize() {
            return this.maxTreeSize;
        }

        @Override
        public Class<?> getRootType() {
            return this.rootType;
        }

        @Override
        public int getNumFunctionBlocks(Class<?> rtype) {
            return this.funcMap.get(rtype).length;
        }

        @Override
        public IPrimitive getTerminalBlock(Class<?> rtype, IRandGen randgen) {
            IPrimitive[] termBlocks = this.termMap.get(rtype);
            IPrimitive result = termBlocks[randgen.choose(0, termBlocks.length)];
            return result.instance();
        }

        @Override
        public IPrimitive getFunctionBlock(Class<?> rtype, IRandGen randgen) {
            IPrimitive[] funcBlocks = this.funcMap.get(rtype);
            IPrimitive result = funcBlocks[randgen.choose(0, funcBlocks.length)];
            return result.instance();
        }

        @Override
        public IPrimitive getFunctionBlock(Class<?> rtype, IRandGen randgen, int arity) {
            IPrimitive result;
            IPrimitive[] funcBlocks = this.funcMap.get(rtype);
            while ((result = funcBlocks[randgen.choose(0, funcBlocks.length)]).argumentTypes().length != arity) {
            }
            return result.instance();
        }

        @Override
        public IPrimitive getFunctionBlockBetweenMinMaxArity(Class<?> rtype, IRandGen randgen, int minArity, int maxArity) {
            IPrimitive[] funcBlocks = this.funcMap.get(rtype);
            int initialIndex = 0;
            int finalIndex = 0;
            while (finalIndex < funcBlocks.length) {
                if (funcBlocks[finalIndex].argumentTypes().length < minArity) {
                    ++initialIndex;
                }
                if (funcBlocks[finalIndex].argumentTypes().length > maxArity) break;
                ++finalIndex;
            }
            if (finalIndex == 0) {
                return null;
            }
            return funcBlocks[randgen.choose(initialIndex, finalIndex)];
        }

        @Override
        public IPrimitive getAnyBlock(Class<?> rtype, IRandGen randgen) {
            IPrimitive[] allBlocks = this.allMap.get(rtype);
            IPrimitive result = allBlocks[randgen.choose(0, allBlocks.length)];
            return result.instance();
        }

        @Override
        public IPrimitive getAnyBlock(Class<?> rtype, IRandGen randgen, int arity) {
            IPrimitive result;
            IPrimitive[] allBlocks = this.allMap.get(rtype);
            while ((result = allBlocks[randgen.choose(0, allBlocks.length)]).argumentTypes().length != arity) {
            }
            return result.instance();
        }

        @Override
        public ExprTree createExprTree(int maxSize, IRandGen randgen) {
            ExprTree result = new ExprTree();
            this.fillExprBranch(result, this.rootType, maxSize, randgen);
            return result;
        }

        @Override
        public void fillExprBranch(ExprTree exprTree, Class<?> returnType, int maxSize, IRandGen randgen) {
            IPrimitive root = maxSize == 1 ? this.getTerminalBlock(returnType, randgen) : this.getBranchBlock(returnType, randgen, maxSize - 1);
            exprTree.addBlock(root);
            Class<?>[] sonTypes = root.argumentTypes();
            int numberOfSons = sonTypes.length;
            if (numberOfSons != 0) {
                int newMaxSize = (maxSize - 1) / numberOfSons;
                if (newMaxSize < 1) {
                    newMaxSize = 1;
                }
                int i = 0;
                while (i < numberOfSons) {
                    this.fillExprBranch(exprTree, sonTypes[i], newMaxSize, randgen);
                    ++i;
                }
            }
        }

        public boolean equals(Object other) {
            if (other instanceof ExprTreeSchema) {
                ExprTreeSchema cother = (ExprTreeSchema)other;
                EqualsBuilder eb = new EqualsBuilder();
                eb.append(this.minTreeSize, cother.minTreeSize);
                eb.append(this.maxTreeSize, cother.maxTreeSize);
                eb.append(this.rootType, cother.rootType);
                eb.append(this.functions, cother.functions);
                eb.append(this.terminals, cother.terminals);
                return eb.isEquals();
            }
            return false;
        }

        protected final void generateBlockMaps() {
            Class<?> returnType;
            IPrimitive block;
            Comparator<IPrimitive> arityComparator = new Comparator<IPrimitive>(){

                @Override
                public int compare(IPrimitive one, IPrimitive two) {
                    int twoarity;
                    int onearity = one.argumentTypes().length;
                    if (onearity > (twoarity = two.argumentTypes().length)) {
                        return 1;
                    }
                    if (onearity < twoarity) {
                        return -1;
                    }
                    return 0;
                }
            };
            HashMap allMapTmp = new HashMap();
            HashMap termMapTmp = new HashMap();
            HashMap funcMapTmp = new HashMap();
            IPrimitive[] iPrimitiveArray = this.terminals;
            int n = 0;
            int n2 = iPrimitiveArray.length;
            while (n < n2) {
                block = iPrimitiveArray[n];
                returnType = block.returnType();
                if (!allMapTmp.containsKey(returnType)) {
                    allMapTmp.put(returnType, new ArrayList());
                    termMapTmp.put(returnType, new ArrayList());
                }
                ((ArrayList)allMapTmp.get(returnType)).add(block);
                ((ArrayList)termMapTmp.get(returnType)).add(block);
                ++n;
            }
            iPrimitiveArray = this.functions;
            n = 0;
            n2 = iPrimitiveArray.length;
            while (n < n2) {
                block = iPrimitiveArray[n];
                returnType = block.returnType();
                if (!allMapTmp.containsKey(returnType)) {
                    allMapTmp.put(returnType, new ArrayList());
                }
                ((ArrayList)allMapTmp.get(returnType)).add(block);
                if (!funcMapTmp.containsKey(returnType)) {
                    funcMapTmp.put(returnType, new ArrayList());
                }
                ((ArrayList)funcMapTmp.get(returnType)).add(block);
                ++n;
            }
            this.allMap = new HashMap();
            for (Class key : allMapTmp.keySet()) {
                IPrimitive[] aux = ((ArrayList)allMapTmp.get(key)).toArray(new IPrimitive[0]);
                Arrays.sort(aux, arityComparator);
                this.allMap.put(key, aux);
            }
            this.termMap = new HashMap();
            for (Class key : termMapTmp.keySet()) {
                IPrimitive[] aux = ((ArrayList)termMapTmp.get(key)).toArray(new IPrimitive[0]);
                Arrays.sort(aux, arityComparator);
                this.termMap.put(key, aux);
            }
            this.funcMap = new HashMap();
            for (Class key : funcMapTmp.keySet()) {
                IPrimitive[] aux = ((ArrayList)funcMapTmp.get(key)).toArray(new IPrimitive[0]);
                Arrays.sort(aux, arityComparator);
                this.funcMap.put(key, aux);
            }
        }

        protected final IPrimitive getBranchBlock(Class<?> returnType, IRandGen randgen, int arity) {
            IPrimitive[] funcBlocks = this.funcMap.get(returnType);
            int auxIndex = 0;
            while (auxIndex < funcBlocks.length) {
                if (funcBlocks[auxIndex].argumentTypes().length > arity) break;
                ++auxIndex;
            }
            if (auxIndex == 0) {
                return this.getTerminalBlock(returnType, randgen);
            }
            return funcBlocks[randgen.choose(0, auxIndex)];
        }
    }
}

