/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.MCA;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.MCA.DistanceMatrixByClass;
import keel.Algorithms.Instance_Generation.PNN.PNNGenerator;
import keel.Algorithms.Instance_Generation.utilities.Debug;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Pair;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class MCAGenerator
extends PNNGenerator {
    protected double currentAccuracy = 0.0;

    public MCAGenerator(PrototypeSet _trainingDataSet, Parameters parameters) {
        super(_trainingDataSet, parameters);
        this.algorithmName = "MCA";
    }

    public MCAGenerator(PrototypeSet _trainingDataSet) {
        super(_trainingDataSet);
        this.algorithmName = "MCA";
    }

    protected static ArrayList<Pair<Prototype, Prototype>> removeFromCandidates(ArrayList<Pair<Prototype, Prototype>> nearest, Prototype p) {
        ArrayList<Pair<Prototype, Prototype>> modified = new ArrayList<Pair<Prototype, Prototype>>();
        for (Pair<Prototype, Prototype> pp : nearest) {
            if (pp.first() == p || pp.second() == p) continue;
            modified.add(pp);
        }
        return modified;
    }

    protected Prototype makeAveragePrototype(Prototype p, Prototype q) {
        Prototype pStar = p.avg(q);
        return pStar;
    }

    protected boolean isConsistent(PrototypeSet modified) {
        double accuracyWithPStar = MCAGenerator.accuracy(modified, this.trainingDataSet);
        boolean foundBetter = accuracyWithPStar >= this.currentAccuracy;
        return foundBetter;
    }

    @Override
    public PrototypeSet reduceSet() {
        int counterOfMerges = 0;
        PrototypeSet V = new PrototypeSet(this.trainingDataSet);
        for (int j = 0; j < V.size(); ++j) {
            for (int i = 0; i < V.size(); ++i) {
                ((Prototype)V.get(i)).setIndex(i);
            }
        }
        Random r = new Random();
        r.setSeed(SEED);
        this.currentAccuracy = MCAGenerator.accuracy(V, this.trainingDataSet);
        do {
            DistanceMatrixByClass distance = new DistanceMatrixByClass(V);
            HashMap<Double, ArrayList<Pair<Prototype, Prototype>>> nearest = distance.nearnestPrototypesForEachClass();
            counterOfMerges = 0;
            ArrayList<Double> labels = new ArrayList<Double>(nearest.keySet());
            Collections.shuffle(labels, r);
            for (double label : labels) {
                int sizeLabel = nearest.get(label).size();
                boolean foundBetter = false;
                for (int index = 0; !foundBetter && index < sizeLabel; ++index) {
                    Prototype p = nearest.get(label).get(index).first();
                    Prototype q = nearest.get(label).get(index).second();
                    if (!V.pertenece(p) || !V.pertenece(q)) continue;
                    Prototype pStar = this.makeAveragePrototype(p, q);
                    PrototypeSet modified = V.copy();
                    modified.remove(p);
                    modified.remove(q);
                    modified.add(pStar);
                    double newAcc = MCAGenerator.accuracy(modified, this.trainingDataSet);
                    if (!(newAcc >= this.currentAccuracy)) continue;
                    V.remove(p);
                    V.remove(q);
                    V.add(pStar);
                    this.currentAccuracy = newAcc;
                    ++counterOfMerges;
                    for (int j = 0; j < V.size(); ++j) {
                        for (int i = 0; i < V.size(); ++i) {
                            ((Prototype)V.get(i)).setIndex(i);
                        }
                    }
                }
            }
        } while (counterOfMerges > 0);
        System.out.println("Accuracy = " + this.currentAccuracy);
        System.out.println("Reduction % " + (100 - V.size() * 100 / this.trainingDataSet.size()));
        return V;
    }

    public static void main(String[] args) {
        Debug.setStdDebugMode(false);
        Parameters.setUse("MCA", "<seed>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        MCAGenerator.setSeed(seed);
        MCAGenerator generator = new MCAGenerator(training);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy1NN(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

