/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOEA_Ghosh;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOEA_Ghosh.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOEA_Ghosh.Chromosome;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOEA_Ghosh.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOEA_Ghosh.LimitRoulette;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOEA_Ghosh.Lists;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOEA_Ghosh.myDataset;
import org.core.Randomize;

public class MOEA_GhoshProcess {
    private String paretos;
    private myDataset dataset;
    private int nTrials;
    private int pointCrossover;
    private int numObjectives;
    private double pc;
    private double pm;
    private double af;
    private int uPopSize;
    private int nAttr;
    private int nTrans;
    private int trials;
    private int max_rank;
    private ArrayList<Chromosome> uPop;
    private ArrayList<Chromosome> child_pop;
    private ArrayList<Chromosome> separate_pop;

    public MOEA_GhoshProcess(myDataset dataset, int numObjectives, int nTrials, int popSize, int pointCrossover, double pc, double pm, double af) {
        this.dataset = dataset;
        this.nTrials = nTrials;
        this.uPopSize = popSize;
        this.pointCrossover = pointCrossover;
        this.pc = pc;
        this.pm = pm;
        this.af = af;
        this.numObjectives = numObjectives;
        this.nAttr = this.dataset.getnVars();
        this.nTrans = this.dataset.getnTrans();
        this.trials = 0;
        this.paretos = new String("");
        this.uPop = new ArrayList();
        this.child_pop = new ArrayList();
        this.separate_pop = new ArrayList();
    }

    public void run() {
        int nGn = 0;
        int rescue = 10000;
        this.trials = 0;
        this.paretos = new String("");
        System.out.print("Initialization ");
        this.initializePopulation();
        do {
            System.out.println("Computing Generation " + (nGn + 1));
            this.assign_rank(this.uPop);
            this.assign_fitness();
            this.update_separate_pop();
            this.selection();
            this.genetic_operators();
            ++nGn;
            if (this.trials <= rescue || rescue >= this.nTrials) continue;
            rescue += 10000;
        } while (this.trials < this.nTrials);
        this.printPareto();
        System.out.println("done.\n");
    }

    private void initializePopulation() {
        int i;
        this.uPop.clear();
        ArrayList<Integer> tr_not_marked = new ArrayList<Integer>();
        Gene[] rnd_genes = new Gene[this.nAttr];
        int[] sample = new int[this.nAttr];
        this.trials = 0;
        for (i = 0; i < this.nAttr; ++i) {
            rnd_genes[i] = new Gene();
        }
        for (i = 0; i < this.nAttr; ++i) {
            sample[i] = i;
        }
        for (i = 0; i < this.nTrans; ++i) {
            tr_not_marked.add(i);
        }
        while (this.uPop.size() <= this.uPopSize) {
            if (tr_not_marked.size() == 0) {
                for (i = 0; i < this.nTrans; ++i) {
                    tr_not_marked.add(i);
                }
            }
            int pos = (Integer)tr_not_marked.get(Randomize.Randint(0, tr_not_marked.size()));
            double[] example = this.dataset.getExample(pos);
            for (i = 0; i < this.nAttr; ++i) {
                int j = Randomize.Randint(0, this.nAttr);
                int tmp = sample[i];
                sample[i] = sample[j];
                sample[j] = tmp;
            }
            for (i = 0; i < this.nAttr; ++i) {
                rnd_genes[sample[i]].setAttr(sample[i]);
                rnd_genes[sample[i]].setActAs(Randomize.RandintClosed(0, 2));
                double value = example[sample[i]];
                int operator = this.dataset.getAttributeType(sample[i]) != 0 ? (this.dataset.getAttributeType(sample[i]) == 2 ? Randomize.RandintClosed(1, 2) : Randomize.RandintClosed(1, 2)) : Randomize.RandintClosed(3, 4);
                rnd_genes[sample[i]].setValue(value);
                rnd_genes[sample[i]].setOperator(operator);
            }
            Chromosome chromo = new Chromosome(rnd_genes, this.numObjectives);
            chromo.forceConsistency();
            chromo.computeObjetives(this.dataset);
            ++this.trials;
            if (this.equalChromotoPop(chromo, this.uPop)) continue;
            this.uPop.add(chromo);
            this.deleteTransCovered(chromo, tr_not_marked);
        }
    }

    private void deleteTransCovered(Chromosome chromo, ArrayList<Integer> tr_not_marked) {
        for (int i = tr_not_marked.size() - 1; i >= 0; --i) {
            double[] example = this.dataset.getExample(tr_not_marked.get(i));
            if (!chromo.isCovered(example)) continue;
            tr_not_marked.remove(i);
        }
    }

    private boolean equalChromotoPop(Chromosome chromo, ArrayList<Chromosome> pop) {
        boolean value = false;
        for (int i = 0; !value && i < pop.size(); ++i) {
            Chromosome aux = pop.get(i);
            if (!chromo.equals(aux)) continue;
            value = true;
        }
        return value;
    }

    private void selection() {
        this.child_pop.clear();
        List<LimitRoulette> Listlimit = this.getLimitRoulette();
        while (this.child_pop.size() < this.uPopSize) {
            Chromosome chr = this.roulette(Listlimit);
            this.child_pop.add(chr);
        }
        this.uPop.clear();
        this.uPop = (ArrayList)this.child_pop.clone();
    }

    private void genetic_operators() {
        for (int i = 0; i < this.uPop.size(); i += 2) {
            Chromosome dad = this.uPop.get(i);
            Chromosome mom = this.uPop.get(i + 1);
            if (!(Randomize.Rand() < this.pc)) continue;
            ArrayList<Chromosome> children = this.multipoint_crossover(dad, mom);
            this.uPop.set(i, children.get(0));
            this.uPop.set(i + 1, children.get(1));
        }
    }

    private void update_separate_pop() {
        int i;
        boolean finish_rank = false;
        Collections.sort(this.uPop);
        for (i = 0; i < this.uPop.size() && !finish_rank; ++i) {
            if (this.uPop.get(i).getRank() == 1) {
                if (this.equalChromotoPop(this.uPop.get(i), this.separate_pop)) continue;
                this.separate_pop.add(this.uPop.get(i).copy());
                continue;
            }
            finish_rank = true;
        }
        this.assign_rank(this.separate_pop);
        finish_rank = false;
        Collections.sort(this.separate_pop);
        for (i = this.separate_pop.size() - 1; i > 0 && !finish_rank; --i) {
            if (this.separate_pop.get(i).getRank() != 1) {
                this.separate_pop.remove(i);
                continue;
            }
            finish_rank = true;
        }
    }

    private ArrayList<Chromosome> multipoint_crossover(Chromosome dad, Chromosome mom) {
        Gene[] genesSon1 = new Gene[this.nAttr];
        Gene[] genesSon2 = new Gene[this.nAttr];
        ArrayList<Integer> crosspoints = this.cross_points();
        ArrayList<Chromosome> children = new ArrayList<Chromosome>();
        int posini = 0;
        int posfin = crosspoints.get(0);
        boolean crossover = true;
        for (int i = 0; i < crosspoints.size(); ++i) {
            int j;
            if (crossover) {
                for (j = posini; j < posfin; ++j) {
                    genesSon1[j] = dad.getGene(j).copy();
                    genesSon2[j] = mom.getGene(j).copy();
                }
            } else {
                for (j = posini; j < posfin; ++j) {
                    genesSon2[j] = dad.getGene(j).copy();
                    genesSon1[j] = mom.getGene(j).copy();
                }
            }
            if (i >= crosspoints.size() - 1) continue;
            crossover = !crossover;
            posini = crosspoints.get(i);
            posfin = crosspoints.get(i + 1);
        }
        Chromosome son1 = new Chromosome(genesSon1, this.numObjectives);
        Chromosome son2 = new Chromosome(genesSon2, this.numObjectives);
        if (Randomize.Rand() < this.pm) {
            this.mutate(son1);
        }
        if (Randomize.Rand() < this.pm) {
            this.mutate(son2);
        }
        son1.forceConsistency();
        son2.forceConsistency();
        son1.computeObjetives(this.dataset);
        son2.computeObjetives(this.dataset);
        this.trials += 2;
        children.add(son1);
        children.add(son2);
        return children;
    }

    private ArrayList<Integer> cross_points() {
        ArrayList<Integer> points = new ArrayList<Integer>();
        for (int i = 0; i < this.pointCrossover; ++i) {
            Integer num = Randomize.Randint(0, this.nAttr);
            while (points.contains(num)) {
                num = Randomize.Randint(0, this.nAttr);
            }
            int j = 0;
            boolean found = false;
            while (j < i && !found) {
                if (points.get(j) > num) {
                    found = true;
                    continue;
                }
                ++j;
            }
            points.add(j, num);
        }
        points.add(this.nAttr);
        return points;
    }

    private void mutate(Chromosome chr) {
        int i = Randomize.Randint(0, this.nAttr);
        Gene gene = chr.getGene(i);
        double type_attr = this.dataset.getAttributeType(i);
        double min_attr = this.dataset.getMin(i);
        double max_attr = this.dataset.getMax(i);
        if (type_attr != 0.0) {
            if (type_attr == 2.0) {
                gene.setValue(Randomize.RanddoubleClosed(min_attr, max_attr));
            } else {
                gene.setValue(Randomize.RandintClosed((int)min_attr, (int)max_attr));
            }
            gene.setOperator(gene.randOperatorNumeric());
        } else {
            gene.setValue(Randomize.RandintClosed((int)min_attr, (int)max_attr));
            gene.setOperator(gene.randOperatorNominal());
        }
        gene.setActAs(gene.randAct());
        chr.forceConsistency();
        chr.computeObjetives(this.dataset);
    }

    private List<LimitRoulette> getLimitRoulette() {
        double totalWeight = 0.0;
        for (int i = 0; i < this.uPop.size(); ++i) {
            totalWeight = this.uPop.get(i).getFitness_rank() + totalWeight;
        }
        ArrayList<Double> listProb = new ArrayList<Double>();
        for (int i = 0; i < this.uPop.size(); ++i) {
            double probF = this.uPop.get(i).getFitness_rank() / totalWeight;
            listProb.add(probF);
        }
        ArrayList<LimitRoulette> listLimit = new ArrayList<LimitRoulette>();
        double limitHigh = 0.0;
        double limitLow = 0.0;
        for (int i = 0; i < listProb.size(); ++i) {
            LimitRoulette limitRoulette = new LimitRoulette();
            limitHigh = (Double)listProb.get(i) + limitHigh;
            limitRoulette.setLimitHigh(limitHigh);
            limitRoulette.setLimitLow(limitLow);
            limitLow = limitHigh;
            limitRoulette.setChromosome(this.uPop.get(i));
            listLimit.add(limitRoulette);
        }
        return listLimit;
    }

    private Chromosome roulette(List<LimitRoulette> listLimit) {
        double numbAleatory = Randomize.Rand();
        boolean find = false;
        int i = 0;
        while (!find && i < listLimit.size()) {
            if (listLimit.get(i).getLimitLow() <= numbAleatory && numbAleatory <= listLimit.get(i).getLimitHigh()) {
                find = true;
                continue;
            }
            ++i;
        }
        return listLimit.get(i).getChromosome();
    }

    private int check_dominance(Chromosome a, Chromosome b) {
        boolean flag1 = false;
        boolean flag2 = false;
        for (int i = 0; i < this.numObjectives; ++i) {
            if (a.getObjective(i) > b.getObjective(i)) {
                flag1 = true;
                continue;
            }
            if (!(a.getObjective(i) < b.getObjective(i))) continue;
            flag2 = true;
        }
        if (flag1 && !flag2) {
            return 1;
        }
        if (!flag1 && flag2) {
            return -1;
        }
        return 0;
    }

    private void assign_rank(ArrayList<Chromosome> new_pop) {
        int rank = 1;
        Lists orig = new Lists();
        Lists cur = new Lists();
        int front_size = 0;
        Lists temp1 = orig;
        for (int i = 0; i < new_pop.size(); ++i) {
            temp1.insert(temp1, i);
            temp1 = temp1.child;
        }
        do {
            if (orig.child.child == null) {
                new_pop.get((int)orig.child.index).rank = rank;
                break;
            }
            temp1 = orig.child;
            temp1.insert(cur, temp1.index);
            front_size = 1;
            Lists temp2 = cur.child;
            temp1 = temp1.del(temp1);
            temp1 = temp1.child;
            do {
                int flag;
                boolean end;
                temp2 = cur.child;
                do {
                    end = false;
                    flag = this.check_dominance(new_pop.get(temp1.index), new_pop.get(temp2.index));
                    if (flag == 1) {
                        temp1.insert(orig, temp2.index);
                        temp2 = temp2.del(temp2);
                        --front_size;
                        temp2 = temp2.child;
                    }
                    if (flag == 0) {
                        temp2 = temp2.child;
                    }
                    if (flag != -1) continue;
                    end = true;
                } while (!end && temp2 != null);
                if (flag != 0 && flag != 1) continue;
                temp1.insert(cur, temp1.index);
                ++front_size;
                temp1 = temp1.del(temp1);
            } while ((temp1 = temp1.child) != null);
            temp2 = cur.child;
            do {
                new_pop.get((int)temp2.index).rank = rank;
            } while ((temp2 = temp2.child) != null);
            temp2 = cur.child;
            do {
                temp2 = temp2.del(temp2);
                temp2 = temp2.child;
            } while (cur.child != null);
            ++rank;
        } while (orig.child != null);
        this.max_rank = rank;
    }

    private void assign_fitness() {
        for (int i = 0; i < this.uPop.size(); ++i) {
            this.uPop.get(i).computeFitness(this.max_rank);
        }
    }

    public ArrayList<AssociationRule> generateRulesPareto() {
        ArrayList<AssociationRule> rulesPareto = new ArrayList<AssociationRule>();
        boolean stop = false;
        for (int i = 0; i < this.separate_pop.size() && !stop; ++i) {
            Chromosome chromo = this.separate_pop.get(i);
            if (chromo.getRank() < 2) {
                rulesPareto.add(new AssociationRule(chromo));
                continue;
            }
            stop = true;
        }
        return rulesPareto;
    }

    static double roundDouble(double number, int decimalPlace) {
        if (!Double.isInfinite(number) && !Double.isNaN(number)) {
            BigDecimal bd = new BigDecimal(number);
            bd = bd.setScale(decimalPlace, 0);
            double numberRound = bd.doubleValue();
            return numberRound;
        }
        return number;
    }

    public void saveReport(ArrayList<AssociationRule> rules, PrintWriter w) {
        int i;
        double avg_yulesQ = 0.0;
        double avg_sup = 0.0;
        double avg_conf = 0.0;
        double avg_ant_length = 0.0;
        double avg_lift = 0.0;
        double avg_conv = 0.0;
        double avg_CF = 0.0;
        double avg_netConf = 0.0;
        int[] covered = new int[this.nTrans];
        for (i = 0; i < this.nTrans; ++i) {
            covered[i] = 0;
        }
        for (int r = 0; r < rules.size(); ++r) {
            AssociationRule rule = rules.get(r);
            avg_sup += rule.getSupport();
            avg_conf += rule.getConfidence();
            avg_lift += rule.getLift();
            avg_ant_length += (double)(rule.getnAnts() + rule.getConsequents().size());
            avg_conv += rule.getConv();
            avg_CF += rule.getCF();
            avg_netConf += rule.getNetConf();
            avg_yulesQ += rule.getYulesQ();
            for (int j = 0; j < this.nTrans; ++j) {
                if (covered[j] >= 1 || !rule.isCovered(this.dataset.getExample(j))) continue;
                covered[j] = 1;
            }
        }
        int cnt_cov_rec = 0;
        for (i = 0; i < this.nTrans; ++i) {
            cnt_cov_rec += covered[i];
        }
        w.println("\nNumber of Frequent Itemsets found: -");
        System.out.println("\nNumber of Frequent Itemsets found: -");
        w.println("\nNumber of Association Rules generated: " + rules.size());
        System.out.println("\nNumber of Association Rules generated: " + rules.size());
        if (!rules.isEmpty()) {
            w.println("Average Support: " + MOEA_GhoshProcess.roundDouble(avg_sup / (double)rules.size(), 2));
            System.out.println("Average Support: " + MOEA_GhoshProcess.roundDouble(avg_sup / (double)rules.size(), 2));
            w.println("Average Confidence: " + MOEA_GhoshProcess.roundDouble(avg_conf / (double)rules.size(), 2));
            System.out.println("Average Confidence: " + MOEA_GhoshProcess.roundDouble(avg_conf / (double)rules.size(), 2));
            w.println("Average Lift: " + MOEA_GhoshProcess.roundDouble(avg_lift / (double)rules.size(), 2));
            System.out.println("Average Lift: " + MOEA_GhoshProcess.roundDouble(avg_lift / (double)rules.size(), 2));
            w.println("Average Conviction: " + MOEA_GhoshProcess.roundDouble(avg_conv / (double)rules.size(), 2));
            System.out.println("Average Conviction: " + MOEA_GhoshProcess.roundDouble(avg_conv / (double)rules.size(), 2));
            w.println("Average Certain Factor: " + MOEA_GhoshProcess.roundDouble(avg_CF / (double)rules.size(), 2));
            System.out.println("Average Certain Factor: " + MOEA_GhoshProcess.roundDouble(avg_CF / (double)rules.size(), 2));
            w.println("Average Netconf: " + MOEA_GhoshProcess.roundDouble(avg_netConf / (double)rules.size(), 2));
            System.out.println("Average Netconf: " + MOEA_GhoshProcess.roundDouble(avg_netConf / (double)rules.size(), 2));
            w.println("Average YulesQ: " + MOEA_GhoshProcess.roundDouble(avg_yulesQ / (double)rules.size(), 2));
            System.out.println("Average YulesQ: " + MOEA_GhoshProcess.roundDouble(avg_yulesQ / (double)rules.size(), 2));
            w.println("Average Number of Antecedents: " + MOEA_GhoshProcess.roundDouble(avg_ant_length / (double)rules.size(), 2));
            System.out.println("Average Number of Antecedents: " + MOEA_GhoshProcess.roundDouble(avg_ant_length / (double)rules.size(), 2));
            w.println("Number of Covered Records (%): " + MOEA_GhoshProcess.roundDouble(100.0 * (double)cnt_cov_rec / (double)this.nTrans, 2));
            System.out.println("Number of Covered Records (%): " + MOEA_GhoshProcess.roundDouble(100.0 * (double)cnt_cov_rec / (double)this.nTrans, 2));
        } else {
            System.out.println("No Statistics.");
        }
    }

    public void printPareto() {
        boolean stop = false;
        this.paretos = this.paretos + "";
        this.paretos = this.paretos + "Support\tantecedent_support\tconsequent_support\tConfidence\tLift\tConv\tCF\tNetConf\tYulesQ\tnAttributes\n";
        for (int i = 0; i < this.separate_pop.size() && !stop; ++i) {
            Chromosome chromo = this.separate_pop.get(i);
            if (chromo.getRank() < 2) {
                this.paretos = this.paretos + "" + MOEA_GhoshProcess.roundDouble(chromo.getSupport(), 2) + "\t" + MOEA_GhoshProcess.roundDouble(chromo.getAntsSupport(), 2) + "\t" + MOEA_GhoshProcess.roundDouble(chromo.getConsSupport(), 2) + "\t" + MOEA_GhoshProcess.roundDouble(chromo.getConfidence(), 2) + "\t" + MOEA_GhoshProcess.roundDouble(chromo.getLift(), 2) + "\t" + MOEA_GhoshProcess.roundDouble(chromo.getConv(), 2) + "\t" + MOEA_GhoshProcess.roundDouble(chromo.getCF(), 2) + "\t" + MOEA_GhoshProcess.roundDouble(chromo.getNetConf(), 2) + "\t" + MOEA_GhoshProcess.roundDouble(chromo.getYulesQ(), 2) + "\t" + (chromo.getnAnts() + chromo.getnCons()) + "\n";
                continue;
            }
            stop = true;
        }
    }

    public String getParetos() {
        return this.paretos;
    }
}

