/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables.scheduling;

import choco.kernel.common.IDotty;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.ManagerFactory;
import choco.kernel.model.variables.MultipleVariables;
import choco.kernel.model.variables.VariableManager;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.scheduling.ITaskVariable;
import java.util.Properties;

public class TaskVariable
extends MultipleVariables
implements ITaskVariable<IntegerVariable>,
IDotty {
    protected String variableManager;

    public TaskVariable(String name, IntegerVariable start, IntegerVariable end, IntegerVariable duration) {
        super(true, true, start, end, duration);
        this.setName(name);
    }

    @Override
    public VariableManager<?> getVariableManager() {
        return ManagerFactory.loadVariableManager(this.variableManager);
    }

    @Override
    public final IntegerVariable duration() {
        return (IntegerVariable)this.getVariable(2);
    }

    @Override
    public final IntegerVariable end() {
        return (IntegerVariable)this.getVariable(1);
    }

    @Override
    public final IntegerVariable start() {
        return (IntegerVariable)this.getVariable(0);
    }

    @Override
    public boolean isEquivalentTo(MultipleVariables mv) {
        if (mv instanceof TaskVariable) {
            TaskVariable t = (TaskVariable)mv;
            boolean r = t.start().getIndex() == this.start().getIndex() && t.duration().getIndex() == this.duration().getIndex();
            return r;
        }
        return false;
    }

    @Override
    public String pretty() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.name).append(" {").append(this.start().pretty());
        buffer.append(" + ").append(this.duration().pretty());
        buffer.append(" = ").append(this.end().pretty());
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public String toDotty() {
        StringBuilder b = new StringBuilder();
        b.append(this.getHook()).append("[ shape=record,");
        b.append("label=\"{");
        b.append("{").append(this.start().getLowB());
        b.append("|").append(StringUtils.format(this.duration()));
        b.append("|").append(this.end().getUppB());
        b.append("}|").append(this.getName());
        b.append("}\"];");
        return b.toString();
    }

    @Override
    public final void findManager(Properties propertiesFile) {
        if (this.variableManager == null) {
            this.variableManager = propertiesFile.getProperty(VariableType.TASK.property);
        }
        if (this.variableManager == null) {
            throw new ModelException("Can not find " + this.type.property + " in application.properties");
        }
        super.findManager(propertiesFile);
    }
}

