/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.constraints.reified;

import choco.IPretty;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TLongHashSet;
import java.util.ArrayList;
import java.util.logging.Logger;

public abstract class INode
implements IPretty {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    private static final IntDomainVar[] emptyIntArray = new IntDomainVar[0];
    protected INode[] subtrees;
    private final NodeType type;

    public INode(NodeType type) {
        this.type = type;
    }

    public INode(INode[] subt, NodeType type) {
        this(type);
        this.subtrees = subt;
    }

    public int getNbSubTrees() {
        return this.subtrees.length;
    }

    public INode getSubtree(int i) {
        return this.subtrees[i];
    }

    public IntDomainVar[] getScope(Solver s) {
        try {
            if (this.subtrees.length > 0) {
                IntDomainVar[][] scopes = new IntDomainVar[this.subtrees.length][];
                for (int i = 0; i < this.subtrees.length; ++i) {
                    scopes[i] = this.subtrees[i].getScope(s);
                }
                return this.union(scopes);
            }
            return emptyIntArray;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public IntegerVariable[] getModelScope() {
        if (this.subtrees == null) {
            return null;
        }
        if (this.subtrees.length == 1) {
            return this.subtrees[0].getModelScope();
        }
        IntegerVariable[] vars = this.union(this.subtrees[0].getModelScope(), this.subtrees[1].getModelScope());
        for (int i = 2; i < this.subtrees.length; ++i) {
            vars = this.union(vars, this.subtrees[i].getModelScope());
        }
        return vars;
    }

    public void setIndexes(IntDomainVar[] vs) {
        if (this.subtrees != null) {
            for (int i = 0; i < this.subtrees.length; ++i) {
                this.subtrees[i].setIndexes(vs);
            }
        }
    }

    private IntDomainVar[] union(IntDomainVar[] ... arrays) {
        TLongHashSet indexes = new TLongHashSet();
        ArrayList<IntDomainVar> unionset = new ArrayList<IntDomainVar>();
        for (IntDomainVar[] array : arrays) {
            if (array == null) continue;
            for (IntDomainVar var : array) {
                if (indexes.contains(var.getIndex())) continue;
                indexes.add(var.getIndex());
                unionset.add(var);
            }
        }
        if (unionset.size() > 0) {
            return unionset.toArray(new IntDomainVar[unionset.size()]);
        }
        return emptyIntArray;
    }

    private IntegerVariable[] union(IntegerVariable[] t1, IntegerVariable[] t2) {
        TLongHashSet indexes = new TLongHashSet((t1 == null ? 0 : t1.length) + (t2 == null ? 0 : t2.length));
        IntegerVariable[] unionset = new IntegerVariable[(t1 == null ? 0 : t1.length) + (t2 == null ? 0 : t2.length)];
        int indice = 0;
        if (t1 != null) {
            for (IntegerVariable var : t1) {
                if (indexes.contains(var.getIndex())) continue;
                indexes.add(var.getIndex());
                unionset[indice++] = var;
            }
        }
        if (t2 != null) {
            for (IntegerVariable var : t2) {
                if (indexes.contains(var.getIndex())) continue;
                indexes.add(var.getIndex());
                unionset[indice++] = var;
            }
        }
        IntegerVariable[] uniontab = new IntegerVariable[indice];
        System.arraycopy(unionset, 0, uniontab, 0, indice);
        return uniontab;
    }

    public IntDomainVar extractResult(Solver s) {
        return null;
    }

    public boolean isDecompositionPossible() {
        if (this.subtrees == null) {
            return true;
        }
        for (int i = 0; i < this.subtrees.length; ++i) {
            if (this.subtrees[i].isDecompositionPossible()) continue;
            return false;
        }
        return true;
    }

    public boolean isReified() {
        if (this.subtrees == null) {
            return false;
        }
        for (int i = 0; i < this.subtrees.length; ++i) {
            if (!this.subtrees[i].isReified()) continue;
            return true;
        }
        return false;
    }

    public boolean hasOnlyVariablesLeaves() {
        for (int i = 0; i < this.subtrees.length; ++i) {
            if (this.subtrees[i].isAVariable()) continue;
            return false;
        }
        return true;
    }

    public int countNbVar() {
        int cv = 0;
        for (int i = 0; i < this.subtrees.length; ++i) {
            cv += this.subtrees[i].countNbVar();
        }
        return cv;
    }

    public boolean isAVariable() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isCsteEqualTo(int a) {
        return false;
    }

    public boolean isAConstant() {
        for (int i = 0; i < this.subtrees.length; ++i) {
            if (this.subtrees[i].isAConstant()) continue;
            return false;
        }
        return true;
    }

    public boolean isALinearTerm() {
        return false;
    }

    public int[] computeLinearExpr(int scope) {
        return null;
    }

    public NodeType getType() {
        return this.type;
    }
}

