/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.common.jocl;

import java.io.IOException;
import org.jocl.CL;
import org.jocl.Pointer;
import org.jocl.cl_command_queue;
import org.jocl.cl_context;
import org.jocl.cl_context_properties;
import org.jocl.cl_device_id;
import org.jocl.cl_image_format;
import org.jocl.cl_sampler;
import usf.saav.common.jocl.joclController;
import usf.saav.common.jocl.joclException;
import usf.saav.common.jocl.joclImage;
import usf.saav.common.jocl.joclKernel;
import usf.saav.common.jocl.joclLoader;
import usf.saav.common.jocl.joclMemory;

public class joclDevice {
    cl_command_queue commandQueue;
    cl_context context;
    cl_device_id device_id;

    public joclDevice(cl_context_properties cl_context_properties2, cl_device_id cl_device_id2, boolean bl) {
        this.device_id = cl_device_id2;
        this.context = CL.clCreateContext((cl_context_properties)cl_context_properties2, (int)1, (cl_device_id[])new cl_device_id[]{cl_device_id2}, null, null, null);
        long l = 0L;
        if (bl) {
            l |= 2L;
        }
        this.commandQueue = CL.clCreateCommandQueue((cl_context)this.context, (cl_device_id)cl_device_id2, (long)l, null);
    }

    public void release() {
        CL.clReleaseCommandQueue((cl_command_queue)this.commandQueue);
        CL.clReleaseContext((cl_context)this.context);
    }

    public joclKernel buildProgram(String[] stringArray, String string) {
        return new joclKernel(this, stringArray, string);
    }

    public joclKernel buildProgram(joclLoader joclLoader2, String string) throws IOException {
        return new joclKernel(this, joclLoader2, string);
    }

    public joclMemory createBuffer(String string, long l, long l2, Pointer pointer, int[] nArray) {
        return new joclMemory(this, string, l, l2, pointer, nArray);
    }

    public joclMemory createBuffer(String string, long l, long l2) {
        return new joclMemory(this, string, l, l2, null, null);
    }

    public joclMemory createBuffer(String string, long l, float[] fArray) {
        return new joclMemory(this, string, l, fArray.length * 4, Pointer.to((float[])fArray), null);
    }

    public joclMemory createBuffer(String string, long l, byte[] byArray) {
        return new joclMemory(this, string, l, byArray.length, Pointer.to((byte[])byArray), null);
    }

    public joclImage createImage3D(long l, cl_image_format cl_image_format2, int n, int n2, int n3, float[] fArray) throws joclException {
        return new joclImage(this, l, cl_image_format2, n, n2, n3, Pointer.to((float[])fArray));
    }

    public joclImage createImage2D(long l, cl_image_format cl_image_format2, int n, int n2, float[] fArray) throws joclException {
        return new joclImage(this, l, cl_image_format2, n, n2, Pointer.to((float[])fArray));
    }

    public cl_sampler createSampler(boolean bl, int n, int n2) throws joclException {
        int[] nArray = new int[]{0};
        cl_sampler cl_sampler2 = CL.clCreateSampler((cl_context)this.context, (boolean)bl, (int)n, (int)n2, (int[])nArray);
        if (nArray[0] != 0) {
            throw new joclException();
        }
        return cl_sampler2;
    }

    public boolean isCPU() {
        long l = joclController.getLong(this.device_id, 4096);
        return (l & 2L) != 0L;
    }

    public boolean isGPU() {
        long l = joclController.getLong(this.device_id, 4096);
        return (l & 4L) != 0L;
    }

    public boolean isAccelerator() {
        long l = joclController.getLong(this.device_id, 4096);
        return (l & 8L) != 0L;
    }

    public long[] getMaxWorkDimensionSizes() {
        return joclController.getSizes(this.device_id, 4101, 3);
    }

    public long getMaxWorkSize() {
        return joclController.getSize(this.device_id, 4100);
    }

    public long getMaxWorkGroupSize() {
        return joclController.getSize(this.device_id, 4100);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = joclController.getString(this.device_id, 4139);
        stringBuilder.append("--- Info for device " + string + ": ---\n");
        stringBuilder.append("CL_DEVICE_NAME: \t\t\t" + string + "\n");
        String string2 = joclController.getString(this.device_id, 4140);
        stringBuilder.append("CL_DEVICE_VENDOR: \t\t\t" + string2 + "\n");
        String string3 = joclController.getString(this.device_id, 4141);
        stringBuilder.append("CL_DRIVER_VERSION: \t\t\t" + string3 + "\n");
        long l = joclController.getLong(this.device_id, 4096);
        if ((l & 2L) != 0L) {
            stringBuilder.append("CL_DEVICE_TYPE:\t\t\t\tCL_DEVICE_TYPE_CPU\n");
        }
        if ((l & 4L) != 0L) {
            stringBuilder.append("CL_DEVICE_TYPE:\t\t\t\tCL_DEVICE_TYPE_GPU\n");
        }
        if ((l & 8L) != 0L) {
            stringBuilder.append("CL_DEVICE_TYPE:\t\t\t\tCL_DEVICE_TYPE_ACCELERATOR\n");
        }
        if ((l & 1L) != 0L) {
            stringBuilder.append("CL_DEVICE_TYPE:\t\t\t\tCL_DEVICE_TYPE_DEFAULT\n");
        }
        int n = joclController.getInt(this.device_id, 4098);
        stringBuilder.append("CL_DEVICE_MAX_COMPUTE_UNITS:\t\t" + n + "\n");
        long l2 = joclController.getLong(this.device_id, 4099);
        stringBuilder.append("CL_DEVICE_MAX_WORK_ITEM_DIMENSIONS:\t" + l2 + "\n");
        long[] lArray = joclController.getSizes(this.device_id, 4101, 3);
        stringBuilder.append("CL_DEVICE_MAX_WORK_ITEM_SIZES:\t\t" + lArray[0] + " / " + lArray[1] + " / " + lArray[2] + " \n");
        long l3 = joclController.getSize(this.device_id, 4100);
        stringBuilder.append("CL_DEVICE_MAX_WORK_GROUP_SIZE:\t\t" + l3 + "\n");
        long l4 = joclController.getLong(this.device_id, 4108);
        stringBuilder.append("CL_DEVICE_MAX_CLOCK_FREQUENCY:\t\t" + l4 + " MHz\n");
        int n2 = joclController.getInt(this.device_id, 4109);
        stringBuilder.append("CL_DEVICE_ADDRESS_BITS:\t\t\t" + n2 + "\n");
        long l5 = joclController.getLong(this.device_id, 4112);
        stringBuilder.append("CL_DEVICE_MAX_MEM_ALLOC_SIZE:\t\t" + (int)(l5 / 0x100000L) + " MByte\n");
        long l6 = joclController.getLong(this.device_id, 4127);
        stringBuilder.append("CL_DEVICE_GLOBAL_MEM_SIZE:\t\t" + (int)(l6 / 0x100000L) + " MByte\n");
        int n3 = joclController.getInt(this.device_id, 4132);
        stringBuilder.append("CL_DEVICE_ERROR_CORRECTION_SUPPORT:\t" + (n3 != 0 ? "yes" : "no") + "\n");
        int n4 = joclController.getInt(this.device_id, 4130);
        stringBuilder.append("CL_DEVICE_LOCAL_MEM_TYPE:\t\t" + (n4 == 1 ? "local" : "global") + "\n");
        long l7 = joclController.getLong(this.device_id, 4131);
        stringBuilder.append("CL_DEVICE_LOCAL_MEM_SIZE:\t\t" + (int)(l7 / 1024L) + " KByte\n");
        long l8 = joclController.getLong(this.device_id, 4128);
        stringBuilder.append("CL_DEVICE_MAX_CONSTANT_BUFFER_SIZE:\t" + (int)(l8 / 1024L) + " KByte\n");
        long l9 = joclController.getLong(this.device_id, 4138);
        if ((l9 & 1L) != 0L) {
            stringBuilder.append("CL_DEVICE_QUEUE_PROPERTIES:\t\tCL_QUEUE_OUT_OF_ORDER_EXEC_MODE_ENABLE\n");
        }
        if ((l9 & 2L) != 0L) {
            stringBuilder.append("CL_DEVICE_QUEUE_PROPERTIES:\t\tCL_QUEUE_PROFILING_ENABLE\n");
        }
        int n5 = joclController.getInt(this.device_id, 4118);
        stringBuilder.append("CL_DEVICE_IMAGE_SUPPORT:\t\t" + n5 + "\n");
        int n6 = joclController.getInt(this.device_id, 4110);
        stringBuilder.append("CL_DEVICE_MAX_READ_IMAGE_ARGS:\t\t" + n6 + "\n");
        int n7 = joclController.getInt(this.device_id, 4111);
        stringBuilder.append("CL_DEVICE_MAX_WRITE_IMAGE_ARGS:\t\t" + n7 + "\n");
        long l10 = joclController.getLong(this.device_id, 4123);
        stringBuilder.append("CL_DEVICE_SINGLE_FP_CONFIG:\t\t" + CL.stringFor_cl_device_fp_config((long)l10) + "\n");
        long l11 = joclController.getSize(this.device_id, 4113);
        stringBuilder.append("CL_DEVICE_2D_MAX_WIDTH\t\t\t" + l11 + "\n");
        long l12 = joclController.getSize(this.device_id, 4114);
        stringBuilder.append("CL_DEVICE_2D_MAX_HEIGHT\t\t\t" + l12 + "\n");
        long l13 = joclController.getSize(this.device_id, 4115);
        stringBuilder.append("CL_DEVICE_3D_MAX_WIDTH\t\t\t" + l13 + "\n");
        long l14 = joclController.getSize(this.device_id, 4116);
        stringBuilder.append("CL_DEVICE_3D_MAX_HEIGHT\t\t\t" + l14 + "\n");
        long l15 = joclController.getSize(this.device_id, 4117);
        stringBuilder.append("CL_DEVICE_3D_MAX_DEPTH\t\t\t" + l15 + "\n");
        stringBuilder.append("CL_DEVICE_PREFERRED_VECTOR_WIDTH_<t>\t");
        int n8 = joclController.getInt(this.device_id, 4102);
        int n9 = joclController.getInt(this.device_id, 4103);
        int n10 = joclController.getInt(this.device_id, 4104);
        int n11 = joclController.getInt(this.device_id, 4105);
        int n12 = joclController.getInt(this.device_id, 4106);
        int n13 = joclController.getInt(this.device_id, 4107);
        stringBuilder.append("CHAR " + n8 + ", SHORT " + n9 + ", INT " + n10 + ", LONG " + n11 + ", FLOAT " + n12 + ", DOUBLE " + n13 + "\n\n\n");
        return stringBuilder.toString();
    }
}

