% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.cluster.hyperparms.R
\name{initialize.cluster.hyperparms}
\alias{initialize.cluster.hyperparms}
\title{Initialize cluster hyperparameters}
\usage{
initialize.cluster.hyperparms(
  data,
  model.attributes,
  covariance = FALSE,
  diag.Psi = FALSE,
  vague.mu = FALSE,
  zero.mu = FALSE,
  seed = NULL
)
}
\arguments{
\item{data}{The dataset.}

\item{model.attributes}{Model attributes generated by initialize.model.attributes}

\item{covariance}{Use of covariance matrix of common factors. If FALSE, it uses the correlation matrix.}

\item{diag.Psi}{Diagonal matrix for cluster covariance. If FALSE, it uses the sample covariance.}

\item{vague.mu}{Use of large cluster covariance prior.}

\item{zero.mu}{Set the cluster mean prior at 0. If FALSE, the cluster mean prior are the sample means of the clusters.}

\item{seed}{Optional integer seed for reproducibility.}
}
\value{
A list of mean and variance hyperparameter of mu, and scale hyperparameter of Omega
}
\description{
The function returns list of hyperparmeters for Omegas and mus.
}
