% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{getVarMonitor}
\alias{getVarMonitor}
\title{Retrieve Monitorable Variables}
\usage{
getVarMonitor(object, type = c("name", "list"))
}
\arguments{
\item{object}{A fitted object of \code{BayesSIM}, \code{BayesSIM_setup} or individual model.}

\item{type}{Options for variables. By default, \code{type = "name"} is used that it only prints the name of the node.
If you put name of the nodes, the MCMC outputs gave you all elements of the variable, in case of the vector.
If \code{type = "list"}, the dimension of the nodes are printed. If you put name and dimension of the nodes, only specific location of vector or matrix can be seen in \code{summary} or \code{nimTraceplot}.}
}
\value{
A vector of variables that can be monitored in the model.
}
\description{
Functions for retrieving the variables that can be monitored.
}
\details{
The function returns a list of variables that can be used in \code{monitors2} in the \code{bayesSIM} function.
You can also refer to \code{\link{getModelDef}} to understand the model structure and designate necessary variables.
Stochastic nodes of the model are recommended to be monitored.
}
\examples{
simdata2 <- data.frame(DATA1$X, y = DATA1$y)
models <- BayesSIM_setup(y ~ ., data = simdata2)

# Get monitorable variables
getVarMonitor(models)
# Get the list of variables with dimension
getVarMonitor(models, type = "list")

}
\seealso{
\code{\link{getModelDef}}
}
