% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readData.R
\name{concAO}
\alias{concAO}
\title{Recalculate concentration for the acute oral tests for bees}
\usage{
concAO(cExt, cTime = 0.25, expTime, k_sr = 0.625, binning = 0.5)
}
\arguments{
\item{cExt}{A dataframe of concentrations at time 0 concentration applied}

\item{cTime}{The duration of exposure in days, default is 0.25 d}

\item{expTime}{The duration of the experiment in days}

\item{k_sr}{Stomach release rate (d-1), default is 0.625}

\item{binning}{binning of the time vector, default 0.5 d}
}
\value{
A data frame containing a column with the time points and a column with the
recalculated concentrations
}
\description{
Recalculate concentration for the acute oral tests for bees
}
\examples{
conc <- concAO(cExt = cbind(3.5, 6, 8, 10), cTime = 0.25, expTime = 4)
}
