% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.r
\name{load_biothermr}
\alias{load_biothermr}
\title{Load BioThermR Data from Disk}
\usage{
load_biothermr(file_path)
}
\arguments{
\item{file_path}{String. The full path to the .rds file (e.g., "results/experiment_data.rds").}
}
\value{
A single 'BioThermR' object or a list of 'BioThermR' objects, depending on the structure
        of the saved data.
}
\description{
Restores a previously saved 'BioThermR' object or a list of objects from a .rds file.
             This function is the counterpart to \code{\link{save_biothermr}} and allows you to
             resume analysis from a saved checkpoint.
}
\details{
Upon loading, the function performs an automatic validation check to ensure the
         file contains a valid 'BioThermR' class instance (or a list of them).
         It provides feedback to the console regarding the type and quantity of objects loaded.
}
\seealso{
\code{\link{save_biothermr}}
}
