% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_pyDarwin.R
\name{run_pyDarwin}
\alias{run_pyDarwin}
\title{Run pyDarwin Model Search}
\usage{
run_pyDarwin(
  InterpreterPath,
  Flags = c("-u", "-m"),
  DirectoryPath = ".",
  TemplatePath = "template.txt",
  TokensPath = "tokens.json",
  OptionsPath = "options.json",
  Wait = TRUE
)
}
\arguments{
\item{InterpreterPath}{Character string. The full path to the Python
interpreter executable (e.g., \code{python.exe} or \code{python}).}

\item{Flags}{Character vector. Optional flags passed directly to the Python
interpreter. Defaults to \code{c("-u", "-m")}. \code{-u} forces unbuffered binary
stdout and stderr streams. \code{-m} runs a library module as a script and is
essential for calling \code{darwin.run_search}.}

\item{DirectoryPath}{Character string. Optional path to the directory
containing the \code{template.txt}, \code{tokens.json}, and \code{options.json} files. If
provided, this path is used to locate these files, overriding any directory
information in the \code{TemplatePath}, \code{TokensPath}, and \code{OptionsPath} arguments
(a warning will be issued). Defaults to the current R working directory.}

\item{TemplatePath}{Character string. Path to the pyDarwin template file
(typically \code{template.txt}). If \code{DirectoryPath} is specified, only the
basename of \code{TemplatePath} is used, combined with \code{DirectoryPath}.}

\item{TokensPath}{Character string. Path to the pyDarwin tokens JSON file
(typically \code{tokens.json}). If \code{DirectoryPath} is specified, only the
basename of \code{TokensPath} is used, combined with \code{DirectoryPath}.}

\item{OptionsPath}{Character string. Path to the pyDarwin options JSON file
(typically \code{options.json}). This file defines run settings like
\code{working_dir}, \code{output_dir}, etc. If \code{DirectoryPath} is specified, only the
basename of \code{OptionsPath} is used, combined with \code{DirectoryPath}.}

\item{Wait}{Logical. If \code{TRUE} (default), R waits for the pyDarwin process to
complete before proceeding. If \code{FALSE}, R launches the pyDarwin process in
the background and returns immediately. See the 'Background Execution'
section for important details when using \code{Wait = FALSE}.}
}
\value{
\itemize{
\item If \code{Wait = TRUE}: A list containing the search results read from the
\code{output_dir} (specified in \code{options.json}). This typically includes:
\itemize{
\item \code{results}: A data frame (\code{results.csv}).
\item \code{FinalResultFile}: Character vector containing lines from the
final model's result file (e.g., \code{.lst}, \code{.txt}).
\item \code{FinalControlFile}: Character vector containing lines from the
final model's control file (e.g., \code{.mod}, \code{.mmdl}).
}
If result files are not found, warnings are issued. If no results are
found but \code{messages.txt} exists, its content might be returned with a
warning. If the Python call fails (non-zero exit code), the function stops
with an error.
\item If \code{Wait = FALSE}: A character string giving the full path to the main
pyDarwin log file (\code{messages.txt}) within the \code{working_dir}.
}
}
\description{
This function executes a pyDarwin model search by calling the specified Python
interpreter and the \code{darwin.run_search} module.
}
\section{Background Execution (\code{Wait = FALSE})}{

When \code{Wait} is set to \code{FALSE}, the pyDarwin process is launched in the
background, and the R function returns immediately. This allows R to continue
processing while pyDarwin runs.
\itemize{
\item \strong{Output Redirection:} Standard output (stdout) and standard error
(stderr) from the Python process are redirected to files named
\code{stdout.log} and \code{stderr.log} respectively, within the \code{working_dir}.
These files are crucial for diagnosing issues if the background process
fails or behaves unexpectedly.
\item \strong{Primary Log:} The main pyDarwin log file (\code{messages.txt}, located
in the \code{working_dir}) remains the primary source for detailed run
information, but the \code{stdout.log} and \code{stderr.log} capture console
output and errors directly.
}
}

\examples{
\dontrun{
# Example: Running pyDarwin and waiting for results
# Assuming python is in the PATH and input files are in 'my_project'

results <- run_pyDarwin(
  InterpreterPath = "python",
  DirectoryPath = "my_project",
  Wait = TRUE
)
print(results$results)

# Example: Launching pyDarwin in the background

log_file_path <- run_pyDarwin(
  InterpreterPath = "python",
  DirectoryPath = "my_project",
  Wait = FALSE
)
}

}
\seealso{
\code{\link[=run_pyDarwinRemote]{run_pyDarwinRemote()}}, \code{\link[=reconnect_pyDarwinJob]{reconnect_pyDarwinJob()}}
}
