% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_digit.R
\name{test_check_digit}
\alias{test_check_digit}
\title{Validate an ID Using the Check Digit (DIN ISO 7064, Mod 11,10)}
\usage{
test_check_digit(test)
}
\arguments{
\item{test}{A numeric or character string representing the ID.
It should be exactly 10 digits long, including the check digit.}
}
\value{
A logical value: `TRUE` if the check digit is correct, `FALSE` otherwise.
  Returns `FALSE` with an error message if the input format is invalid.
}
\description{
This function verifies whether a given ID is valid by checking
  its check digit using the DIN ISO 7064, Mod 11,10 algorithm.
}
\details{
The function processes the input as follows:
- If the input has 10 digits and does not start with `0`,
  it is assumed to be a ID with a check digit.
- If the input has 10 digits and starts with `0`, it is considered an old
  ID without a check digit, and validation cannot be performed.
- If the input has 9 digits, it lacks a check digit, so validation is not possible.
- If the input format is invalid, an error message is generated.

The function extracts the main ID (without the check digit), computes the
expected check digit using `calculate_check_digit()`, and compares it with
the provided check digit.
}
\examples{
test_check_digit("1000001381")  # Returns TRUE if the check digit is correct
test_check_digit("1000001121")  # Another valid ID
test_check_digit("1007002482")  # Returns FALSE if the check digit is incorrect

}
